/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3CannedAcl {
    AUTHENTICATED_READ("AUTHENTICATED_READ"),
    BUCKET_OWNER_FULL_CONTROL("BUCKET_OWNER_FULL_CONTROL"),
    BUCKET_OWNER_READ("BUCKET_OWNER_READ"),
    PUBLIC_READ("PUBLIC_READ"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3CannedAcl> VALUE_MAP;
    private final String value;

    private S3CannedAcl(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3CannedAcl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3CannedAcl> knownValues() {
        EnumSet<S3CannedAcl> knownValues = EnumSet.allOf(S3CannedAcl.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3CannedAcl.class, S3CannedAcl::toString);
    }
}

