/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.ColorSpacePassthroughSettings;
import software.amazon.awssdk.services.medialive.model.DolbyVision81Settings;
import software.amazon.awssdk.services.medialive.model.Hdr10Settings;
import software.amazon.awssdk.services.medialive.model.Rec601Settings;
import software.amazon.awssdk.services.medialive.model.Rec709Settings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class H265ColorSpaceSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, H265ColorSpaceSettings> {
    private static final SdkField<ColorSpacePassthroughSettings> COLOR_SPACE_PASSTHROUGH_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColorSpacePassthroughSettings").getter(H265ColorSpaceSettings.getter(H265ColorSpaceSettings::colorSpacePassthroughSettings)).setter(H265ColorSpaceSettings.setter(Builder::colorSpacePassthroughSettings)).constructor(ColorSpacePassthroughSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpacePassthroughSettings").build()}).build();
    private static final SdkField<DolbyVision81Settings> DOLBY_VISION81_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DolbyVision81Settings").getter(H265ColorSpaceSettings.getter(H265ColorSpaceSettings::dolbyVision81Settings)).setter(H265ColorSpaceSettings.setter(Builder::dolbyVision81Settings)).constructor(DolbyVision81Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dolbyVision81Settings").build()}).build();
    private static final SdkField<Hdr10Settings> HDR10_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Hdr10Settings").getter(H265ColorSpaceSettings.getter(H265ColorSpaceSettings::hdr10Settings)).setter(H265ColorSpaceSettings.setter(Builder::hdr10Settings)).constructor(Hdr10Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hdr10Settings").build()}).build();
    private static final SdkField<Rec601Settings> REC601_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rec601Settings").getter(H265ColorSpaceSettings.getter(H265ColorSpaceSettings::rec601Settings)).setter(H265ColorSpaceSettings.setter(Builder::rec601Settings)).constructor(Rec601Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rec601Settings").build()}).build();
    private static final SdkField<Rec709Settings> REC709_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rec709Settings").getter(H265ColorSpaceSettings.getter(H265ColorSpaceSettings::rec709Settings)).setter(H265ColorSpaceSettings.setter(Builder::rec709Settings)).constructor(Rec709Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rec709Settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLOR_SPACE_PASSTHROUGH_SETTINGS_FIELD, DOLBY_VISION81_SETTINGS_FIELD, HDR10_SETTINGS_FIELD, REC601_SETTINGS_FIELD, REC709_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ColorSpacePassthroughSettings colorSpacePassthroughSettings;
    private final DolbyVision81Settings dolbyVision81Settings;
    private final Hdr10Settings hdr10Settings;
    private final Rec601Settings rec601Settings;
    private final Rec709Settings rec709Settings;

    private H265ColorSpaceSettings(BuilderImpl builder) {
        this.colorSpacePassthroughSettings = builder.colorSpacePassthroughSettings;
        this.dolbyVision81Settings = builder.dolbyVision81Settings;
        this.hdr10Settings = builder.hdr10Settings;
        this.rec601Settings = builder.rec601Settings;
        this.rec709Settings = builder.rec709Settings;
    }

    public final ColorSpacePassthroughSettings colorSpacePassthroughSettings() {
        return this.colorSpacePassthroughSettings;
    }

    public final DolbyVision81Settings dolbyVision81Settings() {
        return this.dolbyVision81Settings;
    }

    public final Hdr10Settings hdr10Settings() {
        return this.hdr10Settings;
    }

    public final Rec601Settings rec601Settings() {
        return this.rec601Settings;
    }

    public final Rec709Settings rec709Settings() {
        return this.rec709Settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpacePassthroughSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dolbyVision81Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hdr10Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.rec601Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.rec709Settings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H265ColorSpaceSettings)) {
            return false;
        }
        H265ColorSpaceSettings other = (H265ColorSpaceSettings)obj;
        return Objects.equals(this.colorSpacePassthroughSettings(), other.colorSpacePassthroughSettings()) && Objects.equals(this.dolbyVision81Settings(), other.dolbyVision81Settings()) && Objects.equals(this.hdr10Settings(), other.hdr10Settings()) && Objects.equals(this.rec601Settings(), other.rec601Settings()) && Objects.equals(this.rec709Settings(), other.rec709Settings());
    }

    public final String toString() {
        return ToString.builder((String)"H265ColorSpaceSettings").add("ColorSpacePassthroughSettings", (Object)this.colorSpacePassthroughSettings()).add("DolbyVision81Settings", (Object)this.dolbyVision81Settings()).add("Hdr10Settings", (Object)this.hdr10Settings()).add("Rec601Settings", (Object)this.rec601Settings()).add("Rec709Settings", (Object)this.rec709Settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColorSpacePassthroughSettings": {
                return Optional.ofNullable(clazz.cast(this.colorSpacePassthroughSettings()));
            }
            case "DolbyVision81Settings": {
                return Optional.ofNullable(clazz.cast(this.dolbyVision81Settings()));
            }
            case "Hdr10Settings": {
                return Optional.ofNullable(clazz.cast(this.hdr10Settings()));
            }
            case "Rec601Settings": {
                return Optional.ofNullable(clazz.cast(this.rec601Settings()));
            }
            case "Rec709Settings": {
                return Optional.ofNullable(clazz.cast(this.rec709Settings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<H265ColorSpaceSettings, T> g) {
        return obj -> g.apply((H265ColorSpaceSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ColorSpacePassthroughSettings colorSpacePassthroughSettings;
        private DolbyVision81Settings dolbyVision81Settings;
        private Hdr10Settings hdr10Settings;
        private Rec601Settings rec601Settings;
        private Rec709Settings rec709Settings;

        private BuilderImpl() {
        }

        private BuilderImpl(H265ColorSpaceSettings model) {
            this.colorSpacePassthroughSettings(model.colorSpacePassthroughSettings);
            this.dolbyVision81Settings(model.dolbyVision81Settings);
            this.hdr10Settings(model.hdr10Settings);
            this.rec601Settings(model.rec601Settings);
            this.rec709Settings(model.rec709Settings);
        }

        public final ColorSpacePassthroughSettings.Builder getColorSpacePassthroughSettings() {
            return this.colorSpacePassthroughSettings != null ? this.colorSpacePassthroughSettings.toBuilder() : null;
        }

        public final void setColorSpacePassthroughSettings(ColorSpacePassthroughSettings.BuilderImpl colorSpacePassthroughSettings) {
            this.colorSpacePassthroughSettings = colorSpacePassthroughSettings != null ? colorSpacePassthroughSettings.build() : null;
        }

        @Override
        public final Builder colorSpacePassthroughSettings(ColorSpacePassthroughSettings colorSpacePassthroughSettings) {
            this.colorSpacePassthroughSettings = colorSpacePassthroughSettings;
            return this;
        }

        public final DolbyVision81Settings.Builder getDolbyVision81Settings() {
            return this.dolbyVision81Settings != null ? this.dolbyVision81Settings.toBuilder() : null;
        }

        public final void setDolbyVision81Settings(DolbyVision81Settings.BuilderImpl dolbyVision81Settings) {
            this.dolbyVision81Settings = dolbyVision81Settings != null ? dolbyVision81Settings.build() : null;
        }

        @Override
        public final Builder dolbyVision81Settings(DolbyVision81Settings dolbyVision81Settings) {
            this.dolbyVision81Settings = dolbyVision81Settings;
            return this;
        }

        public final Hdr10Settings.Builder getHdr10Settings() {
            return this.hdr10Settings != null ? this.hdr10Settings.toBuilder() : null;
        }

        public final void setHdr10Settings(Hdr10Settings.BuilderImpl hdr10Settings) {
            this.hdr10Settings = hdr10Settings != null ? hdr10Settings.build() : null;
        }

        @Override
        public final Builder hdr10Settings(Hdr10Settings hdr10Settings) {
            this.hdr10Settings = hdr10Settings;
            return this;
        }

        public final Rec601Settings.Builder getRec601Settings() {
            return this.rec601Settings != null ? this.rec601Settings.toBuilder() : null;
        }

        public final void setRec601Settings(Rec601Settings.BuilderImpl rec601Settings) {
            this.rec601Settings = rec601Settings != null ? rec601Settings.build() : null;
        }

        @Override
        public final Builder rec601Settings(Rec601Settings rec601Settings) {
            this.rec601Settings = rec601Settings;
            return this;
        }

        public final Rec709Settings.Builder getRec709Settings() {
            return this.rec709Settings != null ? this.rec709Settings.toBuilder() : null;
        }

        public final void setRec709Settings(Rec709Settings.BuilderImpl rec709Settings) {
            this.rec709Settings = rec709Settings != null ? rec709Settings.build() : null;
        }

        @Override
        public final Builder rec709Settings(Rec709Settings rec709Settings) {
            this.rec709Settings = rec709Settings;
            return this;
        }

        public H265ColorSpaceSettings build() {
            return new H265ColorSpaceSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, H265ColorSpaceSettings> {
        public Builder colorSpacePassthroughSettings(ColorSpacePassthroughSettings var1);

        default public Builder colorSpacePassthroughSettings(Consumer<ColorSpacePassthroughSettings.Builder> colorSpacePassthroughSettings) {
            return this.colorSpacePassthroughSettings((ColorSpacePassthroughSettings)((ColorSpacePassthroughSettings.Builder)ColorSpacePassthroughSettings.builder().applyMutation(colorSpacePassthroughSettings)).build());
        }

        public Builder dolbyVision81Settings(DolbyVision81Settings var1);

        default public Builder dolbyVision81Settings(Consumer<DolbyVision81Settings.Builder> dolbyVision81Settings) {
            return this.dolbyVision81Settings((DolbyVision81Settings)((DolbyVision81Settings.Builder)DolbyVision81Settings.builder().applyMutation(dolbyVision81Settings)).build());
        }

        public Builder hdr10Settings(Hdr10Settings var1);

        default public Builder hdr10Settings(Consumer<Hdr10Settings.Builder> hdr10Settings) {
            return this.hdr10Settings((Hdr10Settings)((Hdr10Settings.Builder)Hdr10Settings.builder().applyMutation(hdr10Settings)).build());
        }

        public Builder rec601Settings(Rec601Settings var1);

        default public Builder rec601Settings(Consumer<Rec601Settings.Builder> rec601Settings) {
            return this.rec601Settings((Rec601Settings)((Rec601Settings.Builder)Rec601Settings.builder().applyMutation(rec601Settings)).build());
        }

        public Builder rec709Settings(Rec709Settings var1);

        default public Builder rec709Settings(Consumer<Rec709Settings.Builder> rec709Settings) {
            return this.rec709Settings((Rec709Settings)((Rec709Settings.Builder)Rec709Settings.builder().applyMutation(rec709Settings)).build());
        }
    }
}

