/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H264QualityLevel {
    ENHANCED_QUALITY("ENHANCED_QUALITY"),
    STANDARD_QUALITY("STANDARD_QUALITY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H264QualityLevel> VALUE_MAP;
    private final String value;

    private H264QualityLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H264QualityLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H264QualityLevel> knownValues() {
        EnumSet<H264QualityLevel> knownValues = EnumSet.allOf(H264QualityLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H264QualityLevel.class, H264QualityLevel::toString);
    }
}

