/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AcceptHeader {
    IMAGE_JPEG("image/jpeg"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AcceptHeader> VALUE_MAP;
    private final String value;

    private AcceptHeader(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AcceptHeader fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AcceptHeader> knownValues() {
        EnumSet<AcceptHeader> knownValues = EnumSet.allOf(AcceptHeader.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AcceptHeader.class, AcceptHeader::toString);
    }
}

