/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AudioCodecSettings;
import software.amazon.awssdk.services.medialive.model.AudioDescriptionAudioTypeControl;
import software.amazon.awssdk.services.medialive.model.AudioDescriptionLanguageCodeControl;
import software.amazon.awssdk.services.medialive.model.AudioNormalizationSettings;
import software.amazon.awssdk.services.medialive.model.AudioType;
import software.amazon.awssdk.services.medialive.model.AudioWatermarkSettings;
import software.amazon.awssdk.services.medialive.model.RemixSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioDescription> {
    private static final SdkField<AudioNormalizationSettings> AUDIO_NORMALIZATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AudioNormalizationSettings").getter(AudioDescription.getter(AudioDescription::audioNormalizationSettings)).setter(AudioDescription.setter(Builder::audioNormalizationSettings)).constructor(AudioNormalizationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioNormalizationSettings").build()}).build();
    private static final SdkField<String> AUDIO_SELECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioSelectorName").getter(AudioDescription.getter(AudioDescription::audioSelectorName)).setter(AudioDescription.setter(Builder::audioSelectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSelectorName").build()}).build();
    private static final SdkField<String> AUDIO_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioType").getter(AudioDescription.getter(AudioDescription::audioTypeAsString)).setter(AudioDescription.setter(Builder::audioType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioType").build()}).build();
    private static final SdkField<String> AUDIO_TYPE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioTypeControl").getter(AudioDescription.getter(AudioDescription::audioTypeControlAsString)).setter(AudioDescription.setter(Builder::audioTypeControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioTypeControl").build()}).build();
    private static final SdkField<AudioWatermarkSettings> AUDIO_WATERMARKING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AudioWatermarkingSettings").getter(AudioDescription.getter(AudioDescription::audioWatermarkingSettings)).setter(AudioDescription.setter(Builder::audioWatermarkingSettings)).constructor(AudioWatermarkSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioWatermarkingSettings").build()}).build();
    private static final SdkField<AudioCodecSettings> CODEC_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodecSettings").getter(AudioDescription.getter(AudioDescription::codecSettings)).setter(AudioDescription.setter(Builder::codecSettings)).constructor(AudioCodecSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSettings").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(AudioDescription.getter(AudioDescription::languageCode)).setter(AudioDescription.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCodeControl").getter(AudioDescription.getter(AudioDescription::languageCodeControlAsString)).setter(AudioDescription.setter(Builder::languageCodeControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCodeControl").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AudioDescription.getter(AudioDescription::name)).setter(AudioDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<RemixSettings> REMIX_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemixSettings").getter(AudioDescription.getter(AudioDescription::remixSettings)).setter(AudioDescription.setter(Builder::remixSettings)).constructor(RemixSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remixSettings").build()}).build();
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(AudioDescription.getter(AudioDescription::streamName)).setter(AudioDescription.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_NORMALIZATION_SETTINGS_FIELD, AUDIO_SELECTOR_NAME_FIELD, AUDIO_TYPE_FIELD, AUDIO_TYPE_CONTROL_FIELD, AUDIO_WATERMARKING_SETTINGS_FIELD, CODEC_SETTINGS_FIELD, LANGUAGE_CODE_FIELD, LANGUAGE_CODE_CONTROL_FIELD, NAME_FIELD, REMIX_SETTINGS_FIELD, STREAM_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final AudioNormalizationSettings audioNormalizationSettings;
    private final String audioSelectorName;
    private final String audioType;
    private final String audioTypeControl;
    private final AudioWatermarkSettings audioWatermarkingSettings;
    private final AudioCodecSettings codecSettings;
    private final String languageCode;
    private final String languageCodeControl;
    private final String name;
    private final RemixSettings remixSettings;
    private final String streamName;

    private AudioDescription(BuilderImpl builder) {
        this.audioNormalizationSettings = builder.audioNormalizationSettings;
        this.audioSelectorName = builder.audioSelectorName;
        this.audioType = builder.audioType;
        this.audioTypeControl = builder.audioTypeControl;
        this.audioWatermarkingSettings = builder.audioWatermarkingSettings;
        this.codecSettings = builder.codecSettings;
        this.languageCode = builder.languageCode;
        this.languageCodeControl = builder.languageCodeControl;
        this.name = builder.name;
        this.remixSettings = builder.remixSettings;
        this.streamName = builder.streamName;
    }

    public final AudioNormalizationSettings audioNormalizationSettings() {
        return this.audioNormalizationSettings;
    }

    public final String audioSelectorName() {
        return this.audioSelectorName;
    }

    public final AudioType audioType() {
        return AudioType.fromValue(this.audioType);
    }

    public final String audioTypeAsString() {
        return this.audioType;
    }

    public final AudioDescriptionAudioTypeControl audioTypeControl() {
        return AudioDescriptionAudioTypeControl.fromValue(this.audioTypeControl);
    }

    public final String audioTypeControlAsString() {
        return this.audioTypeControl;
    }

    public final AudioWatermarkSettings audioWatermarkingSettings() {
        return this.audioWatermarkingSettings;
    }

    public final AudioCodecSettings codecSettings() {
        return this.codecSettings;
    }

    public final String languageCode() {
        return this.languageCode;
    }

    public final AudioDescriptionLanguageCodeControl languageCodeControl() {
        return AudioDescriptionLanguageCodeControl.fromValue(this.languageCodeControl);
    }

    public final String languageCodeControlAsString() {
        return this.languageCodeControl;
    }

    public final String name() {
        return this.name;
    }

    public final RemixSettings remixSettings() {
        return this.remixSettings;
    }

    public final String streamName() {
        return this.streamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioNormalizationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioSelectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioTypeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioWatermarkingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.remixSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioDescription)) {
            return false;
        }
        AudioDescription other = (AudioDescription)obj;
        return Objects.equals(this.audioNormalizationSettings(), other.audioNormalizationSettings()) && Objects.equals(this.audioSelectorName(), other.audioSelectorName()) && Objects.equals(this.audioTypeAsString(), other.audioTypeAsString()) && Objects.equals(this.audioTypeControlAsString(), other.audioTypeControlAsString()) && Objects.equals(this.audioWatermarkingSettings(), other.audioWatermarkingSettings()) && Objects.equals(this.codecSettings(), other.codecSettings()) && Objects.equals(this.languageCode(), other.languageCode()) && Objects.equals(this.languageCodeControlAsString(), other.languageCodeControlAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.remixSettings(), other.remixSettings()) && Objects.equals(this.streamName(), other.streamName());
    }

    public final String toString() {
        return ToString.builder((String)"AudioDescription").add("AudioNormalizationSettings", (Object)this.audioNormalizationSettings()).add("AudioSelectorName", (Object)this.audioSelectorName()).add("AudioType", (Object)this.audioTypeAsString()).add("AudioTypeControl", (Object)this.audioTypeControlAsString()).add("AudioWatermarkingSettings", (Object)this.audioWatermarkingSettings()).add("CodecSettings", (Object)this.codecSettings()).add("LanguageCode", (Object)this.languageCode()).add("LanguageCodeControl", (Object)this.languageCodeControlAsString()).add("Name", (Object)this.name()).add("RemixSettings", (Object)this.remixSettings()).add("StreamName", (Object)this.streamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioNormalizationSettings": {
                return Optional.ofNullable(clazz.cast(this.audioNormalizationSettings()));
            }
            case "AudioSelectorName": {
                return Optional.ofNullable(clazz.cast(this.audioSelectorName()));
            }
            case "AudioType": {
                return Optional.ofNullable(clazz.cast(this.audioTypeAsString()));
            }
            case "AudioTypeControl": {
                return Optional.ofNullable(clazz.cast(this.audioTypeControlAsString()));
            }
            case "AudioWatermarkingSettings": {
                return Optional.ofNullable(clazz.cast(this.audioWatermarkingSettings()));
            }
            case "CodecSettings": {
                return Optional.ofNullable(clazz.cast(this.codecSettings()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCode()));
            }
            case "LanguageCodeControl": {
                return Optional.ofNullable(clazz.cast(this.languageCodeControlAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RemixSettings": {
                return Optional.ofNullable(clazz.cast(this.remixSettings()));
            }
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioDescription, T> g) {
        return obj -> g.apply((AudioDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AudioNormalizationSettings audioNormalizationSettings;
        private String audioSelectorName;
        private String audioType;
        private String audioTypeControl;
        private AudioWatermarkSettings audioWatermarkingSettings;
        private AudioCodecSettings codecSettings;
        private String languageCode;
        private String languageCodeControl;
        private String name;
        private RemixSettings remixSettings;
        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioDescription model) {
            this.audioNormalizationSettings(model.audioNormalizationSettings);
            this.audioSelectorName(model.audioSelectorName);
            this.audioType(model.audioType);
            this.audioTypeControl(model.audioTypeControl);
            this.audioWatermarkingSettings(model.audioWatermarkingSettings);
            this.codecSettings(model.codecSettings);
            this.languageCode(model.languageCode);
            this.languageCodeControl(model.languageCodeControl);
            this.name(model.name);
            this.remixSettings(model.remixSettings);
            this.streamName(model.streamName);
        }

        public final AudioNormalizationSettings.Builder getAudioNormalizationSettings() {
            return this.audioNormalizationSettings != null ? this.audioNormalizationSettings.toBuilder() : null;
        }

        public final void setAudioNormalizationSettings(AudioNormalizationSettings.BuilderImpl audioNormalizationSettings) {
            this.audioNormalizationSettings = audioNormalizationSettings != null ? audioNormalizationSettings.build() : null;
        }

        @Override
        public final Builder audioNormalizationSettings(AudioNormalizationSettings audioNormalizationSettings) {
            this.audioNormalizationSettings = audioNormalizationSettings;
            return this;
        }

        public final String getAudioSelectorName() {
            return this.audioSelectorName;
        }

        public final void setAudioSelectorName(String audioSelectorName) {
            this.audioSelectorName = audioSelectorName;
        }

        @Override
        public final Builder audioSelectorName(String audioSelectorName) {
            this.audioSelectorName = audioSelectorName;
            return this;
        }

        public final String getAudioType() {
            return this.audioType;
        }

        public final void setAudioType(String audioType) {
            this.audioType = audioType;
        }

        @Override
        public final Builder audioType(String audioType) {
            this.audioType = audioType;
            return this;
        }

        @Override
        public final Builder audioType(AudioType audioType) {
            this.audioType(audioType == null ? null : audioType.toString());
            return this;
        }

        public final String getAudioTypeControl() {
            return this.audioTypeControl;
        }

        public final void setAudioTypeControl(String audioTypeControl) {
            this.audioTypeControl = audioTypeControl;
        }

        @Override
        public final Builder audioTypeControl(String audioTypeControl) {
            this.audioTypeControl = audioTypeControl;
            return this;
        }

        @Override
        public final Builder audioTypeControl(AudioDescriptionAudioTypeControl audioTypeControl) {
            this.audioTypeControl(audioTypeControl == null ? null : audioTypeControl.toString());
            return this;
        }

        public final AudioWatermarkSettings.Builder getAudioWatermarkingSettings() {
            return this.audioWatermarkingSettings != null ? this.audioWatermarkingSettings.toBuilder() : null;
        }

        public final void setAudioWatermarkingSettings(AudioWatermarkSettings.BuilderImpl audioWatermarkingSettings) {
            this.audioWatermarkingSettings = audioWatermarkingSettings != null ? audioWatermarkingSettings.build() : null;
        }

        @Override
        public final Builder audioWatermarkingSettings(AudioWatermarkSettings audioWatermarkingSettings) {
            this.audioWatermarkingSettings = audioWatermarkingSettings;
            return this;
        }

        public final AudioCodecSettings.Builder getCodecSettings() {
            return this.codecSettings != null ? this.codecSettings.toBuilder() : null;
        }

        public final void setCodecSettings(AudioCodecSettings.BuilderImpl codecSettings) {
            this.codecSettings = codecSettings != null ? codecSettings.build() : null;
        }

        @Override
        public final Builder codecSettings(AudioCodecSettings codecSettings) {
            this.codecSettings = codecSettings;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final String getLanguageCodeControl() {
            return this.languageCodeControl;
        }

        public final void setLanguageCodeControl(String languageCodeControl) {
            this.languageCodeControl = languageCodeControl;
        }

        @Override
        public final Builder languageCodeControl(String languageCodeControl) {
            this.languageCodeControl = languageCodeControl;
            return this;
        }

        @Override
        public final Builder languageCodeControl(AudioDescriptionLanguageCodeControl languageCodeControl) {
            this.languageCodeControl(languageCodeControl == null ? null : languageCodeControl.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RemixSettings.Builder getRemixSettings() {
            return this.remixSettings != null ? this.remixSettings.toBuilder() : null;
        }

        public final void setRemixSettings(RemixSettings.BuilderImpl remixSettings) {
            this.remixSettings = remixSettings != null ? remixSettings.build() : null;
        }

        @Override
        public final Builder remixSettings(RemixSettings remixSettings) {
            this.remixSettings = remixSettings;
            return this;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public AudioDescription build() {
            return new AudioDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioDescription> {
        public Builder audioNormalizationSettings(AudioNormalizationSettings var1);

        default public Builder audioNormalizationSettings(Consumer<AudioNormalizationSettings.Builder> audioNormalizationSettings) {
            return this.audioNormalizationSettings((AudioNormalizationSettings)((AudioNormalizationSettings.Builder)AudioNormalizationSettings.builder().applyMutation(audioNormalizationSettings)).build());
        }

        public Builder audioSelectorName(String var1);

        public Builder audioType(String var1);

        public Builder audioType(AudioType var1);

        public Builder audioTypeControl(String var1);

        public Builder audioTypeControl(AudioDescriptionAudioTypeControl var1);

        public Builder audioWatermarkingSettings(AudioWatermarkSettings var1);

        default public Builder audioWatermarkingSettings(Consumer<AudioWatermarkSettings.Builder> audioWatermarkingSettings) {
            return this.audioWatermarkingSettings((AudioWatermarkSettings)((AudioWatermarkSettings.Builder)AudioWatermarkSettings.builder().applyMutation(audioWatermarkingSettings)).build());
        }

        public Builder codecSettings(AudioCodecSettings var1);

        default public Builder codecSettings(Consumer<AudioCodecSettings.Builder> codecSettings) {
            return this.codecSettings((AudioCodecSettings)((AudioCodecSettings.Builder)AudioCodecSettings.builder().applyMutation(codecSettings)).build());
        }

        public Builder languageCode(String var1);

        public Builder languageCodeControl(String var1);

        public Builder languageCodeControl(AudioDescriptionLanguageCodeControl var1);

        public Builder name(String var1);

        public Builder remixSettings(RemixSettings var1);

        default public Builder remixSettings(Consumer<RemixSettings.Builder> remixSettings) {
            return this.remixSettings((RemixSettings)((RemixSettings.Builder)RemixSettings.builder().applyMutation(remixSettings)).build());
        }

        public Builder streamName(String var1);
    }
}

