/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings related to teletext captions. Set up teletext captions in the same output as your video. For more
 * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/teletext-output-captions.html.
 */
@Generated("software.amazon.awssdk:codegen")
public final class TeletextDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<TeletextDestinationSettings.Builder, TeletextDestinationSettings> {
    private static final SdkField<String> PAGE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageNumber").getter(getter(TeletextDestinationSettings::pageNumber)).setter(setter(Builder::pageNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageNumber").build()).build();

    private static final SdkField<List<String>> PAGE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PageTypes")
            .getter(getter(TeletextDestinationSettings::pageTypesAsStrings))
            .setter(setter(Builder::pageTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_NUMBER_FIELD,
            PAGE_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pageNumber;

    private final List<String> pageTypes;

    private TeletextDestinationSettings(BuilderImpl builder) {
        this.pageNumber = builder.pageNumber;
        this.pageTypes = builder.pageTypes;
    }

    /**
     * Set pageNumber to the Teletext page number for the destination captions for this output. This value must be a
     * three-digit hexadecimal string; strings ending in -FF are invalid. If you are passing through the entire set of
     * Teletext data, do not use this field.
     * 
     * @return Set pageNumber to the Teletext page number for the destination captions for this output. This value must
     *         be a three-digit hexadecimal string; strings ending in -FF are invalid. If you are passing through the
     *         entire set of Teletext data, do not use this field.
     */
    public final String pageNumber() {
        return pageNumber;
    }

    /**
     * Specify the page types for this Teletext page. If you don't specify a value here, the service sets the page type
     * to the default value Subtitle. If you pass through the entire set of Teletext data, don't use this field. When
     * you pass through a set of Teletext pages, your output has the same page types as your input.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPageTypes} method.
     * </p>
     * 
     * @return Specify the page types for this Teletext page. If you don't specify a value here, the service sets the
     *         page type to the default value Subtitle. If you pass through the entire set of Teletext data, don't use
     *         this field. When you pass through a set of Teletext pages, your output has the same page types as your
     *         input.
     */
    public final List<TeletextPageType> pageTypes() {
        return ___listOfTeletextPageTypeCopier.copyStringToEnum(pageTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the PageTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPageTypes() {
        return pageTypes != null && !(pageTypes instanceof SdkAutoConstructList);
    }

    /**
     * Specify the page types for this Teletext page. If you don't specify a value here, the service sets the page type
     * to the default value Subtitle. If you pass through the entire set of Teletext data, don't use this field. When
     * you pass through a set of Teletext pages, your output has the same page types as your input.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPageTypes} method.
     * </p>
     * 
     * @return Specify the page types for this Teletext page. If you don't specify a value here, the service sets the
     *         page type to the default value Subtitle. If you pass through the entire set of Teletext data, don't use
     *         this field. When you pass through a set of Teletext pages, your output has the same page types as your
     *         input.
     */
    public final List<String> pageTypesAsStrings() {
        return pageTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pageNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasPageTypes() ? pageTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TeletextDestinationSettings)) {
            return false;
        }
        TeletextDestinationSettings other = (TeletextDestinationSettings) obj;
        return Objects.equals(pageNumber(), other.pageNumber()) && hasPageTypes() == other.hasPageTypes()
                && Objects.equals(pageTypesAsStrings(), other.pageTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TeletextDestinationSettings").add("PageNumber", pageNumber())
                .add("PageTypes", hasPageTypes() ? pageTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PageNumber":
            return Optional.ofNullable(clazz.cast(pageNumber()));
        case "PageTypes":
            return Optional.ofNullable(clazz.cast(pageTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TeletextDestinationSettings, T> g) {
        return obj -> g.apply((TeletextDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TeletextDestinationSettings> {
        /**
         * Set pageNumber to the Teletext page number for the destination captions for this output. This value must be a
         * three-digit hexadecimal string; strings ending in -FF are invalid. If you are passing through the entire set
         * of Teletext data, do not use this field.
         * 
         * @param pageNumber
         *        Set pageNumber to the Teletext page number for the destination captions for this output. This value
         *        must be a three-digit hexadecimal string; strings ending in -FF are invalid. If you are passing
         *        through the entire set of Teletext data, do not use this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageNumber(String pageNumber);

        /**
         * Specify the page types for this Teletext page. If you don't specify a value here, the service sets the page
         * type to the default value Subtitle. If you pass through the entire set of Teletext data, don't use this
         * field. When you pass through a set of Teletext pages, your output has the same page types as your input.
         * 
         * @param pageTypes
         *        Specify the page types for this Teletext page. If you don't specify a value here, the service sets the
         *        page type to the default value Subtitle. If you pass through the entire set of Teletext data, don't
         *        use this field. When you pass through a set of Teletext pages, your output has the same page types as
         *        your input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageTypesWithStrings(Collection<String> pageTypes);

        /**
         * Specify the page types for this Teletext page. If you don't specify a value here, the service sets the page
         * type to the default value Subtitle. If you pass through the entire set of Teletext data, don't use this
         * field. When you pass through a set of Teletext pages, your output has the same page types as your input.
         * 
         * @param pageTypes
         *        Specify the page types for this Teletext page. If you don't specify a value here, the service sets the
         *        page type to the default value Subtitle. If you pass through the entire set of Teletext data, don't
         *        use this field. When you pass through a set of Teletext pages, your output has the same page types as
         *        your input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageTypesWithStrings(String... pageTypes);

        /**
         * Specify the page types for this Teletext page. If you don't specify a value here, the service sets the page
         * type to the default value Subtitle. If you pass through the entire set of Teletext data, don't use this
         * field. When you pass through a set of Teletext pages, your output has the same page types as your input.
         * 
         * @param pageTypes
         *        Specify the page types for this Teletext page. If you don't specify a value here, the service sets the
         *        page type to the default value Subtitle. If you pass through the entire set of Teletext data, don't
         *        use this field. When you pass through a set of Teletext pages, your output has the same page types as
         *        your input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageTypes(Collection<TeletextPageType> pageTypes);

        /**
         * Specify the page types for this Teletext page. If you don't specify a value here, the service sets the page
         * type to the default value Subtitle. If you pass through the entire set of Teletext data, don't use this
         * field. When you pass through a set of Teletext pages, your output has the same page types as your input.
         * 
         * @param pageTypes
         *        Specify the page types for this Teletext page. If you don't specify a value here, the service sets the
         *        page type to the default value Subtitle. If you pass through the entire set of Teletext data, don't
         *        use this field. When you pass through a set of Teletext pages, your output has the same page types as
         *        your input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageTypes(TeletextPageType... pageTypes);
    }

    static final class BuilderImpl implements Builder {
        private String pageNumber;

        private List<String> pageTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TeletextDestinationSettings model) {
            pageNumber(model.pageNumber);
            pageTypesWithStrings(model.pageTypes);
        }

        public final String getPageNumber() {
            return pageNumber;
        }

        public final void setPageNumber(String pageNumber) {
            this.pageNumber = pageNumber;
        }

        @Override
        public final Builder pageNumber(String pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public final Collection<String> getPageTypes() {
            if (pageTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return pageTypes;
        }

        public final void setPageTypes(Collection<String> pageTypes) {
            this.pageTypes = ___listOfTeletextPageTypeCopier.copy(pageTypes);
        }

        @Override
        public final Builder pageTypesWithStrings(Collection<String> pageTypes) {
            this.pageTypes = ___listOfTeletextPageTypeCopier.copy(pageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageTypesWithStrings(String... pageTypes) {
            pageTypesWithStrings(Arrays.asList(pageTypes));
            return this;
        }

        @Override
        public final Builder pageTypes(Collection<TeletextPageType> pageTypes) {
            this.pageTypes = ___listOfTeletextPageTypeCopier.copyEnumToString(pageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageTypes(TeletextPageType... pageTypes) {
            pageTypes(Arrays.asList(pageTypes));
            return this;
        }

        @Override
        public TeletextDestinationSettings build() {
            return new TeletextDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
