/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Specify the XAVC profile settings for MXF outputs when you set your MXF profile to XAVC.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MxfXavcProfileSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MxfXavcProfileSettings.Builder, MxfXavcProfileSettings> {
    private static final SdkField<String> DURATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurationMode").getter(getter(MxfXavcProfileSettings::durationModeAsString))
            .setter(setter(Builder::durationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationMode").build()).build();

    private static final SdkField<Integer> MAX_ANC_DATA_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAncDataSize").getter(getter(MxfXavcProfileSettings::maxAncDataSize))
            .setter(setter(Builder::maxAncDataSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAncDataSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_MODE_FIELD,
            MAX_ANC_DATA_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String durationMode;

    private final Integer maxAncDataSize;

    private MxfXavcProfileSettings(BuilderImpl builder) {
        this.durationMode = builder.durationMode;
        this.maxAncDataSize = builder.maxAncDataSize;
    }

    /**
     * To create an output that complies with the XAVC file format guidelines for interoperability, keep the default
     * value, Drop frames for compliance. To include all frames from your input in this output, keep the default
     * setting, Allow any duration. The number of frames that MediaConvert excludes when you set this to Drop frames for
     * compliance depends on the output frame rate and duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #durationMode} will
     * return {@link MxfXavcDurationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #durationModeAsString}.
     * </p>
     * 
     * @return To create an output that complies with the XAVC file format guidelines for interoperability, keep the
     *         default value, Drop frames for compliance. To include all frames from your input in this output, keep the
     *         default setting, Allow any duration. The number of frames that MediaConvert excludes when you set this to
     *         Drop frames for compliance depends on the output frame rate and duration.
     * @see MxfXavcDurationMode
     */
    public final MxfXavcDurationMode durationMode() {
        return MxfXavcDurationMode.fromValue(durationMode);
    }

    /**
     * To create an output that complies with the XAVC file format guidelines for interoperability, keep the default
     * value, Drop frames for compliance. To include all frames from your input in this output, keep the default
     * setting, Allow any duration. The number of frames that MediaConvert excludes when you set this to Drop frames for
     * compliance depends on the output frame rate and duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #durationMode} will
     * return {@link MxfXavcDurationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #durationModeAsString}.
     * </p>
     * 
     * @return To create an output that complies with the XAVC file format guidelines for interoperability, keep the
     *         default value, Drop frames for compliance. To include all frames from your input in this output, keep the
     *         default setting, Allow any duration. The number of frames that MediaConvert excludes when you set this to
     *         Drop frames for compliance depends on the output frame rate and duration.
     * @see MxfXavcDurationMode
     */
    public final String durationModeAsString() {
        return durationMode;
    }

    /**
     * Specify a value for this setting only for outputs that you set up with one of these two XAVC profiles: XAVC HD
     * Intra CBG or XAVC 4K Intra CBG. Specify the amount of space in each frame that the service reserves for ancillary
     * data, such as teletext captions. The default value for this setting is 1492 bytes per frame. This should be
     * sufficient to prevent overflow unless you have multiple pages of teletext captions data. If you have a large
     * amount of teletext data, specify a larger number.
     * 
     * @return Specify a value for this setting only for outputs that you set up with one of these two XAVC profiles:
     *         XAVC HD Intra CBG or XAVC 4K Intra CBG. Specify the amount of space in each frame that the service
     *         reserves for ancillary data, such as teletext captions. The default value for this setting is 1492 bytes
     *         per frame. This should be sufficient to prevent overflow unless you have multiple pages of teletext
     *         captions data. If you have a large amount of teletext data, specify a larger number.
     */
    public final Integer maxAncDataSize() {
        return maxAncDataSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(durationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxAncDataSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MxfXavcProfileSettings)) {
            return false;
        }
        MxfXavcProfileSettings other = (MxfXavcProfileSettings) obj;
        return Objects.equals(durationModeAsString(), other.durationModeAsString())
                && Objects.equals(maxAncDataSize(), other.maxAncDataSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MxfXavcProfileSettings").add("DurationMode", durationModeAsString())
                .add("MaxAncDataSize", maxAncDataSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurationMode":
            return Optional.ofNullable(clazz.cast(durationModeAsString()));
        case "MaxAncDataSize":
            return Optional.ofNullable(clazz.cast(maxAncDataSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MxfXavcProfileSettings, T> g) {
        return obj -> g.apply((MxfXavcProfileSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MxfXavcProfileSettings> {
        /**
         * To create an output that complies with the XAVC file format guidelines for interoperability, keep the default
         * value, Drop frames for compliance. To include all frames from your input in this output, keep the default
         * setting, Allow any duration. The number of frames that MediaConvert excludes when you set this to Drop frames
         * for compliance depends on the output frame rate and duration.
         * 
         * @param durationMode
         *        To create an output that complies with the XAVC file format guidelines for interoperability, keep the
         *        default value, Drop frames for compliance. To include all frames from your input in this output, keep
         *        the default setting, Allow any duration. The number of frames that MediaConvert excludes when you set
         *        this to Drop frames for compliance depends on the output frame rate and duration.
         * @see MxfXavcDurationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MxfXavcDurationMode
         */
        Builder durationMode(String durationMode);

        /**
         * To create an output that complies with the XAVC file format guidelines for interoperability, keep the default
         * value, Drop frames for compliance. To include all frames from your input in this output, keep the default
         * setting, Allow any duration. The number of frames that MediaConvert excludes when you set this to Drop frames
         * for compliance depends on the output frame rate and duration.
         * 
         * @param durationMode
         *        To create an output that complies with the XAVC file format guidelines for interoperability, keep the
         *        default value, Drop frames for compliance. To include all frames from your input in this output, keep
         *        the default setting, Allow any duration. The number of frames that MediaConvert excludes when you set
         *        this to Drop frames for compliance depends on the output frame rate and duration.
         * @see MxfXavcDurationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MxfXavcDurationMode
         */
        Builder durationMode(MxfXavcDurationMode durationMode);

        /**
         * Specify a value for this setting only for outputs that you set up with one of these two XAVC profiles: XAVC
         * HD Intra CBG or XAVC 4K Intra CBG. Specify the amount of space in each frame that the service reserves for
         * ancillary data, such as teletext captions. The default value for this setting is 1492 bytes per frame. This
         * should be sufficient to prevent overflow unless you have multiple pages of teletext captions data. If you
         * have a large amount of teletext data, specify a larger number.
         * 
         * @param maxAncDataSize
         *        Specify a value for this setting only for outputs that you set up with one of these two XAVC profiles:
         *        XAVC HD Intra CBG or XAVC 4K Intra CBG. Specify the amount of space in each frame that the service
         *        reserves for ancillary data, such as teletext captions. The default value for this setting is 1492
         *        bytes per frame. This should be sufficient to prevent overflow unless you have multiple pages of
         *        teletext captions data. If you have a large amount of teletext data, specify a larger number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAncDataSize(Integer maxAncDataSize);
    }

    static final class BuilderImpl implements Builder {
        private String durationMode;

        private Integer maxAncDataSize;

        private BuilderImpl() {
        }

        private BuilderImpl(MxfXavcProfileSettings model) {
            durationMode(model.durationMode);
            maxAncDataSize(model.maxAncDataSize);
        }

        public final String getDurationMode() {
            return durationMode;
        }

        public final void setDurationMode(String durationMode) {
            this.durationMode = durationMode;
        }

        @Override
        public final Builder durationMode(String durationMode) {
            this.durationMode = durationMode;
            return this;
        }

        @Override
        public final Builder durationMode(MxfXavcDurationMode durationMode) {
            this.durationMode(durationMode == null ? null : durationMode.toString());
            return this;
        }

        public final Integer getMaxAncDataSize() {
            return maxAncDataSize;
        }

        public final void setMaxAncDataSize(Integer maxAncDataSize) {
            this.maxAncDataSize = maxAncDataSize;
        }

        @Override
        public final Builder maxAncDataSize(Integer maxAncDataSize) {
            this.maxAncDataSize = maxAncDataSize;
            return this;
        }

        @Override
        public MxfXavcProfileSettings build() {
            return new MxfXavcProfileSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
