/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * When you include Video generator, MediaConvert creates a video input with black frames. Use this setting if you do
 * not have a video input or if you want to add black video frames before, or after, other inputs. You can specify Video
 * generator, or you can specify an Input file, but you cannot specify both. For more information, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/video-generator.html
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputVideoGenerator implements SdkPojo, Serializable,
        ToCopyableBuilder<InputVideoGenerator.Builder, InputVideoGenerator> {
    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(InputVideoGenerator::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer duration;

    private InputVideoGenerator(BuilderImpl builder) {
        this.duration = builder.duration;
    }

    /**
     * Specify an integer value for Black video duration from 50 to 86400000 to generate a black video input for that
     * many milliseconds. Required when you include Video generator.
     * 
     * @return Specify an integer value for Black video duration from 50 to 86400000 to generate a black video input for
     *         that many milliseconds. Required when you include Video generator.
     */
    public final Integer duration() {
        return duration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputVideoGenerator)) {
            return false;
        }
        InputVideoGenerator other = (InputVideoGenerator) obj;
        return Objects.equals(duration(), other.duration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputVideoGenerator").add("Duration", duration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputVideoGenerator, T> g) {
        return obj -> g.apply((InputVideoGenerator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputVideoGenerator> {
        /**
         * Specify an integer value for Black video duration from 50 to 86400000 to generate a black video input for
         * that many milliseconds. Required when you include Video generator.
         * 
         * @param duration
         *        Specify an integer value for Black video duration from 50 to 86400000 to generate a black video input
         *        for that many milliseconds. Required when you include Video generator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);
    }

    static final class BuilderImpl implements Builder {
        private Integer duration;

        private BuilderImpl() {
        }

        private BuilderImpl(InputVideoGenerator model) {
            duration(model.duration);
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public InputVideoGenerator build() {
            return new InputVideoGenerator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
