/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * The Quality tuning level you choose represents a trade-off between the encoding speed of your job and the output
 * video quality. For the fastest encoding speed at the cost of video quality: Choose Single pass. For a good balance
 * between encoding speed and video quality: Leave blank or keep the default value Single pass HQ. For the best video
 * quality, at the cost of encoding speed: Choose Multi pass HQ. MediaConvert performs an analysis pass on your input
 * followed by an encoding pass. Outputs that use this feature incur pro-tier pricing.
 */
@Generated("software.amazon.awssdk:codegen")
public enum H264QualityTuningLevel {
    SINGLE_PASS("SINGLE_PASS"),

    SINGLE_PASS_HQ("SINGLE_PASS_HQ"),

    MULTI_PASS_HQ("MULTI_PASS_HQ"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H264QualityTuningLevel> VALUE_MAP = EnumUtils.uniqueIndex(H264QualityTuningLevel.class,
            H264QualityTuningLevel::toString);

    private final String value;

    private H264QualityTuningLevel(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H264QualityTuningLevel corresponding to the value
     */
    public static H264QualityTuningLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H264QualityTuningLevel}s
     */
    public static Set<H264QualityTuningLevel> knownValues() {
        Set<H264QualityTuningLevel> knownValues = EnumSet.allOf(H264QualityTuningLevel.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
