/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * To create an output that complies with the XAVC file format guidelines for interoperability, keep the default value,
 * Drop frames for compliance (DROP_FRAMES_FOR_COMPLIANCE). To include all frames from your input in this output, keep
 * the default setting, Allow any duration (ALLOW_ANY_DURATION). The number of frames that MediaConvert excludes when
 * you set this to Drop frames for compliance depends on the output frame rate and duration.
 */
@Generated("software.amazon.awssdk:codegen")
public enum MxfXavcDurationMode {
    ALLOW_ANY_DURATION("ALLOW_ANY_DURATION"),

    DROP_FRAMES_FOR_COMPLIANCE("DROP_FRAMES_FOR_COMPLIANCE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MxfXavcDurationMode> VALUE_MAP = EnumUtils.uniqueIndex(MxfXavcDurationMode.class,
            MxfXavcDurationMode::toString);

    private final String value;

    private MxfXavcDurationMode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return MxfXavcDurationMode corresponding to the value
     */
    public static MxfXavcDurationMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link MxfXavcDurationMode}s
     */
    public static Set<MxfXavcDurationMode> knownValues() {
        Set<MxfXavcDurationMode> knownValues = EnumSet.allOf(MxfXavcDurationMode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
