/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Choose how the service meters the loudness of your audio.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Eac3AtmosMeteringMode {
    LEQ_A("LEQ_A"),

    ITU_BS_1770_1("ITU_BS_1770_1"),

    ITU_BS_1770_2("ITU_BS_1770_2"),

    ITU_BS_1770_3("ITU_BS_1770_3"),

    ITU_BS_1770_4("ITU_BS_1770_4"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Eac3AtmosMeteringMode> VALUE_MAP = EnumUtils.uniqueIndex(Eac3AtmosMeteringMode.class,
            Eac3AtmosMeteringMode::toString);

    private final String value;

    private Eac3AtmosMeteringMode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Eac3AtmosMeteringMode corresponding to the value
     */
    public static Eac3AtmosMeteringMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Eac3AtmosMeteringMode}s
     */
    public static Set<Eac3AtmosMeteringMode> knownValues() {
        Set<Eac3AtmosMeteringMode> knownValues = EnumSet.allOf(Eac3AtmosMeteringMode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
