/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify the AVC-Intra class of your output. The AVC-Intra class selection determines the output video bit rate
 * depending on the frame rate of the output. Outputs with higher class values have higher bitrates and improved image
 * quality. Note that for Class 4K/2K, MediaConvert supports only 4:2:2 chroma subsampling.
 */
@Generated("software.amazon.awssdk:codegen")
public enum AvcIntraClass {
    CLASS_50("CLASS_50"),

    CLASS_100("CLASS_100"),

    CLASS_200("CLASS_200"),

    CLASS_4_K_2_K("CLASS_4K_2K"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AvcIntraClass> VALUE_MAP = EnumUtils.uniqueIndex(AvcIntraClass.class,
            AvcIntraClass::toString);

    private final String value;

    private AvcIntraClass(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AvcIntraClass corresponding to the value
     */
    public static AvcIntraClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AvcIntraClass}s
     */
    public static Set<AvcIntraClass> knownValues() {
        Set<AvcIntraClass> knownValues = EnumSet.allOf(AvcIntraClass.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
