/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveFlowVpcInterfaceResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, RemoveFlowVpcInterfaceResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(RemoveFlowVpcInterfaceResponse.getter(RemoveFlowVpcInterfaceResponse::flowArn)).setter(RemoveFlowVpcInterfaceResponse.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<List<String>> NON_DELETED_NETWORK_INTERFACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NonDeletedNetworkInterfaceIds").getter(RemoveFlowVpcInterfaceResponse.getter(RemoveFlowVpcInterfaceResponse::nonDeletedNetworkInterfaceIds)).setter(RemoveFlowVpcInterfaceResponse.setter(Builder::nonDeletedNetworkInterfaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonDeletedNetworkInterfaceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_INTERFACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcInterfaceName").getter(RemoveFlowVpcInterfaceResponse.getter(RemoveFlowVpcInterfaceResponse::vpcInterfaceName)).setter(RemoveFlowVpcInterfaceResponse.setter(Builder::vpcInterfaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, NON_DELETED_NETWORK_INTERFACE_IDS_FIELD, VPC_INTERFACE_NAME_FIELD));
    private final String flowArn;
    private final List<String> nonDeletedNetworkInterfaceIds;
    private final String vpcInterfaceName;

    private RemoveFlowVpcInterfaceResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.nonDeletedNetworkInterfaceIds = builder.nonDeletedNetworkInterfaceIds;
        this.vpcInterfaceName = builder.vpcInterfaceName;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final boolean hasNonDeletedNetworkInterfaceIds() {
        return this.nonDeletedNetworkInterfaceIds != null && !(this.nonDeletedNetworkInterfaceIds instanceof SdkAutoConstructList);
    }

    public final List<String> nonDeletedNetworkInterfaceIds() {
        return this.nonDeletedNetworkInterfaceIds;
    }

    public final String vpcInterfaceName() {
        return this.vpcInterfaceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNonDeletedNetworkInterfaceIds() ? this.nonDeletedNetworkInterfaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcInterfaceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveFlowVpcInterfaceResponse)) {
            return false;
        }
        RemoveFlowVpcInterfaceResponse other = (RemoveFlowVpcInterfaceResponse)((Object)obj);
        return Objects.equals(this.flowArn(), other.flowArn()) && this.hasNonDeletedNetworkInterfaceIds() == other.hasNonDeletedNetworkInterfaceIds() && Objects.equals(this.nonDeletedNetworkInterfaceIds(), other.nonDeletedNetworkInterfaceIds()) && Objects.equals(this.vpcInterfaceName(), other.vpcInterfaceName());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveFlowVpcInterfaceResponse").add("FlowArn", (Object)this.flowArn()).add("NonDeletedNetworkInterfaceIds", this.hasNonDeletedNetworkInterfaceIds() ? this.nonDeletedNetworkInterfaceIds() : null).add("VpcInterfaceName", (Object)this.vpcInterfaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "NonDeletedNetworkInterfaceIds": {
                return Optional.ofNullable(clazz.cast(this.nonDeletedNetworkInterfaceIds()));
            }
            case "VpcInterfaceName": {
                return Optional.ofNullable(clazz.cast(this.vpcInterfaceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveFlowVpcInterfaceResponse, T> g) {
        return obj -> g.apply((RemoveFlowVpcInterfaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String flowArn;
        private List<String> nonDeletedNetworkInterfaceIds = DefaultSdkAutoConstructList.getInstance();
        private String vpcInterfaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveFlowVpcInterfaceResponse model) {
            super(model);
            this.flowArn(model.flowArn);
            this.nonDeletedNetworkInterfaceIds(model.nonDeletedNetworkInterfaceIds);
            this.vpcInterfaceName(model.vpcInterfaceName);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final Collection<String> getNonDeletedNetworkInterfaceIds() {
            if (this.nonDeletedNetworkInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nonDeletedNetworkInterfaceIds;
        }

        @Override
        public final Builder nonDeletedNetworkInterfaceIds(Collection<String> nonDeletedNetworkInterfaceIds) {
            this.nonDeletedNetworkInterfaceIds = ___listOf__stringCopier.copy(nonDeletedNetworkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonDeletedNetworkInterfaceIds(String ... nonDeletedNetworkInterfaceIds) {
            this.nonDeletedNetworkInterfaceIds(Arrays.asList(nonDeletedNetworkInterfaceIds));
            return this;
        }

        public final void setNonDeletedNetworkInterfaceIds(Collection<String> nonDeletedNetworkInterfaceIds) {
            this.nonDeletedNetworkInterfaceIds = ___listOf__stringCopier.copy(nonDeletedNetworkInterfaceIds);
        }

        public final String getVpcInterfaceName() {
            return this.vpcInterfaceName;
        }

        @Override
        public final Builder vpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
            return this;
        }

        public final void setVpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
        }

        @Override
        public RemoveFlowVpcInterfaceResponse build() {
            return new RemoveFlowVpcInterfaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveFlowVpcInterfaceResponse> {
        public Builder flowArn(String var1);

        public Builder nonDeletedNetworkInterfaceIds(Collection<String> var1);

        public Builder nonDeletedNetworkInterfaceIds(String ... var1);

        public Builder vpcInterfaceName(String var1);
    }
}

