/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.marketplacecatalog.MarketplaceCatalogClient;
import software.amazon.awssdk.services.marketplacecatalog.model.EntitySummary;
import software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesResponse;

public class ListEntitiesIterable
implements SdkIterable<ListEntitiesResponse> {
    private final MarketplaceCatalogClient client;
    private final ListEntitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEntitiesIterable(MarketplaceCatalogClient client, ListEntitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEntitiesResponseFetcher();
    }

    public Iterator<ListEntitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EntitySummary> entitySummaryList() {
        Function<ListEntitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.entitySummaryList() != null) {
                return response.entitySummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEntitiesResponseFetcher
    implements SyncPageFetcher<ListEntitiesResponse> {
        private ListEntitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListEntitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEntitiesResponse nextPage(ListEntitiesResponse previousPage) {
            if (previousPage == null) {
                return ListEntitiesIterable.this.client.listEntities(ListEntitiesIterable.this.firstRequest);
            }
            return ListEntitiesIterable.this.client.listEntities((ListEntitiesRequest)((Object)ListEntitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

