/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.marketplacecatalog.MarketplaceCatalogAsyncClient;
import software.amazon.awssdk.services.marketplacecatalog.model.ChangeSetSummaryListItem;
import software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsResponse;

public class ListChangeSetsPublisher
implements SdkPublisher<ListChangeSetsResponse> {
    private final MarketplaceCatalogAsyncClient client;
    private final ListChangeSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChangeSetsPublisher(MarketplaceCatalogAsyncClient client, ListChangeSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChangeSetsPublisher(MarketplaceCatalogAsyncClient client, ListChangeSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChangeSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChangeSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ChangeSetSummaryListItem> changeSetSummaryList() {
        Function<ListChangeSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.changeSetSummaryList() != null) {
                return response.changeSetSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListChangeSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListChangeSetsResponseFetcher
    implements AsyncPageFetcher<ListChangeSetsResponse> {
        private ListChangeSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListChangeSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChangeSetsResponse> nextPage(ListChangeSetsResponse previousPage) {
            if (previousPage == null) {
                return ListChangeSetsPublisher.this.client.listChangeSets(ListChangeSetsPublisher.this.firstRequest);
            }
            return ListChangeSetsPublisher.this.client.listChangeSets((ListChangeSetsRequest)((Object)ListChangeSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

