/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacecatalog.model.Entity;
import software.amazon.awssdk.services.marketplacecatalog.model.Tag;
import software.amazon.awssdk.services.marketplacecatalog.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Change
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Change> {
    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeType").getter(Change.getter(Change::changeType)).setter(Change.setter(Builder::changeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeType").build()}).build();
    private static final SdkField<Entity> ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Entity").getter(Change.getter(Change::entity)).setter(Change.setter(Builder::entity)).constructor(Entity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entity").build()}).build();
    private static final SdkField<List<Tag>> ENTITY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityTags").getter(Change.getter(Change::entityTags)).setter(Change.setter(Builder::entityTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Details").getter(Change.getter(Change::details)).setter(Change.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()}).build();
    private static final SdkField<String> CHANGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeName").getter(Change.getter(Change::changeName)).setter(Change.setter(Builder::changeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_TYPE_FIELD, ENTITY_FIELD, ENTITY_TAGS_FIELD, DETAILS_FIELD, CHANGE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String changeType;
    private final Entity entity;
    private final List<Tag> entityTags;
    private final String details;
    private final String changeName;

    private Change(BuilderImpl builder) {
        this.changeType = builder.changeType;
        this.entity = builder.entity;
        this.entityTags = builder.entityTags;
        this.details = builder.details;
        this.changeName = builder.changeName;
    }

    public final String changeType() {
        return this.changeType;
    }

    public final Entity entity() {
        return this.entity;
    }

    public final boolean hasEntityTags() {
        return this.entityTags != null && !(this.entityTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> entityTags() {
        return this.entityTags;
    }

    public final String details() {
        return this.details;
    }

    public final String changeName() {
        return this.changeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.changeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.entity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityTags() ? this.entityTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Change)) {
            return false;
        }
        Change other = (Change)obj;
        return Objects.equals(this.changeType(), other.changeType()) && Objects.equals(this.entity(), other.entity()) && this.hasEntityTags() == other.hasEntityTags() && Objects.equals(this.entityTags(), other.entityTags()) && Objects.equals(this.details(), other.details()) && Objects.equals(this.changeName(), other.changeName());
    }

    public final String toString() {
        return ToString.builder((String)"Change").add("ChangeType", (Object)this.changeType()).add("Entity", (Object)this.entity()).add("EntityTags", this.hasEntityTags() ? this.entityTags() : null).add("Details", (Object)this.details()).add("ChangeName", (Object)this.changeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChangeType": {
                return Optional.ofNullable(clazz.cast(this.changeType()));
            }
            case "Entity": {
                return Optional.ofNullable(clazz.cast(this.entity()));
            }
            case "EntityTags": {
                return Optional.ofNullable(clazz.cast(this.entityTags()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "ChangeName": {
                return Optional.ofNullable(clazz.cast(this.changeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Change, T> g) {
        return obj -> g.apply((Change)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String changeType;
        private Entity entity;
        private List<Tag> entityTags = DefaultSdkAutoConstructList.getInstance();
        private String details;
        private String changeName;

        private BuilderImpl() {
        }

        private BuilderImpl(Change model) {
            this.changeType(model.changeType);
            this.entity(model.entity);
            this.entityTags(model.entityTags);
            this.details(model.details);
            this.changeName(model.changeName);
        }

        public final String getChangeType() {
            return this.changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        public final Entity.Builder getEntity() {
            return this.entity != null ? this.entity.toBuilder() : null;
        }

        public final void setEntity(Entity.BuilderImpl entity) {
            this.entity = entity != null ? entity.build() : null;
        }

        @Override
        public final Builder entity(Entity entity) {
            this.entity = entity;
            return this;
        }

        public final List<Tag.Builder> getEntityTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.entityTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntityTags(Collection<Tag.BuilderImpl> entityTags) {
            this.entityTags = TagListCopier.copyFromBuilder(entityTags);
        }

        @Override
        public final Builder entityTags(Collection<Tag> entityTags) {
            this.entityTags = TagListCopier.copy(entityTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTags(Tag ... entityTags) {
            this.entityTags(Arrays.asList(entityTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTags(Consumer<Tag.Builder> ... entityTags) {
            this.entityTags(Stream.of(entityTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDetails() {
            return this.details;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final String getChangeName() {
            return this.changeName;
        }

        public final void setChangeName(String changeName) {
            this.changeName = changeName;
        }

        @Override
        public final Builder changeName(String changeName) {
            this.changeName = changeName;
            return this;
        }

        public Change build() {
            return new Change(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Change> {
        public Builder changeType(String var1);

        public Builder entity(Entity var1);

        default public Builder entity(Consumer<Entity.Builder> entity) {
            return this.entity((Entity)((Entity.Builder)Entity.builder().applyMutation(entity)).build());
        }

        public Builder entityTags(Collection<Tag> var1);

        public Builder entityTags(Tag ... var1);

        public Builder entityTags(Consumer<Tag.Builder> ... var1);

        public Builder details(String var1);

        public Builder changeName(String var1);
    }
}

