/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.marketplacecatalog.MarketplaceCatalogAsyncClient;
import software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesResponse;

public class ListEntitiesPublisher
implements SdkPublisher<ListEntitiesResponse> {
    private final MarketplaceCatalogAsyncClient client;
    private final ListEntitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEntitiesPublisher(MarketplaceCatalogAsyncClient client, ListEntitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEntitiesPublisher(MarketplaceCatalogAsyncClient client, ListEntitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEntitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEntitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListEntitiesResponseFetcher
    implements AsyncPageFetcher<ListEntitiesResponse> {
        private ListEntitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListEntitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEntitiesResponse> nextPage(ListEntitiesResponse previousPage) {
            if (previousPage == null) {
                return ListEntitiesPublisher.this.client.listEntities(ListEntitiesPublisher.this.firstRequest);
            }
            return ListEntitiesPublisher.this.client.listEntities((ListEntitiesRequest)((Object)ListEntitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

