/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie.MacieClient;
import software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest;
import software.amazon.awssdk.services.macie.model.ListMemberAccountsResponse;

public class ListMemberAccountsIterable
implements SdkIterable<ListMemberAccountsResponse> {
    private final MacieClient client;
    private final ListMemberAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMemberAccountsIterable(MacieClient client, ListMemberAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMemberAccountsResponseFetcher();
    }

    public Iterator<ListMemberAccountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMemberAccountsResponseFetcher
    implements SyncPageFetcher<ListMemberAccountsResponse> {
        private ListMemberAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListMemberAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMemberAccountsResponse nextPage(ListMemberAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListMemberAccountsIterable.this.client.listMemberAccounts(ListMemberAccountsIterable.this.firstRequest);
            }
            return ListMemberAccountsIterable.this.client.listMemberAccounts((ListMemberAccountsRequest)((Object)ListMemberAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

