/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The database details of an Amazon RDS database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RDSDatabase implements SdkPojo, Serializable, ToCopyableBuilder<RDSDatabase.Builder, RDSDatabase> {
    private static final SdkField<String> INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceIdentifier").getter(getter(RDSDatabase::instanceIdentifier))
            .setter(setter(Builder::instanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIdentifier").build())
            .build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(RDSDatabase::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_IDENTIFIER_FIELD,
            DATABASE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceIdentifier;

    private final String databaseName;

    private RDSDatabase(BuilderImpl builder) {
        this.instanceIdentifier = builder.instanceIdentifier;
        this.databaseName = builder.databaseName;
    }

    /**
     * <p>
     * The ID of an RDS DB instance.
     * </p>
     * 
     * @return The ID of an RDS DB instance.
     */
    public final String instanceIdentifier() {
        return instanceIdentifier;
    }

    /**
     * Returns the value of the DatabaseName property for this object.
     * 
     * @return The value of the DatabaseName property for this object.
     */
    public final String databaseName() {
        return databaseName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDatabase)) {
            return false;
        }
        RDSDatabase other = (RDSDatabase) obj;
        return Objects.equals(instanceIdentifier(), other.instanceIdentifier())
                && Objects.equals(databaseName(), other.databaseName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RDSDatabase").add("InstanceIdentifier", instanceIdentifier())
                .add("DatabaseName", databaseName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceIdentifier":
            return Optional.ofNullable(clazz.cast(instanceIdentifier()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RDSDatabase, T> g) {
        return obj -> g.apply((RDSDatabase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RDSDatabase> {
        /**
         * <p>
         * The ID of an RDS DB instance.
         * </p>
         * 
         * @param instanceIdentifier
         *        The ID of an RDS DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIdentifier(String instanceIdentifier);

        /**
         * Sets the value of the DatabaseName property for this object.
         *
         * @param databaseName
         *        The new value for the DatabaseName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);
    }

    static final class BuilderImpl implements Builder {
        private String instanceIdentifier;

        private String databaseName;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDatabase model) {
            instanceIdentifier(model.instanceIdentifier);
            databaseName(model.databaseName);
        }

        public final String getInstanceIdentifier() {
            return instanceIdentifier;
        }

        public final void setInstanceIdentifier(String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
        }

        @Override
        public final Builder instanceIdentifier(String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        @Override
        public RDSDatabase build() {
            return new RDSDatabase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
