/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * Contains the key values of <code>DetailsMap</code>:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>PredictiveModelType</code> - Indicates the type of the <code>MLModel</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Algorithm</code> - Indicates the algorithm that was used for the <code>MLModel</code>.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public enum DetailsAttributes {
    PREDICTIVE_MODEL_TYPE("PredictiveModelType"),

    ALGORITHM("Algorithm"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DetailsAttributes> VALUE_MAP = EnumUtils.uniqueIndex(DetailsAttributes.class,
            DetailsAttributes::toString);

    private final String value;

    private DetailsAttributes(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DetailsAttributes corresponding to the value
     */
    public static DetailsAttributes fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DetailsAttributes}s
     */
    public static Set<DetailsAttributes> knownValues() {
        Set<DetailsAttributes> knownValues = EnumSet.allOf(DetailsAttributes.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
