/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEngineVersionsResponse extends M2Response implements
        ToCopyableBuilder<ListEngineVersionsResponse.Builder, ListEngineVersionsResponse> {
    private static final SdkField<List<EngineVersionsSummary>> ENGINE_VERSIONS_FIELD = SdkField
            .<List<EngineVersionsSummary>> builder(MarshallingType.LIST)
            .memberName("engineVersions")
            .getter(getter(ListEngineVersionsResponse::engineVersions))
            .setter(setter(Builder::engineVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngineVersionsSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngineVersionsSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEngineVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EngineVersionsSummary> engineVersions;

    private final String nextToken;

    private ListEngineVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.engineVersions = builder.engineVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EngineVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEngineVersions() {
        return engineVersions != null && !(engineVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the engine versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEngineVersions} method.
     * </p>
     * 
     * @return Returns the engine versions.
     */
    public final List<EngineVersionsSummary> engineVersions() {
        return engineVersions;
    }

    /**
     * <p>
     * If there are more items to return, this contains a token that is passed to a subsequent call to this operation to
     * retrieve the next set of items.
     * </p>
     * 
     * @return If there are more items to return, this contains a token that is passed to a subsequent call to this
     *         operation to retrieve the next set of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEngineVersions() ? engineVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngineVersionsResponse)) {
            return false;
        }
        ListEngineVersionsResponse other = (ListEngineVersionsResponse) obj;
        return hasEngineVersions() == other.hasEngineVersions() && Objects.equals(engineVersions(), other.engineVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEngineVersionsResponse")
                .add("EngineVersions", hasEngineVersions() ? engineVersions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "engineVersions":
            return Optional.ofNullable(clazz.cast(engineVersions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEngineVersionsResponse, T> g) {
        return obj -> g.apply((ListEngineVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends M2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListEngineVersionsResponse> {
        /**
         * <p>
         * Returns the engine versions.
         * </p>
         * 
         * @param engineVersions
         *        Returns the engine versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersions(Collection<EngineVersionsSummary> engineVersions);

        /**
         * <p>
         * Returns the engine versions.
         * </p>
         * 
         * @param engineVersions
         *        Returns the engine versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersions(EngineVersionsSummary... engineVersions);

        /**
         * <p>
         * Returns the engine versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.m2.model.EngineVersionsSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.m2.model.EngineVersionsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.m2.model.EngineVersionsSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #engineVersions(List<EngineVersionsSummary>)}.
         * 
         * @param engineVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.m2.model.EngineVersionsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineVersions(java.util.Collection<EngineVersionsSummary>)
         */
        Builder engineVersions(Consumer<EngineVersionsSummary.Builder>... engineVersions);

        /**
         * <p>
         * If there are more items to return, this contains a token that is passed to a subsequent call to this
         * operation to retrieve the next set of items.
         * </p>
         * 
         * @param nextToken
         *        If there are more items to return, this contains a token that is passed to a subsequent call to this
         *        operation to retrieve the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends M2Response.BuilderImpl implements Builder {
        private List<EngineVersionsSummary> engineVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngineVersionsResponse model) {
            super(model);
            engineVersions(model.engineVersions);
            nextToken(model.nextToken);
        }

        public final List<EngineVersionsSummary.Builder> getEngineVersions() {
            List<EngineVersionsSummary.Builder> result = EngineVersionsSummaryListCopier.copyToBuilder(this.engineVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEngineVersions(Collection<EngineVersionsSummary.BuilderImpl> engineVersions) {
            this.engineVersions = EngineVersionsSummaryListCopier.copyFromBuilder(engineVersions);
        }

        @Override
        public final Builder engineVersions(Collection<EngineVersionsSummary> engineVersions) {
            this.engineVersions = EngineVersionsSummaryListCopier.copy(engineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineVersions(EngineVersionsSummary... engineVersions) {
            engineVersions(Arrays.asList(engineVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineVersions(Consumer<EngineVersionsSummary.Builder>... engineVersions) {
            engineVersions(Stream.of(engineVersions).map(c -> EngineVersionsSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEngineVersionsResponse build() {
            return new ListEngineVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
