/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataSetsResponse extends M2Response implements
        ToCopyableBuilder<ListDataSetsResponse.Builder, ListDataSetsResponse> {
    private static final SdkField<List<DataSetSummary>> DATA_SETS_FIELD = SdkField
            .<List<DataSetSummary>> builder(MarshallingType.LIST)
            .memberName("dataSets")
            .getter(getter(ListDataSetsResponse::dataSets))
            .setter(setter(Builder::dataSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDataSetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SETS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DataSetSummary> dataSets;

    private final String nextToken;

    private ListDataSetsResponse(BuilderImpl builder) {
        super(builder);
        this.dataSets = builder.dataSets;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDataSets() {
        return dataSets != null && !(dataSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of data sets, containing information including the creation time, the data set name, the data set
     * organization, the data set format, and the last time the data set was referenced or updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSets} method.
     * </p>
     * 
     * @return The list of data sets, containing information including the creation time, the data set name, the data
     *         set organization, the data set format, and the last time the data set was referenced or updated.
     */
    public final List<DataSetSummary> dataSets() {
        return dataSets;
    }

    /**
     * <p>
     * If there are more items to return, this contains a token that is passed to a subsequent call to this operation to
     * retrieve the next set of items.
     * </p>
     * 
     * @return If there are more items to return, this contains a token that is passed to a subsequent call to this
     *         operation to retrieve the next set of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSets() ? dataSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSetsResponse)) {
            return false;
        }
        ListDataSetsResponse other = (ListDataSetsResponse) obj;
        return hasDataSets() == other.hasDataSets() && Objects.equals(dataSets(), other.dataSets())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataSetsResponse").add("DataSets", hasDataSets() ? dataSets() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSets":
            return Optional.ofNullable(clazz.cast(dataSets()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSetsResponse, T> g) {
        return obj -> g.apply((ListDataSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends M2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListDataSetsResponse> {
        /**
         * <p>
         * The list of data sets, containing information including the creation time, the data set name, the data set
         * organization, the data set format, and the last time the data set was referenced or updated.
         * </p>
         * 
         * @param dataSets
         *        The list of data sets, containing information including the creation time, the data set name, the data
         *        set organization, the data set format, and the last time the data set was referenced or updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(Collection<DataSetSummary> dataSets);

        /**
         * <p>
         * The list of data sets, containing information including the creation time, the data set name, the data set
         * organization, the data set format, and the last time the data set was referenced or updated.
         * </p>
         * 
         * @param dataSets
         *        The list of data sets, containing information including the creation time, the data set name, the data
         *        set organization, the data set format, and the last time the data set was referenced or updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(DataSetSummary... dataSets);

        /**
         * <p>
         * The list of data sets, containing information including the creation time, the data set name, the data set
         * organization, the data set format, and the last time the data set was referenced or updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.m2.model.DataSetSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.m2.model.DataSetSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.m2.model.DataSetSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSets(List<DataSetSummary>)}.
         * 
         * @param dataSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.m2.model.DataSetSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSets(java.util.Collection<DataSetSummary>)
         */
        Builder dataSets(Consumer<DataSetSummary.Builder>... dataSets);

        /**
         * <p>
         * If there are more items to return, this contains a token that is passed to a subsequent call to this
         * operation to retrieve the next set of items.
         * </p>
         * 
         * @param nextToken
         *        If there are more items to return, this contains a token that is passed to a subsequent call to this
         *        operation to retrieve the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends M2Response.BuilderImpl implements Builder {
        private List<DataSetSummary> dataSets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSetsResponse model) {
            super(model);
            dataSets(model.dataSets);
            nextToken(model.nextToken);
        }

        public final List<DataSetSummary.Builder> getDataSets() {
            List<DataSetSummary.Builder> result = DataSetsSummaryListCopier.copyToBuilder(this.dataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSets(Collection<DataSetSummary.BuilderImpl> dataSets) {
            this.dataSets = DataSetsSummaryListCopier.copyFromBuilder(dataSets);
        }

        @Override
        public final Builder dataSets(Collection<DataSetSummary> dataSets) {
            this.dataSets = DataSetsSummaryListCopier.copy(dataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(DataSetSummary... dataSets) {
            dataSets(Arrays.asList(dataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(Consumer<DataSetSummary.Builder>... dataSets) {
            dataSets(Stream.of(dataSets).map(c -> DataSetSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataSetsResponse build() {
            return new ListDataSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
