/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEnvironmentResponse extends M2Response implements
        ToCopyableBuilder<GetEnvironmentResponse.Builder, GetEnvironmentResponse> {
    private static final SdkField<Integer> ACTUAL_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("actualCapacity").getter(getter(GetEnvironmentResponse::actualCapacity))
            .setter(setter(Builder::actualCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualCapacity").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(GetEnvironmentResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetEnvironmentResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineType").getter(getter(GetEnvironmentResponse::engineTypeAsString))
            .setter(setter(Builder::engineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineVersion").getter(getter(GetEnvironmentResponse::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()).build();

    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentArn").getter(getter(GetEnvironmentResponse::environmentArn))
            .setter(setter(Builder::environmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentArn").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(GetEnvironmentResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<HighAvailabilityConfig> HIGH_AVAILABILITY_CONFIG_FIELD = SdkField
            .<HighAvailabilityConfig> builder(MarshallingType.SDK_POJO).memberName("highAvailabilityConfig")
            .getter(getter(GetEnvironmentResponse::highAvailabilityConfig)).setter(setter(Builder::highAvailabilityConfig))
            .constructor(HighAvailabilityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("highAvailabilityConfig").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(GetEnvironmentResponse::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(GetEnvironmentResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("loadBalancerArn").getter(getter(GetEnvironmentResponse::loadBalancerArn))
            .setter(setter(Builder::loadBalancerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetEnvironmentResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<PendingMaintenance> PENDING_MAINTENANCE_FIELD = SdkField
            .<PendingMaintenance> builder(MarshallingType.SDK_POJO).memberName("pendingMaintenance")
            .getter(getter(GetEnvironmentResponse::pendingMaintenance)).setter(setter(Builder::pendingMaintenance))
            .constructor(PendingMaintenance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingMaintenance").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("preferredMaintenanceWindow")
            .getter(getter(GetEnvironmentResponse::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publiclyAccessible").getter(getter(GetEnvironmentResponse::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(GetEnvironmentResponse::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetEnvironmentResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(GetEnvironmentResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<List<StorageConfiguration>> STORAGE_CONFIGURATIONS_FIELD = SdkField
            .<List<StorageConfiguration>> builder(MarshallingType.LIST)
            .memberName("storageConfigurations")
            .getter(getter(GetEnvironmentResponse::storageConfigurations))
            .setter(setter(Builder::storageConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StorageConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorageConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(GetEnvironmentResponse::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetEnvironmentResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vpcId")
            .getter(getter(GetEnvironmentResponse::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTUAL_CAPACITY_FIELD,
            CREATION_TIME_FIELD, DESCRIPTION_FIELD, ENGINE_TYPE_FIELD, ENGINE_VERSION_FIELD, ENVIRONMENT_ARN_FIELD,
            ENVIRONMENT_ID_FIELD, HIGH_AVAILABILITY_CONFIG_FIELD, INSTANCE_TYPE_FIELD, KMS_KEY_ID_FIELD, LOAD_BALANCER_ARN_FIELD,
            NAME_FIELD, PENDING_MAINTENANCE_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PUBLICLY_ACCESSIBLE_FIELD,
            SECURITY_GROUP_IDS_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, STORAGE_CONFIGURATIONS_FIELD, SUBNET_IDS_FIELD,
            TAGS_FIELD, VPC_ID_FIELD));

    private final Integer actualCapacity;

    private final Instant creationTime;

    private final String description;

    private final String engineType;

    private final String engineVersion;

    private final String environmentArn;

    private final String environmentId;

    private final HighAvailabilityConfig highAvailabilityConfig;

    private final String instanceType;

    private final String kmsKeyId;

    private final String loadBalancerArn;

    private final String name;

    private final PendingMaintenance pendingMaintenance;

    private final String preferredMaintenanceWindow;

    private final Boolean publiclyAccessible;

    private final List<String> securityGroupIds;

    private final String status;

    private final String statusReason;

    private final List<StorageConfiguration> storageConfigurations;

    private final List<String> subnetIds;

    private final Map<String, String> tags;

    private final String vpcId;

    private GetEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.actualCapacity = builder.actualCapacity;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
        this.environmentArn = builder.environmentArn;
        this.environmentId = builder.environmentId;
        this.highAvailabilityConfig = builder.highAvailabilityConfig;
        this.instanceType = builder.instanceType;
        this.kmsKeyId = builder.kmsKeyId;
        this.loadBalancerArn = builder.loadBalancerArn;
        this.name = builder.name;
        this.pendingMaintenance = builder.pendingMaintenance;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroupIds = builder.securityGroupIds;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.storageConfigurations = builder.storageConfigurations;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The number of instances included in the runtime environment. A standalone runtime environment has a maxiumum of
     * one instance. Currently, a high availability runtime environment has a maximum of two instances.
     * </p>
     * 
     * @return The number of instances included in the runtime environment. A standalone runtime environment has a
     *         maxiumum of one instance. Currently, a high availability runtime environment has a maximum of two
     *         instances.
     */
    public final Integer actualCapacity() {
        return actualCapacity;
    }

    /**
     * <p>
     * The timestamp when the runtime environment was created.
     * </p>
     * 
     * @return The timestamp when the runtime environment was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The description of the runtime environment.
     * </p>
     * 
     * @return The description of the runtime environment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The target platform for the runtime environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The target platform for the runtime environment.
     * @see EngineType
     */
    public final EngineType engineType() {
        return EngineType.fromValue(engineType);
    }

    /**
     * <p>
     * The target platform for the runtime environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The target platform for the runtime environment.
     * @see EngineType
     */
    public final String engineTypeAsString() {
        return engineType;
    }

    /**
     * <p>
     * The version of the runtime engine.
     * </p>
     * 
     * @return The version of the runtime engine.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the runtime environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the runtime environment.
     */
    public final String environmentArn() {
        return environmentArn;
    }

    /**
     * <p>
     * The unique identifier of the runtime environment.
     * </p>
     * 
     * @return The unique identifier of the runtime environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The desired capacity of the high availability configuration for the runtime environment.
     * </p>
     * 
     * @return The desired capacity of the high availability configuration for the runtime environment.
     */
    public final HighAvailabilityConfig highAvailabilityConfig() {
        return highAvailabilityConfig;
    }

    /**
     * <p>
     * The type of instance underlying the runtime environment.
     * </p>
     * 
     * @return The type of instance underlying the runtime environment.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The identifier of a customer managed key.
     * </p>
     * 
     * @return The identifier of a customer managed key.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the load balancer used with the runtime environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the load balancer used with the runtime environment.
     */
    public final String loadBalancerArn() {
        return loadBalancerArn;
    }

    /**
     * <p>
     * The name of the runtime environment. Must be unique within the account.
     * </p>
     * 
     * @return The name of the runtime environment. Must be unique within the account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Indicates the pending maintenance scheduled on this environment.
     * </p>
     * 
     * @return Indicates the pending maintenance scheduled on this environment.
     */
    public final PendingMaintenance pendingMaintenance() {
        return pendingMaintenance;
    }

    /**
     * <p>
     * Configures the maintenance window you want for the runtime environment. If you do not provide a value, a random
     * system-generated value will be assigned.
     * </p>
     * 
     * @return Configures the maintenance window you want for the runtime environment. If you do not provide a value, a
     *         random system-generated value will be assigned.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Whether applications running in this runtime environment are publicly accessible.
     * </p>
     * 
     * @return Whether applications running in this runtime environment are publicly accessible.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifiers of the security groups assigned to this runtime environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The unique identifiers of the security groups assigned to this runtime environment.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The status of the runtime environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the runtime environment.
     * @see EnvironmentLifecycle
     */
    public final EnvironmentLifecycle status() {
        return EnvironmentLifecycle.fromValue(status);
    }

    /**
     * <p>
     * The status of the runtime environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the runtime environment.
     * @see EnvironmentLifecycle
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the reported status.
     * </p>
     * 
     * @return The reason for the reported status.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the StorageConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStorageConfigurations() {
        return storageConfigurations != null && !(storageConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The storage configurations defined for the runtime environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorageConfigurations} method.
     * </p>
     * 
     * @return The storage configurations defined for the runtime environment.
     */
    public final List<StorageConfiguration> storageConfigurations() {
        return storageConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifiers of the subnets assigned to this runtime environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The unique identifiers of the subnets assigned to this runtime environment.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags defined for this runtime environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags defined for this runtime environment.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The unique identifier for the VPC used with this runtime environment.
     * </p>
     * 
     * @return The unique identifier for the VPC used with this runtime environment.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actualCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(environmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(highAvailabilityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pendingMaintenance());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasStorageConfigurations() ? storageConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnvironmentResponse)) {
            return false;
        }
        GetEnvironmentResponse other = (GetEnvironmentResponse) obj;
        return Objects.equals(actualCapacity(), other.actualCapacity()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(description(), other.description())
                && Objects.equals(engineTypeAsString(), other.engineTypeAsString())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(environmentArn(), other.environmentArn())
                && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(highAvailabilityConfig(), other.highAvailabilityConfig())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(name(), other.name())
                && Objects.equals(pendingMaintenance(), other.pendingMaintenance())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && hasStorageConfigurations() == other.hasStorageConfigurations()
                && Objects.equals(storageConfigurations(), other.storageConfigurations())
                && hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEnvironmentResponse").add("ActualCapacity", actualCapacity())
                .add("CreationTime", creationTime()).add("Description", description()).add("EngineType", engineTypeAsString())
                .add("EngineVersion", engineVersion()).add("EnvironmentArn", environmentArn())
                .add("EnvironmentId", environmentId()).add("HighAvailabilityConfig", highAvailabilityConfig())
                .add("InstanceType", instanceType()).add("KmsKeyId", kmsKeyId()).add("LoadBalancerArn", loadBalancerArn())
                .add("Name", name()).add("PendingMaintenance", pendingMaintenance())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("PubliclyAccessible", publiclyAccessible())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).add("Status", statusAsString())
                .add("StatusReason", statusReason())
                .add("StorageConfigurations", hasStorageConfigurations() ? storageConfigurations() : null)
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("Tags", hasTags() ? tags() : null)
                .add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actualCapacity":
            return Optional.ofNullable(clazz.cast(actualCapacity()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "engineType":
            return Optional.ofNullable(clazz.cast(engineTypeAsString()));
        case "engineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "environmentArn":
            return Optional.ofNullable(clazz.cast(environmentArn()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "highAvailabilityConfig":
            return Optional.ofNullable(clazz.cast(highAvailabilityConfig()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "loadBalancerArn":
            return Optional.ofNullable(clazz.cast(loadBalancerArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "pendingMaintenance":
            return Optional.ofNullable(clazz.cast(pendingMaintenance()));
        case "preferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "publiclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "storageConfigurations":
            return Optional.ofNullable(clazz.cast(storageConfigurations()));
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "vpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEnvironmentResponse, T> g) {
        return obj -> g.apply((GetEnvironmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends M2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetEnvironmentResponse> {
        /**
         * <p>
         * The number of instances included in the runtime environment. A standalone runtime environment has a maxiumum
         * of one instance. Currently, a high availability runtime environment has a maximum of two instances.
         * </p>
         * 
         * @param actualCapacity
         *        The number of instances included in the runtime environment. A standalone runtime environment has a
         *        maxiumum of one instance. Currently, a high availability runtime environment has a maximum of two
         *        instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualCapacity(Integer actualCapacity);

        /**
         * <p>
         * The timestamp when the runtime environment was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp when the runtime environment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The description of the runtime environment.
         * </p>
         * 
         * @param description
         *        The description of the runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The target platform for the runtime environment.
         * </p>
         * 
         * @param engineType
         *        The target platform for the runtime environment.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(String engineType);

        /**
         * <p>
         * The target platform for the runtime environment.
         * </p>
         * 
         * @param engineType
         *        The target platform for the runtime environment.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(EngineType engineType);

        /**
         * <p>
         * The version of the runtime engine.
         * </p>
         * 
         * @param engineVersion
         *        The version of the runtime engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the runtime environment.
         * </p>
         * 
         * @param environmentArn
         *        The Amazon Resource Name (ARN) of the runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentArn(String environmentArn);

        /**
         * <p>
         * The unique identifier of the runtime environment.
         * </p>
         * 
         * @param environmentId
         *        The unique identifier of the runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The desired capacity of the high availability configuration for the runtime environment.
         * </p>
         * 
         * @param highAvailabilityConfig
         *        The desired capacity of the high availability configuration for the runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highAvailabilityConfig(HighAvailabilityConfig highAvailabilityConfig);

        /**
         * <p>
         * The desired capacity of the high availability configuration for the runtime environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link HighAvailabilityConfig.Builder} avoiding
         * the need to create one manually via {@link HighAvailabilityConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HighAvailabilityConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #highAvailabilityConfig(HighAvailabilityConfig)}.
         * 
         * @param highAvailabilityConfig
         *        a consumer that will call methods on {@link HighAvailabilityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #highAvailabilityConfig(HighAvailabilityConfig)
         */
        default Builder highAvailabilityConfig(Consumer<HighAvailabilityConfig.Builder> highAvailabilityConfig) {
            return highAvailabilityConfig(HighAvailabilityConfig.builder().applyMutation(highAvailabilityConfig).build());
        }

        /**
         * <p>
         * The type of instance underlying the runtime environment.
         * </p>
         * 
         * @param instanceType
         *        The type of instance underlying the runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The identifier of a customer managed key.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier of a customer managed key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the load balancer used with the runtime environment.
         * </p>
         * 
         * @param loadBalancerArn
         *        The Amazon Resource Name (ARN) for the load balancer used with the runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerArn(String loadBalancerArn);

        /**
         * <p>
         * The name of the runtime environment. Must be unique within the account.
         * </p>
         * 
         * @param name
         *        The name of the runtime environment. Must be unique within the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Indicates the pending maintenance scheduled on this environment.
         * </p>
         * 
         * @param pendingMaintenance
         *        Indicates the pending maintenance scheduled on this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingMaintenance(PendingMaintenance pendingMaintenance);

        /**
         * <p>
         * Indicates the pending maintenance scheduled on this environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link PendingMaintenance.Builder} avoiding the
         * need to create one manually via {@link PendingMaintenance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PendingMaintenance.Builder#build()} is called immediately and its
         * result is passed to {@link #pendingMaintenance(PendingMaintenance)}.
         * 
         * @param pendingMaintenance
         *        a consumer that will call methods on {@link PendingMaintenance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingMaintenance(PendingMaintenance)
         */
        default Builder pendingMaintenance(Consumer<PendingMaintenance.Builder> pendingMaintenance) {
            return pendingMaintenance(PendingMaintenance.builder().applyMutation(pendingMaintenance).build());
        }

        /**
         * <p>
         * Configures the maintenance window you want for the runtime environment. If you do not provide a value, a
         * random system-generated value will be assigned.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        Configures the maintenance window you want for the runtime environment. If you do not provide a value,
         *        a random system-generated value will be assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * Whether applications running in this runtime environment are publicly accessible.
         * </p>
         * 
         * @param publiclyAccessible
         *        Whether applications running in this runtime environment are publicly accessible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The unique identifiers of the security groups assigned to this runtime environment.
         * </p>
         * 
         * @param securityGroupIds
         *        The unique identifiers of the security groups assigned to this runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The unique identifiers of the security groups assigned to this runtime environment.
         * </p>
         * 
         * @param securityGroupIds
         *        The unique identifiers of the security groups assigned to this runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The status of the runtime environment.
         * </p>
         * 
         * @param status
         *        The status of the runtime environment.
         * @see EnvironmentLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentLifecycle
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the runtime environment.
         * </p>
         * 
         * @param status
         *        The status of the runtime environment.
         * @see EnvironmentLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentLifecycle
         */
        Builder status(EnvironmentLifecycle status);

        /**
         * <p>
         * The reason for the reported status.
         * </p>
         * 
         * @param statusReason
         *        The reason for the reported status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The storage configurations defined for the runtime environment.
         * </p>
         * 
         * @param storageConfigurations
         *        The storage configurations defined for the runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfigurations(Collection<StorageConfiguration> storageConfigurations);

        /**
         * <p>
         * The storage configurations defined for the runtime environment.
         * </p>
         * 
         * @param storageConfigurations
         *        The storage configurations defined for the runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfigurations(StorageConfiguration... storageConfigurations);

        /**
         * <p>
         * The storage configurations defined for the runtime environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.m2.model.StorageConfiguration.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.m2.model.StorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.m2.model.StorageConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #storageConfigurations(List<StorageConfiguration>)}.
         * 
         * @param storageConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.m2.model.StorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConfigurations(java.util.Collection<StorageConfiguration>)
         */
        Builder storageConfigurations(Consumer<StorageConfiguration.Builder>... storageConfigurations);

        /**
         * <p>
         * The unique identifiers of the subnets assigned to this runtime environment.
         * </p>
         * 
         * @param subnetIds
         *        The unique identifiers of the subnets assigned to this runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The unique identifiers of the subnets assigned to this runtime environment.
         * </p>
         * 
         * @param subnetIds
         *        The unique identifiers of the subnets assigned to this runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The tags defined for this runtime environment.
         * </p>
         * 
         * @param tags
         *        The tags defined for this runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The unique identifier for the VPC used with this runtime environment.
         * </p>
         * 
         * @param vpcId
         *        The unique identifier for the VPC used with this runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl extends M2Response.BuilderImpl implements Builder {
        private Integer actualCapacity;

        private Instant creationTime;

        private String description;

        private String engineType;

        private String engineVersion;

        private String environmentArn;

        private String environmentId;

        private HighAvailabilityConfig highAvailabilityConfig;

        private String instanceType;

        private String kmsKeyId;

        private String loadBalancerArn;

        private String name;

        private PendingMaintenance pendingMaintenance;

        private String preferredMaintenanceWindow;

        private Boolean publiclyAccessible;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String statusReason;

        private List<StorageConfiguration> storageConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnvironmentResponse model) {
            super(model);
            actualCapacity(model.actualCapacity);
            creationTime(model.creationTime);
            description(model.description);
            engineType(model.engineType);
            engineVersion(model.engineVersion);
            environmentArn(model.environmentArn);
            environmentId(model.environmentId);
            highAvailabilityConfig(model.highAvailabilityConfig);
            instanceType(model.instanceType);
            kmsKeyId(model.kmsKeyId);
            loadBalancerArn(model.loadBalancerArn);
            name(model.name);
            pendingMaintenance(model.pendingMaintenance);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            publiclyAccessible(model.publiclyAccessible);
            securityGroupIds(model.securityGroupIds);
            status(model.status);
            statusReason(model.statusReason);
            storageConfigurations(model.storageConfigurations);
            subnetIds(model.subnetIds);
            tags(model.tags);
            vpcId(model.vpcId);
        }

        public final Integer getActualCapacity() {
            return actualCapacity;
        }

        public final void setActualCapacity(Integer actualCapacity) {
            this.actualCapacity = actualCapacity;
        }

        @Override
        public final Builder actualCapacity(Integer actualCapacity) {
            this.actualCapacity = actualCapacity;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngineType() {
            return engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getEnvironmentArn() {
            return environmentArn;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final HighAvailabilityConfig.Builder getHighAvailabilityConfig() {
            return highAvailabilityConfig != null ? highAvailabilityConfig.toBuilder() : null;
        }

        public final void setHighAvailabilityConfig(HighAvailabilityConfig.BuilderImpl highAvailabilityConfig) {
            this.highAvailabilityConfig = highAvailabilityConfig != null ? highAvailabilityConfig.build() : null;
        }

        @Override
        public final Builder highAvailabilityConfig(HighAvailabilityConfig highAvailabilityConfig) {
            this.highAvailabilityConfig = highAvailabilityConfig;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getLoadBalancerArn() {
            return loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PendingMaintenance.Builder getPendingMaintenance() {
            return pendingMaintenance != null ? pendingMaintenance.toBuilder() : null;
        }

        public final void setPendingMaintenance(PendingMaintenance.BuilderImpl pendingMaintenance) {
            this.pendingMaintenance = pendingMaintenance != null ? pendingMaintenance.build() : null;
        }

        @Override
        public final Builder pendingMaintenance(PendingMaintenance pendingMaintenance) {
            this.pendingMaintenance = pendingMaintenance;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = String50ListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = String50ListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final List<StorageConfiguration.Builder> getStorageConfigurations() {
            List<StorageConfiguration.Builder> result = StorageConfigurationListCopier.copyToBuilder(this.storageConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageConfigurations(Collection<StorageConfiguration.BuilderImpl> storageConfigurations) {
            this.storageConfigurations = StorageConfigurationListCopier.copyFromBuilder(storageConfigurations);
        }

        @Override
        public final Builder storageConfigurations(Collection<StorageConfiguration> storageConfigurations) {
            this.storageConfigurations = StorageConfigurationListCopier.copy(storageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigurations(StorageConfiguration... storageConfigurations) {
            storageConfigurations(Arrays.asList(storageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigurations(Consumer<StorageConfiguration.Builder>... storageConfigurations) {
            storageConfigurations(Stream.of(storageConfigurations)
                    .map(c -> StorageConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = String50ListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = String50ListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public GetEnvironmentResponse build() {
            return new GetEnvironmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
