/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataSetDetailsRequest extends M2Request implements
        ToCopyableBuilder<GetDataSetDetailsRequest.Builder, GetDataSetDetailsRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(GetDataSetDetailsRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> DATA_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSetName").getter(getter(GetDataSetDetailsRequest::dataSetName)).setter(setter(Builder::dataSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSetName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            DATA_SET_NAME_FIELD));

    private final String applicationId;

    private final String dataSetName;

    private GetDataSetDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.dataSetName = builder.dataSetName;
    }

    /**
     * <p>
     * The unique identifier of the application that this data set is associated with.
     * </p>
     * 
     * @return The unique identifier of the application that this data set is associated with.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The name of the data set.
     * </p>
     * 
     * @return The name of the data set.
     */
    public final String dataSetName() {
        return dataSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSetDetailsRequest)) {
            return false;
        }
        GetDataSetDetailsRequest other = (GetDataSetDetailsRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(dataSetName(), other.dataSetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataSetDetailsRequest").add("ApplicationId", applicationId())
                .add("DataSetName", dataSetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "dataSetName":
            return Optional.ofNullable(clazz.cast(dataSetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataSetDetailsRequest, T> g) {
        return obj -> g.apply((GetDataSetDetailsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends M2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetDataSetDetailsRequest> {
        /**
         * <p>
         * The unique identifier of the application that this data set is associated with.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the application that this data set is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The name of the data set.
         * </p>
         * 
         * @param dataSetName
         *        The name of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetName(String dataSetName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends M2Request.BuilderImpl implements Builder {
        private String applicationId;

        private String dataSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSetDetailsRequest model) {
            super(model);
            applicationId(model.applicationId);
            dataSetName(model.dataSetName);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getDataSetName() {
            return dataSetName;
        }

        public final void setDataSetName(String dataSetName) {
            this.dataSetName = dataSetName;
        }

        @Override
        public final Builder dataSetName(String dataSetName) {
            this.dataSetName = dataSetName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDataSetDetailsRequest build() {
            return new GetDataSetDetailsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
