/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a summary of data set imports.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetImportSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetImportSummary.Builder, DataSetImportSummary> {
    private static final SdkField<Integer> FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failed").getter(getter(DataSetImportSummary::failed)).setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build()).build();

    private static final SdkField<Integer> IN_PROGRESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("inProgress").getter(getter(DataSetImportSummary::inProgress)).setter(setter(Builder::inProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inProgress").build()).build();

    private static final SdkField<Integer> PENDING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("pending").getter(getter(DataSetImportSummary::pending)).setter(setter(Builder::pending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pending").build()).build();

    private static final SdkField<Integer> SUCCEEDED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("succeeded").getter(getter(DataSetImportSummary::succeeded)).setter(setter(Builder::succeeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("succeeded").build()).build();

    private static final SdkField<Integer> TOTAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("total")
            .getter(getter(DataSetImportSummary::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_FIELD,
            IN_PROGRESS_FIELD, PENDING_FIELD, SUCCEEDED_FIELD, TOTAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer failed;

    private final Integer inProgress;

    private final Integer pending;

    private final Integer succeeded;

    private final Integer total;

    private DataSetImportSummary(BuilderImpl builder) {
        this.failed = builder.failed;
        this.inProgress = builder.inProgress;
        this.pending = builder.pending;
        this.succeeded = builder.succeeded;
        this.total = builder.total;
    }

    /**
     * <p>
     * The number of data set imports that have failed.
     * </p>
     * 
     * @return The number of data set imports that have failed.
     */
    public final Integer failed() {
        return failed;
    }

    /**
     * <p>
     * The number of data set imports that are in progress.
     * </p>
     * 
     * @return The number of data set imports that are in progress.
     */
    public final Integer inProgress() {
        return inProgress;
    }

    /**
     * <p>
     * The number of data set imports that are pending.
     * </p>
     * 
     * @return The number of data set imports that are pending.
     */
    public final Integer pending() {
        return pending;
    }

    /**
     * <p>
     * The number of data set imports that have succeeded.
     * </p>
     * 
     * @return The number of data set imports that have succeeded.
     */
    public final Integer succeeded() {
        return succeeded;
    }

    /**
     * <p>
     * The total number of data set imports.
     * </p>
     * 
     * @return The total number of data set imports.
     */
    public final Integer total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        hashCode = 31 * hashCode + Objects.hashCode(inProgress());
        hashCode = 31 * hashCode + Objects.hashCode(pending());
        hashCode = 31 * hashCode + Objects.hashCode(succeeded());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetImportSummary)) {
            return false;
        }
        DataSetImportSummary other = (DataSetImportSummary) obj;
        return Objects.equals(failed(), other.failed()) && Objects.equals(inProgress(), other.inProgress())
                && Objects.equals(pending(), other.pending()) && Objects.equals(succeeded(), other.succeeded())
                && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetImportSummary").add("Failed", failed()).add("InProgress", inProgress())
                .add("Pending", pending()).add("Succeeded", succeeded()).add("Total", total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "inProgress":
            return Optional.ofNullable(clazz.cast(inProgress()));
        case "pending":
            return Optional.ofNullable(clazz.cast(pending()));
        case "succeeded":
            return Optional.ofNullable(clazz.cast(succeeded()));
        case "total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSetImportSummary, T> g) {
        return obj -> g.apply((DataSetImportSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetImportSummary> {
        /**
         * <p>
         * The number of data set imports that have failed.
         * </p>
         * 
         * @param failed
         *        The number of data set imports that have failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Integer failed);

        /**
         * <p>
         * The number of data set imports that are in progress.
         * </p>
         * 
         * @param inProgress
         *        The number of data set imports that are in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inProgress(Integer inProgress);

        /**
         * <p>
         * The number of data set imports that are pending.
         * </p>
         * 
         * @param pending
         *        The number of data set imports that are pending.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(Integer pending);

        /**
         * <p>
         * The number of data set imports that have succeeded.
         * </p>
         * 
         * @param succeeded
         *        The number of data set imports that have succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeeded(Integer succeeded);

        /**
         * <p>
         * The total number of data set imports.
         * </p>
         * 
         * @param total
         *        The total number of data set imports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Integer total);
    }

    static final class BuilderImpl implements Builder {
        private Integer failed;

        private Integer inProgress;

        private Integer pending;

        private Integer succeeded;

        private Integer total;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetImportSummary model) {
            failed(model.failed);
            inProgress(model.inProgress);
            pending(model.pending);
            succeeded(model.succeeded);
            total(model.total);
        }

        public final Integer getFailed() {
            return failed;
        }

        public final void setFailed(Integer failed) {
            this.failed = failed;
        }

        @Override
        public final Builder failed(Integer failed) {
            this.failed = failed;
            return this;
        }

        public final Integer getInProgress() {
            return inProgress;
        }

        public final void setInProgress(Integer inProgress) {
            this.inProgress = inProgress;
        }

        @Override
        public final Builder inProgress(Integer inProgress) {
            this.inProgress = inProgress;
            return this;
        }

        public final Integer getPending() {
            return pending;
        }

        public final void setPending(Integer pending) {
            this.pending = pending;
        }

        @Override
        public final Builder pending(Integer pending) {
            this.pending = pending;
            return this;
        }

        public final Integer getSucceeded() {
            return succeeded;
        }

        public final void setSucceeded(Integer succeeded) {
            this.succeeded = succeeded;
        }

        @Override
        public final Builder succeeded(Integer succeeded) {
            this.succeeded = succeeded;
            return this;
        }

        public final Integer getTotal() {
            return total;
        }

        public final void setTotal(Integer total) {
            this.total = total;
        }

        @Override
        public final Builder total(Integer total) {
            this.total = total;
            return this;
        }

        @Override
        public DataSetImportSummary build() {
            return new DataSetImportSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
