/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeploymentRequest extends M2Request implements
        ToCopyableBuilder<CreateDeploymentRequest.Builder, CreateDeploymentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(CreateDeploymentRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<Integer> APPLICATION_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("applicationVersion").getter(getter(CreateDeploymentRequest::applicationVersion))
            .setter(setter(Builder::applicationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateDeploymentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(CreateDeploymentRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            APPLICATION_VERSION_FIELD, CLIENT_TOKEN_FIELD, ENVIRONMENT_ID_FIELD));

    private final String applicationId;

    private final Integer applicationVersion;

    private final String clientToken;

    private final String environmentId;

    private CreateDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.applicationVersion = builder.applicationVersion;
        this.clientToken = builder.clientToken;
        this.environmentId = builder.environmentId;
    }

    /**
     * <p>
     * The application identifier.
     * </p>
     * 
     * @return The application identifier.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The version of the application to deploy.
     * </p>
     * 
     * @return The version of the application to deploy.
     */
    public final Integer applicationVersion() {
        return applicationVersion;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create a deployment.
     * The service generates the clientToken when the API call is triggered. The token expires after one hour, so if you
     * retry the API within this timeframe with the same clientToken, you will get the same response. The service also
     * handles deleting the clientToken after it expires.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create a
     *         deployment. The service generates the clientToken when the API call is triggered. The token expires after
     *         one hour, so if you retry the API within this timeframe with the same clientToken, you will get the same
     *         response. The service also handles deleting the clientToken after it expires.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier of the runtime environment where you want to deploy this application.
     * </p>
     * 
     * @return The identifier of the runtime environment where you want to deploy this application.
     */
    public final String environmentId() {
        return environmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(applicationVersion(), other.applicationVersion())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(environmentId(), other.environmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDeploymentRequest").add("ApplicationId", applicationId())
                .add("ApplicationVersion", applicationVersion()).add("ClientToken", clientToken())
                .add("EnvironmentId", environmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "applicationVersion":
            return Optional.ofNullable(clazz.cast(applicationVersion()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentRequest, T> g) {
        return obj -> g.apply((CreateDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends M2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeploymentRequest> {
        /**
         * <p>
         * The application identifier.
         * </p>
         * 
         * @param applicationId
         *        The application identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The version of the application to deploy.
         * </p>
         * 
         * @param applicationVersion
         *        The version of the application to deploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersion(Integer applicationVersion);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create a
         * deployment. The service generates the clientToken when the API call is triggered. The token expires after one
         * hour, so if you retry the API within this timeframe with the same clientToken, you will get the same
         * response. The service also handles deleting the clientToken after it expires.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create a
         *        deployment. The service generates the clientToken when the API call is triggered. The token expires
         *        after one hour, so if you retry the API within this timeframe with the same clientToken, you will get
         *        the same response. The service also handles deleting the clientToken after it expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier of the runtime environment where you want to deploy this application.
         * </p>
         * 
         * @param environmentId
         *        The identifier of the runtime environment where you want to deploy this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends M2Request.BuilderImpl implements Builder {
        private String applicationId;

        private Integer applicationVersion;

        private String clientToken;

        private String environmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            super(model);
            applicationId(model.applicationId);
            applicationVersion(model.applicationVersion);
            clientToken(model.clientToken);
            environmentId(model.environmentId);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Integer getApplicationVersion() {
            return applicationVersion;
        }

        public final void setApplicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        @Override
        public final Builder applicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
