/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutvision.model.ModelPerformance;
import software.amazon.awssdk.services.lookoutvision.model.ModelStatus;
import software.amazon.awssdk.services.lookoutvision.model.OutputConfig;
import software.amazon.awssdk.services.lookoutvision.model.OutputS3Object;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelDescription> {
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersion").getter(ModelDescription.getter(ModelDescription::modelVersion)).setter(ModelDescription.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(ModelDescription.getter(ModelDescription::modelArn)).setter(ModelDescription.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(ModelDescription.getter(ModelDescription::creationTimestamp)).setter(ModelDescription.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModelDescription.getter(ModelDescription::description)).setter(ModelDescription.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ModelDescription.getter(ModelDescription::statusAsString)).setter(ModelDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ModelDescription.getter(ModelDescription::statusMessage)).setter(ModelDescription.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<ModelPerformance> PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Performance").getter(ModelDescription.getter(ModelDescription::performance)).setter(ModelDescription.setter(Builder::performance)).constructor(ModelPerformance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Performance").build()}).build();
    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(ModelDescription.getter(ModelDescription::outputConfig)).setter(ModelDescription.setter(Builder::outputConfig)).constructor(OutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<OutputS3Object> EVALUATION_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluationManifest").getter(ModelDescription.getter(ModelDescription::evaluationManifest)).setter(ModelDescription.setter(Builder::evaluationManifest)).constructor(OutputS3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationManifest").build()}).build();
    private static final SdkField<OutputS3Object> EVALUATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluationResult").getter(ModelDescription.getter(ModelDescription::evaluationResult)).setter(ModelDescription.setter(Builder::evaluationResult)).constructor(OutputS3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationResult").build()}).build();
    private static final SdkField<Instant> EVALUATION_END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EvaluationEndTimestamp").getter(ModelDescription.getter(ModelDescription::evaluationEndTimestamp)).setter(ModelDescription.setter(Builder::evaluationEndTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationEndTimestamp").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(ModelDescription.getter(ModelDescription::kmsKeyId)).setter(ModelDescription.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_VERSION_FIELD, MODEL_ARN_FIELD, CREATION_TIMESTAMP_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, PERFORMANCE_FIELD, OUTPUT_CONFIG_FIELD, EVALUATION_MANIFEST_FIELD, EVALUATION_RESULT_FIELD, EVALUATION_END_TIMESTAMP_FIELD, KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelVersion;
    private final String modelArn;
    private final Instant creationTimestamp;
    private final String description;
    private final String status;
    private final String statusMessage;
    private final ModelPerformance performance;
    private final OutputConfig outputConfig;
    private final OutputS3Object evaluationManifest;
    private final OutputS3Object evaluationResult;
    private final Instant evaluationEndTimestamp;
    private final String kmsKeyId;

    private ModelDescription(BuilderImpl builder) {
        this.modelVersion = builder.modelVersion;
        this.modelArn = builder.modelArn;
        this.creationTimestamp = builder.creationTimestamp;
        this.description = builder.description;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.performance = builder.performance;
        this.outputConfig = builder.outputConfig;
        this.evaluationManifest = builder.evaluationManifest;
        this.evaluationResult = builder.evaluationResult;
        this.evaluationEndTimestamp = builder.evaluationEndTimestamp;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final String modelVersion() {
        return this.modelVersion;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final String description() {
        return this.description;
    }

    public final ModelStatus status() {
        return ModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final ModelPerformance performance() {
        return this.performance;
    }

    public final OutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final OutputS3Object evaluationManifest() {
        return this.evaluationManifest;
    }

    public final OutputS3Object evaluationResult() {
        return this.evaluationResult;
    }

    public final Instant evaluationEndTimestamp() {
        return this.evaluationEndTimestamp;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.performance());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationManifest());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationEndTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelDescription)) {
            return false;
        }
        ModelDescription other = (ModelDescription)obj;
        return Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.performance(), other.performance()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.evaluationManifest(), other.evaluationManifest()) && Objects.equals(this.evaluationResult(), other.evaluationResult()) && Objects.equals(this.evaluationEndTimestamp(), other.evaluationEndTimestamp()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"ModelDescription").add("ModelVersion", (Object)this.modelVersion()).add("ModelArn", (Object)this.modelArn()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("Performance", (Object)this.performance()).add("OutputConfig", (Object)this.outputConfig()).add("EvaluationManifest", (Object)this.evaluationManifest()).add("EvaluationResult", (Object)this.evaluationResult()).add("EvaluationEndTimestamp", (Object)this.evaluationEndTimestamp()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "Performance": {
                return Optional.ofNullable(clazz.cast(this.performance()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "EvaluationManifest": {
                return Optional.ofNullable(clazz.cast(this.evaluationManifest()));
            }
            case "EvaluationResult": {
                return Optional.ofNullable(clazz.cast(this.evaluationResult()));
            }
            case "EvaluationEndTimestamp": {
                return Optional.ofNullable(clazz.cast(this.evaluationEndTimestamp()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelDescription, T> g) {
        return obj -> g.apply((ModelDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelVersion;
        private String modelArn;
        private Instant creationTimestamp;
        private String description;
        private String status;
        private String statusMessage;
        private ModelPerformance performance;
        private OutputConfig outputConfig;
        private OutputS3Object evaluationManifest;
        private OutputS3Object evaluationResult;
        private Instant evaluationEndTimestamp;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelDescription model) {
            this.modelVersion(model.modelVersion);
            this.modelArn(model.modelArn);
            this.creationTimestamp(model.creationTimestamp);
            this.description(model.description);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.performance(model.performance);
            this.outputConfig(model.outputConfig);
            this.evaluationManifest(model.evaluationManifest);
            this.evaluationResult(model.evaluationResult);
            this.evaluationEndTimestamp(model.evaluationEndTimestamp);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final ModelPerformance.Builder getPerformance() {
            return this.performance != null ? this.performance.toBuilder() : null;
        }

        @Override
        public final Builder performance(ModelPerformance performance) {
            this.performance = performance;
            return this;
        }

        public final void setPerformance(ModelPerformance.BuilderImpl performance) {
            this.performance = performance != null ? performance.build() : null;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final OutputS3Object.Builder getEvaluationManifest() {
            return this.evaluationManifest != null ? this.evaluationManifest.toBuilder() : null;
        }

        @Override
        public final Builder evaluationManifest(OutputS3Object evaluationManifest) {
            this.evaluationManifest = evaluationManifest;
            return this;
        }

        public final void setEvaluationManifest(OutputS3Object.BuilderImpl evaluationManifest) {
            this.evaluationManifest = evaluationManifest != null ? evaluationManifest.build() : null;
        }

        public final OutputS3Object.Builder getEvaluationResult() {
            return this.evaluationResult != null ? this.evaluationResult.toBuilder() : null;
        }

        @Override
        public final Builder evaluationResult(OutputS3Object evaluationResult) {
            this.evaluationResult = evaluationResult;
            return this;
        }

        public final void setEvaluationResult(OutputS3Object.BuilderImpl evaluationResult) {
            this.evaluationResult = evaluationResult != null ? evaluationResult.build() : null;
        }

        public final Instant getEvaluationEndTimestamp() {
            return this.evaluationEndTimestamp;
        }

        @Override
        public final Builder evaluationEndTimestamp(Instant evaluationEndTimestamp) {
            this.evaluationEndTimestamp = evaluationEndTimestamp;
            return this;
        }

        public final void setEvaluationEndTimestamp(Instant evaluationEndTimestamp) {
            this.evaluationEndTimestamp = evaluationEndTimestamp;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public ModelDescription build() {
            return new ModelDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelDescription> {
        public Builder modelVersion(String var1);

        public Builder modelArn(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(ModelStatus var1);

        public Builder statusMessage(String var1);

        public Builder performance(ModelPerformance var1);

        default public Builder performance(Consumer<ModelPerformance.Builder> performance) {
            return this.performance((ModelPerformance)((ModelPerformance.Builder)ModelPerformance.builder().applyMutation(performance)).build());
        }

        public Builder outputConfig(OutputConfig var1);

        default public Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return this.outputConfig((OutputConfig)((OutputConfig.Builder)OutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder evaluationManifest(OutputS3Object var1);

        default public Builder evaluationManifest(Consumer<OutputS3Object.Builder> evaluationManifest) {
            return this.evaluationManifest((OutputS3Object)((OutputS3Object.Builder)OutputS3Object.builder().applyMutation(evaluationManifest)).build());
        }

        public Builder evaluationResult(OutputS3Object var1);

        default public Builder evaluationResult(Consumer<OutputS3Object.Builder> evaluationResult) {
            return this.evaluationResult((OutputS3Object)((OutputS3Object.Builder)OutputS3Object.builder().applyMutation(evaluationResult)).build());
        }

        public Builder evaluationEndTimestamp(Instant var1);

        public Builder kmsKeyId(String var1);
    }
}

