/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lookoutmetrics.DefaultLookoutMetricsBaseClientBuilder;
import software.amazon.awssdk.services.lookoutmetrics.DefaultLookoutMetricsClient;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsClient;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsClientBuilder;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsServiceClientConfiguration;
import software.amazon.awssdk.services.lookoutmetrics.endpoints.LookoutMetricsEndpointProvider;

@SdkInternalApi
final class DefaultLookoutMetricsClientBuilder
extends DefaultLookoutMetricsBaseClientBuilder<LookoutMetricsClientBuilder, LookoutMetricsClient>
implements LookoutMetricsClientBuilder {
    DefaultLookoutMetricsClientBuilder() {
    }

    @Override
    public DefaultLookoutMetricsClientBuilder endpointProvider(LookoutMetricsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LookoutMetricsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultLookoutMetricsClientBuilder.validateClientOptions(clientConfiguration);
        LookoutMetricsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultLookoutMetricsClient client = new DefaultLookoutMetricsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private LookoutMetricsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return LookoutMetricsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

