/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AggregationFunction {
    AVG("AVG"),
    SUM("SUM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AggregationFunction> VALUE_MAP;
    private final String value;

    private AggregationFunction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AggregationFunction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AggregationFunction> knownValues() {
        EnumSet<AggregationFunction> knownValues = EnumSet.allOf(AggregationFunction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AggregationFunction.class, AggregationFunction::toString);
    }
}

