/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.lookoutmetrics.model.ActivateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ActivateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.BackTestAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.BackTestAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateMetricSetRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateMetricSetResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DeactivateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DeactivateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeMetricSetRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeMetricSetResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DetectMetricSetConfigRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DetectMetricSetConfigResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetAnomalyGroupRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetAnomalyGroupResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetDataQualityMetricsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetDataQualityMetricsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetSampleDataRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetSampleDataResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.PutFeedbackRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.PutFeedbackResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.TagResourceRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.TagResourceResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.UntagResourceRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UntagResourceResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateMetricSetRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateMetricSetResponse;
import software.amazon.awssdk.services.lookoutmetrics.paginators.DescribeAnomalyDetectionExecutionsPublisher;
import software.amazon.awssdk.services.lookoutmetrics.paginators.GetFeedbackPublisher;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListAlertsPublisher;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyDetectorsPublisher;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupRelatedMetricsPublisher;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupSummariesPublisher;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupTimeSeriesPublisher;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListMetricSetsPublisher;

/**
 * Service client for accessing LookoutMetrics asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * This is the <i>Amazon Lookout for Metrics API Reference</i>. For an introduction to the service with tutorials for
 * getting started, visit <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev">Amazon Lookout for Metrics
 * Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LookoutMetricsAsyncClient extends AwsClient {
    String SERVICE_NAME = "lookoutmetrics";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "lookoutmetrics";

    /**
     * <p>
     * Activates an anomaly detector.
     * </p>
     *
     * @param activateAnomalyDetectorRequest
     * @return A Java Future containing the result of the ActivateAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ActivateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ActivateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateAnomalyDetectorResponse> activateAnomalyDetector(
            ActivateAnomalyDetectorRequest activateAnomalyDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates an anomaly detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateAnomalyDetectorRequest.Builder} avoiding
     * the need to create one manually via {@link ActivateAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param activateAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on {@link ActivateAnomalyDetectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ActivateAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ActivateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ActivateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateAnomalyDetectorResponse> activateAnomalyDetector(
            Consumer<ActivateAnomalyDetectorRequest.Builder> activateAnomalyDetectorRequest) {
        return activateAnomalyDetector(ActivateAnomalyDetectorRequest.builder().applyMutation(activateAnomalyDetectorRequest)
                .build());
    }

    /**
     * <p>
     * Runs a backtest for anomaly detection for the specified resource.
     * </p>
     *
     * @param backTestAnomalyDetectorRequest
     * @return A Java Future containing the result of the BackTestAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.BackTestAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/BackTestAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BackTestAnomalyDetectorResponse> backTestAnomalyDetector(
            BackTestAnomalyDetectorRequest backTestAnomalyDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs a backtest for anomaly detection for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BackTestAnomalyDetectorRequest.Builder} avoiding
     * the need to create one manually via {@link BackTestAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param backTestAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on {@link BackTestAnomalyDetectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BackTestAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.BackTestAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/BackTestAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BackTestAnomalyDetectorResponse> backTestAnomalyDetector(
            Consumer<BackTestAnomalyDetectorRequest.Builder> backTestAnomalyDetectorRequest) {
        return backTestAnomalyDetector(BackTestAnomalyDetectorRequest.builder().applyMutation(backTestAnomalyDetectorRequest)
                .build());
    }

    /**
     * <p>
     * Creates an alert for an anomaly detector.
     * </p>
     *
     * @param createAlertRequest
     * @return A Java Future containing the result of the CreateAlert operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ServiceQuotaExceededException The request exceeded the service's quotas. Check the service quotas and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.CreateAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAlertResponse> createAlert(CreateAlertRequest createAlertRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an alert for an anomaly detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAlertRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAlertRequest#builder()}
     * </p>
     *
     * @param createAlertRequest
     *        A {@link Consumer} that will call methods on {@link CreateAlertRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAlert operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ServiceQuotaExceededException The request exceeded the service's quotas. Check the service quotas and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.CreateAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAlertResponse> createAlert(Consumer<CreateAlertRequest.Builder> createAlertRequest) {
        return createAlert(CreateAlertRequest.builder().applyMutation(createAlertRequest).build());
    }

    /**
     * <p>
     * Creates an anomaly detector.
     * </p>
     *
     * @param createAnomalyDetectorRequest
     * @return A Java Future containing the result of the CreateAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ServiceQuotaExceededException The request exceeded the service's quotas. Check the service quotas and
     *         try again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.CreateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAnomalyDetectorResponse> createAnomalyDetector(
            CreateAnomalyDetectorRequest createAnomalyDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an anomaly detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAnomalyDetectorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param createAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on {@link CreateAnomalyDetectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ServiceQuotaExceededException The request exceeded the service's quotas. Check the service quotas and
     *         try again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.CreateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAnomalyDetectorResponse> createAnomalyDetector(
            Consumer<CreateAnomalyDetectorRequest.Builder> createAnomalyDetectorRequest) {
        return createAnomalyDetector(CreateAnomalyDetectorRequest.builder().applyMutation(createAnomalyDetectorRequest).build());
    }

    /**
     * <p>
     * Creates a dataset.
     * </p>
     *
     * @param createMetricSetRequest
     * @return A Java Future containing the result of the CreateMetricSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ServiceQuotaExceededException The request exceeded the service's quotas. Check the service quotas and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.CreateMetricSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateMetricSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMetricSetResponse> createMetricSet(CreateMetricSetRequest createMetricSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMetricSetRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMetricSetRequest#builder()}
     * </p>
     *
     * @param createMetricSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateMetricSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateMetricSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ServiceQuotaExceededException The request exceeded the service's quotas. Check the service quotas and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.CreateMetricSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateMetricSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMetricSetResponse> createMetricSet(
            Consumer<CreateMetricSetRequest.Builder> createMetricSetRequest) {
        return createMetricSet(CreateMetricSetRequest.builder().applyMutation(createMetricSetRequest).build());
    }

    /**
     * <p>
     * Deactivates an anomaly detector.
     * </p>
     *
     * @param deactivateAnomalyDetectorRequest
     * @return A Java Future containing the result of the DeactivateAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DeactivateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeactivateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivateAnomalyDetectorResponse> deactivateAnomalyDetector(
            DeactivateAnomalyDetectorRequest deactivateAnomalyDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates an anomaly detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateAnomalyDetectorRequest.Builder} avoiding
     * the need to create one manually via {@link DeactivateAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param deactivateAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on {@link DeactivateAnomalyDetectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeactivateAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DeactivateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeactivateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivateAnomalyDetectorResponse> deactivateAnomalyDetector(
            Consumer<DeactivateAnomalyDetectorRequest.Builder> deactivateAnomalyDetectorRequest) {
        return deactivateAnomalyDetector(DeactivateAnomalyDetectorRequest.builder()
                .applyMutation(deactivateAnomalyDetectorRequest).build());
    }

    /**
     * <p>
     * Deletes an alert.
     * </p>
     *
     * @param deleteAlertRequest
     * @return A Java Future containing the result of the DeleteAlert operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DeleteAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeleteAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAlertResponse> deleteAlert(DeleteAlertRequest deleteAlertRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an alert.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAlertRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAlertRequest#builder()}
     * </p>
     *
     * @param deleteAlertRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAlertRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAlert operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DeleteAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeleteAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAlertResponse> deleteAlert(Consumer<DeleteAlertRequest.Builder> deleteAlertRequest) {
        return deleteAlert(DeleteAlertRequest.builder().applyMutation(deleteAlertRequest).build());
    }

    /**
     * <p>
     * Deletes a detector. Deleting an anomaly detector will delete all of its corresponding resources including any
     * configured datasets and alerts.
     * </p>
     *
     * @param deleteAnomalyDetectorRequest
     * @return A Java Future containing the result of the DeleteAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DeleteAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeleteAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAnomalyDetectorResponse> deleteAnomalyDetector(
            DeleteAnomalyDetectorRequest deleteAnomalyDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a detector. Deleting an anomaly detector will delete all of its corresponding resources including any
     * configured datasets and alerts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAnomalyDetectorRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param deleteAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAnomalyDetectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DeleteAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeleteAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAnomalyDetectorResponse> deleteAnomalyDetector(
            Consumer<DeleteAnomalyDetectorRequest.Builder> deleteAnomalyDetectorRequest) {
        return deleteAnomalyDetector(DeleteAnomalyDetectorRequest.builder().applyMutation(deleteAnomalyDetectorRequest).build());
    }

    /**
     * <p>
     * Describes an alert.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param describeAlertRequest
     * @return A Java Future containing the result of the DescribeAlert operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DescribeAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAlertResponse> describeAlert(DescribeAlertRequest describeAlertRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an alert.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAlertRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAlertRequest#builder()}
     * </p>
     *
     * @param describeAlertRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAlertRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeAlert operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DescribeAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAlertResponse> describeAlert(Consumer<DescribeAlertRequest.Builder> describeAlertRequest) {
        return describeAlert(DescribeAlertRequest.builder().applyMutation(describeAlertRequest).build());
    }

    /**
     * <p>
     * Returns information about the status of the specified anomaly detection jobs.
     * </p>
     *
     * @param describeAnomalyDetectionExecutionsRequest
     * @return A Java Future containing the result of the DescribeAnomalyDetectionExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DescribeAnomalyDetectionExecutions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetectionExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAnomalyDetectionExecutionsResponse> describeAnomalyDetectionExecutions(
            DescribeAnomalyDetectionExecutionsRequest describeAnomalyDetectionExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the status of the specified anomaly detection jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAnomalyDetectionExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAnomalyDetectionExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAnomalyDetectionExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAnomalyDetectionExecutionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAnomalyDetectionExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DescribeAnomalyDetectionExecutions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetectionExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAnomalyDetectionExecutionsResponse> describeAnomalyDetectionExecutions(
            Consumer<DescribeAnomalyDetectionExecutionsRequest.Builder> describeAnomalyDetectionExecutionsRequest) {
        return describeAnomalyDetectionExecutions(DescribeAnomalyDetectionExecutionsRequest.builder()
                .applyMutation(describeAnomalyDetectionExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns information about the status of the specified anomaly detection jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAnomalyDetectionExecutions(software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.DescribeAnomalyDetectionExecutionsPublisher publisher = client.describeAnomalyDetectionExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.DescribeAnomalyDetectionExecutionsPublisher publisher = client.describeAnomalyDetectionExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAnomalyDetectionExecutions(software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAnomalyDetectionExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DescribeAnomalyDetectionExecutions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetectionExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAnomalyDetectionExecutionsPublisher describeAnomalyDetectionExecutionsPaginator(
            DescribeAnomalyDetectionExecutionsRequest describeAnomalyDetectionExecutionsRequest) {
        return new DescribeAnomalyDetectionExecutionsPublisher(this, describeAnomalyDetectionExecutionsRequest);
    }

    /**
     * <p>
     * Returns information about the status of the specified anomaly detection jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAnomalyDetectionExecutions(software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.DescribeAnomalyDetectionExecutionsPublisher publisher = client.describeAnomalyDetectionExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.DescribeAnomalyDetectionExecutionsPublisher publisher = client.describeAnomalyDetectionExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAnomalyDetectionExecutions(software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAnomalyDetectionExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAnomalyDetectionExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAnomalyDetectionExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAnomalyDetectionExecutionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DescribeAnomalyDetectionExecutions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetectionExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAnomalyDetectionExecutionsPublisher describeAnomalyDetectionExecutionsPaginator(
            Consumer<DescribeAnomalyDetectionExecutionsRequest.Builder> describeAnomalyDetectionExecutionsRequest) {
        return describeAnomalyDetectionExecutionsPaginator(DescribeAnomalyDetectionExecutionsRequest.builder()
                .applyMutation(describeAnomalyDetectionExecutionsRequest).build());
    }

    /**
     * <p>
     * Describes a detector.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param describeAnomalyDetectorRequest
     * @return A Java Future containing the result of the DescribeAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DescribeAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAnomalyDetectorResponse> describeAnomalyDetector(
            DescribeAnomalyDetectorRequest describeAnomalyDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a detector.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAnomalyDetectorRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param describeAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAnomalyDetectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DescribeAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAnomalyDetectorResponse> describeAnomalyDetector(
            Consumer<DescribeAnomalyDetectorRequest.Builder> describeAnomalyDetectorRequest) {
        return describeAnomalyDetector(DescribeAnomalyDetectorRequest.builder().applyMutation(describeAnomalyDetectorRequest)
                .build());
    }

    /**
     * <p>
     * Describes a dataset.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param describeMetricSetRequest
     * @return A Java Future containing the result of the DescribeMetricSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DescribeMetricSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeMetricSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMetricSetResponse> describeMetricSet(DescribeMetricSetRequest describeMetricSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a dataset.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetricSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeMetricSetRequest#builder()}
     * </p>
     *
     * @param describeMetricSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMetricSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeMetricSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DescribeMetricSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeMetricSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMetricSetResponse> describeMetricSet(
            Consumer<DescribeMetricSetRequest.Builder> describeMetricSetRequest) {
        return describeMetricSet(DescribeMetricSetRequest.builder().applyMutation(describeMetricSetRequest).build());
    }

    /**
     * <p>
     * Detects an Amazon S3 dataset's file format, interval, and offset.
     * </p>
     *
     * @param detectMetricSetConfigRequest
     * @return A Java Future containing the result of the DetectMetricSetConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DetectMetricSetConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DetectMetricSetConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectMetricSetConfigResponse> detectMetricSetConfig(
            DetectMetricSetConfigRequest detectMetricSetConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects an Amazon S3 dataset's file format, interval, and offset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectMetricSetConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DetectMetricSetConfigRequest#builder()}
     * </p>
     *
     * @param detectMetricSetConfigRequest
     *        A {@link Consumer} that will call methods on {@link DetectMetricSetConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DetectMetricSetConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.DetectMetricSetConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DetectMetricSetConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectMetricSetConfigResponse> detectMetricSetConfig(
            Consumer<DetectMetricSetConfigRequest.Builder> detectMetricSetConfigRequest) {
        return detectMetricSetConfig(DetectMetricSetConfigRequest.builder().applyMutation(detectMetricSetConfigRequest).build());
    }

    /**
     * <p>
     * Returns details about a group of anomalous metrics.
     * </p>
     *
     * @param getAnomalyGroupRequest
     * @return A Java Future containing the result of the GetAnomalyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.GetAnomalyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetAnomalyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAnomalyGroupResponse> getAnomalyGroup(GetAnomalyGroupRequest getAnomalyGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a group of anomalous metrics.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnomalyGroupRequest.Builder} avoiding the need
     * to create one manually via {@link GetAnomalyGroupRequest#builder()}
     * </p>
     *
     * @param getAnomalyGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetAnomalyGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAnomalyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.GetAnomalyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetAnomalyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAnomalyGroupResponse> getAnomalyGroup(
            Consumer<GetAnomalyGroupRequest.Builder> getAnomalyGroupRequest) {
        return getAnomalyGroup(GetAnomalyGroupRequest.builder().applyMutation(getAnomalyGroupRequest).build());
    }

    /**
     * <p>
     * Returns details about the requested data quality metrics.
     * </p>
     *
     * @param getDataQualityMetricsRequest
     * @return A Java Future containing the result of the GetDataQualityMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.GetDataQualityMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetDataQualityMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataQualityMetricsResponse> getDataQualityMetrics(
            GetDataQualityMetricsRequest getDataQualityMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the requested data quality metrics.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataQualityMetricsRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataQualityMetricsRequest#builder()}
     * </p>
     *
     * @param getDataQualityMetricsRequest
     *        A {@link Consumer} that will call methods on {@link GetDataQualityMetricsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDataQualityMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.GetDataQualityMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetDataQualityMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataQualityMetricsResponse> getDataQualityMetrics(
            Consumer<GetDataQualityMetricsRequest.Builder> getDataQualityMetricsRequest) {
        return getDataQualityMetrics(GetDataQualityMetricsRequest.builder().applyMutation(getDataQualityMetricsRequest).build());
    }

    /**
     * <p>
     * Get feedback for an anomaly group.
     * </p>
     *
     * @param getFeedbackRequest
     * @return A Java Future containing the result of the GetFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.GetFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetFeedbackResponse> getFeedback(GetFeedbackRequest getFeedbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get feedback for an anomaly group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link GetFeedbackRequest#builder()}
     * </p>
     *
     * @param getFeedbackRequest
     *        A {@link Consumer} that will call methods on {@link GetFeedbackRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.GetFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetFeedbackResponse> getFeedback(Consumer<GetFeedbackRequest.Builder> getFeedbackRequest) {
        return getFeedback(GetFeedbackRequest.builder().applyMutation(getFeedbackRequest).build());
    }

    /**
     * <p>
     * Get feedback for an anomaly group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getFeedback(software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.GetFeedbackPublisher publisher = client.getFeedbackPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.GetFeedbackPublisher publisher = client.getFeedbackPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFeedback(software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest)} operation.</b>
     * </p>
     *
     * @param getFeedbackRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.GetFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFeedbackPublisher getFeedbackPaginator(GetFeedbackRequest getFeedbackRequest) {
        return new GetFeedbackPublisher(this, getFeedbackRequest);
    }

    /**
     * <p>
     * Get feedback for an anomaly group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getFeedback(software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.GetFeedbackPublisher publisher = client.getFeedbackPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.GetFeedbackPublisher publisher = client.getFeedbackPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFeedback(software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link GetFeedbackRequest#builder()}
     * </p>
     *
     * @param getFeedbackRequest
     *        A {@link Consumer} that will call methods on {@link GetFeedbackRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.GetFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFeedbackPublisher getFeedbackPaginator(Consumer<GetFeedbackRequest.Builder> getFeedbackRequest) {
        return getFeedbackPaginator(GetFeedbackRequest.builder().applyMutation(getFeedbackRequest).build());
    }

    /**
     * <p>
     * Returns a selection of sample records from an Amazon S3 datasource.
     * </p>
     *
     * @param getSampleDataRequest
     * @return A Java Future containing the result of the GetSampleData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.GetSampleData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetSampleData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSampleDataResponse> getSampleData(GetSampleDataRequest getSampleDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a selection of sample records from an Amazon S3 datasource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSampleDataRequest.Builder} avoiding the need to
     * create one manually via {@link GetSampleDataRequest#builder()}
     * </p>
     *
     * @param getSampleDataRequest
     *        A {@link Consumer} that will call methods on {@link GetSampleDataRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSampleData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.GetSampleData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetSampleData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSampleDataResponse> getSampleData(Consumer<GetSampleDataRequest.Builder> getSampleDataRequest) {
        return getSampleData(GetSampleDataRequest.builder().applyMutation(getSampleDataRequest).build());
    }

    /**
     * <p>
     * Lists the alerts attached to a detector.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param listAlertsRequest
     * @return A Java Future containing the result of the ListAlerts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAlertsResponse> listAlerts(ListAlertsRequest listAlertsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the alerts attached to a detector.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlertsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAlertsRequest#builder()}
     * </p>
     *
     * @param listAlertsRequest
     *        A {@link Consumer} that will call methods on {@link ListAlertsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAlerts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAlertsResponse> listAlerts(Consumer<ListAlertsRequest.Builder> listAlertsRequest) {
        return listAlerts(ListAlertsRequest.builder().applyMutation(listAlertsRequest).build());
    }

    /**
     * <p>
     * Lists the alerts attached to a detector.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAlerts(software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAlertsPublisher publisher = client.listAlertsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAlertsPublisher publisher = client.listAlertsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlerts(software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest)} operation.</b>
     * </p>
     *
     * @param listAlertsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlertsPublisher listAlertsPaginator(ListAlertsRequest listAlertsRequest) {
        return new ListAlertsPublisher(this, listAlertsRequest);
    }

    /**
     * <p>
     * Lists the alerts attached to a detector.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAlerts(software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAlertsPublisher publisher = client.listAlertsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAlertsPublisher publisher = client.listAlertsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlerts(software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlertsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAlertsRequest#builder()}
     * </p>
     *
     * @param listAlertsRequest
     *        A {@link Consumer} that will call methods on {@link ListAlertsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlertsPublisher listAlertsPaginator(Consumer<ListAlertsRequest.Builder> listAlertsRequest) {
        return listAlertsPaginator(ListAlertsRequest.builder().applyMutation(listAlertsRequest).build());
    }

    /**
     * <p>
     * Lists the detectors in the current AWS Region.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param listAnomalyDetectorsRequest
     * @return A Java Future containing the result of the ListAnomalyDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyDetectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnomalyDetectorsResponse> listAnomalyDetectors(
            ListAnomalyDetectorsRequest listAnomalyDetectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the detectors in the current AWS Region.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyDetectorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnomalyDetectorsRequest#builder()}
     * </p>
     *
     * @param listAnomalyDetectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListAnomalyDetectorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAnomalyDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyDetectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnomalyDetectorsResponse> listAnomalyDetectors(
            Consumer<ListAnomalyDetectorsRequest.Builder> listAnomalyDetectorsRequest) {
        return listAnomalyDetectors(ListAnomalyDetectorsRequest.builder().applyMutation(listAnomalyDetectorsRequest).build());
    }

    /**
     * <p>
     * Lists the detectors in the current AWS Region.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnomalyDetectors(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyDetectorsPublisher publisher = client.listAnomalyDetectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyDetectorsPublisher publisher = client.listAnomalyDetectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyDetectors(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnomalyDetectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyDetectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyDetectorsPublisher listAnomalyDetectorsPaginator(ListAnomalyDetectorsRequest listAnomalyDetectorsRequest) {
        return new ListAnomalyDetectorsPublisher(this, listAnomalyDetectorsRequest);
    }

    /**
     * <p>
     * Lists the detectors in the current AWS Region.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnomalyDetectors(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyDetectorsPublisher publisher = client.listAnomalyDetectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyDetectorsPublisher publisher = client.listAnomalyDetectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyDetectors(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyDetectorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnomalyDetectorsRequest#builder()}
     * </p>
     *
     * @param listAnomalyDetectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListAnomalyDetectorsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyDetectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyDetectorsPublisher listAnomalyDetectorsPaginator(
            Consumer<ListAnomalyDetectorsRequest.Builder> listAnomalyDetectorsRequest) {
        return listAnomalyDetectorsPaginator(ListAnomalyDetectorsRequest.builder().applyMutation(listAnomalyDetectorsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of measures that are potential causes or effects of an anomaly group.
     * </p>
     *
     * @param listAnomalyGroupRelatedMetricsRequest
     * @return A Java Future containing the result of the ListAnomalyGroupRelatedMetrics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyGroupRelatedMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupRelatedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnomalyGroupRelatedMetricsResponse> listAnomalyGroupRelatedMetrics(
            ListAnomalyGroupRelatedMetricsRequest listAnomalyGroupRelatedMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of measures that are potential causes or effects of an anomaly group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyGroupRelatedMetricsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAnomalyGroupRelatedMetricsRequest#builder()}
     * </p>
     *
     * @param listAnomalyGroupRelatedMetricsRequest
     *        A {@link Consumer} that will call methods on {@link ListAnomalyGroupRelatedMetricsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAnomalyGroupRelatedMetrics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyGroupRelatedMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupRelatedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnomalyGroupRelatedMetricsResponse> listAnomalyGroupRelatedMetrics(
            Consumer<ListAnomalyGroupRelatedMetricsRequest.Builder> listAnomalyGroupRelatedMetricsRequest) {
        return listAnomalyGroupRelatedMetrics(ListAnomalyGroupRelatedMetricsRequest.builder()
                .applyMutation(listAnomalyGroupRelatedMetricsRequest).build());
    }

    /**
     * <p>
     * Returns a list of measures that are potential causes or effects of an anomaly group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnomalyGroupRelatedMetrics(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupRelatedMetricsPublisher publisher = client.listAnomalyGroupRelatedMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupRelatedMetricsPublisher publisher = client.listAnomalyGroupRelatedMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyGroupRelatedMetrics(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnomalyGroupRelatedMetricsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyGroupRelatedMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupRelatedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupRelatedMetricsPublisher listAnomalyGroupRelatedMetricsPaginator(
            ListAnomalyGroupRelatedMetricsRequest listAnomalyGroupRelatedMetricsRequest) {
        return new ListAnomalyGroupRelatedMetricsPublisher(this, listAnomalyGroupRelatedMetricsRequest);
    }

    /**
     * <p>
     * Returns a list of measures that are potential causes or effects of an anomaly group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnomalyGroupRelatedMetrics(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupRelatedMetricsPublisher publisher = client.listAnomalyGroupRelatedMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupRelatedMetricsPublisher publisher = client.listAnomalyGroupRelatedMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyGroupRelatedMetrics(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyGroupRelatedMetricsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAnomalyGroupRelatedMetricsRequest#builder()}
     * </p>
     *
     * @param listAnomalyGroupRelatedMetricsRequest
     *        A {@link Consumer} that will call methods on {@link ListAnomalyGroupRelatedMetricsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyGroupRelatedMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupRelatedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupRelatedMetricsPublisher listAnomalyGroupRelatedMetricsPaginator(
            Consumer<ListAnomalyGroupRelatedMetricsRequest.Builder> listAnomalyGroupRelatedMetricsRequest) {
        return listAnomalyGroupRelatedMetricsPaginator(ListAnomalyGroupRelatedMetricsRequest.builder()
                .applyMutation(listAnomalyGroupRelatedMetricsRequest).build());
    }

    /**
     * <p>
     * Returns a list of anomaly groups.
     * </p>
     *
     * @param listAnomalyGroupSummariesRequest
     * @return A Java Future containing the result of the ListAnomalyGroupSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyGroupSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnomalyGroupSummariesResponse> listAnomalyGroupSummaries(
            ListAnomalyGroupSummariesRequest listAnomalyGroupSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of anomaly groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyGroupSummariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnomalyGroupSummariesRequest#builder()}
     * </p>
     *
     * @param listAnomalyGroupSummariesRequest
     *        A {@link Consumer} that will call methods on {@link ListAnomalyGroupSummariesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAnomalyGroupSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyGroupSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnomalyGroupSummariesResponse> listAnomalyGroupSummaries(
            Consumer<ListAnomalyGroupSummariesRequest.Builder> listAnomalyGroupSummariesRequest) {
        return listAnomalyGroupSummaries(ListAnomalyGroupSummariesRequest.builder()
                .applyMutation(listAnomalyGroupSummariesRequest).build());
    }

    /**
     * <p>
     * Returns a list of anomaly groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnomalyGroupSummaries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupSummariesPublisher publisher = client.listAnomalyGroupSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupSummariesPublisher publisher = client.listAnomalyGroupSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyGroupSummaries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnomalyGroupSummariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyGroupSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupSummariesPublisher listAnomalyGroupSummariesPaginator(
            ListAnomalyGroupSummariesRequest listAnomalyGroupSummariesRequest) {
        return new ListAnomalyGroupSummariesPublisher(this, listAnomalyGroupSummariesRequest);
    }

    /**
     * <p>
     * Returns a list of anomaly groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnomalyGroupSummaries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupSummariesPublisher publisher = client.listAnomalyGroupSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupSummariesPublisher publisher = client.listAnomalyGroupSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyGroupSummaries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyGroupSummariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnomalyGroupSummariesRequest#builder()}
     * </p>
     *
     * @param listAnomalyGroupSummariesRequest
     *        A {@link Consumer} that will call methods on {@link ListAnomalyGroupSummariesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyGroupSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupSummariesPublisher listAnomalyGroupSummariesPaginator(
            Consumer<ListAnomalyGroupSummariesRequest.Builder> listAnomalyGroupSummariesRequest) {
        return listAnomalyGroupSummariesPaginator(ListAnomalyGroupSummariesRequest.builder()
                .applyMutation(listAnomalyGroupSummariesRequest).build());
    }

    /**
     * <p>
     * Gets a list of anomalous metrics for a measure in an anomaly group.
     * </p>
     *
     * @param listAnomalyGroupTimeSeriesRequest
     * @return A Java Future containing the result of the ListAnomalyGroupTimeSeries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyGroupTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupTimeSeries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnomalyGroupTimeSeriesResponse> listAnomalyGroupTimeSeries(
            ListAnomalyGroupTimeSeriesRequest listAnomalyGroupTimeSeriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of anomalous metrics for a measure in an anomaly group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyGroupTimeSeriesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnomalyGroupTimeSeriesRequest#builder()}
     * </p>
     *
     * @param listAnomalyGroupTimeSeriesRequest
     *        A {@link Consumer} that will call methods on {@link ListAnomalyGroupTimeSeriesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAnomalyGroupTimeSeries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyGroupTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupTimeSeries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnomalyGroupTimeSeriesResponse> listAnomalyGroupTimeSeries(
            Consumer<ListAnomalyGroupTimeSeriesRequest.Builder> listAnomalyGroupTimeSeriesRequest) {
        return listAnomalyGroupTimeSeries(ListAnomalyGroupTimeSeriesRequest.builder()
                .applyMutation(listAnomalyGroupTimeSeriesRequest).build());
    }

    /**
     * <p>
     * Gets a list of anomalous metrics for a measure in an anomaly group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnomalyGroupTimeSeries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupTimeSeriesPublisher publisher = client.listAnomalyGroupTimeSeriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupTimeSeriesPublisher publisher = client.listAnomalyGroupTimeSeriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyGroupTimeSeries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnomalyGroupTimeSeriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyGroupTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupTimeSeries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupTimeSeriesPublisher listAnomalyGroupTimeSeriesPaginator(
            ListAnomalyGroupTimeSeriesRequest listAnomalyGroupTimeSeriesRequest) {
        return new ListAnomalyGroupTimeSeriesPublisher(this, listAnomalyGroupTimeSeriesRequest);
    }

    /**
     * <p>
     * Gets a list of anomalous metrics for a measure in an anomaly group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnomalyGroupTimeSeries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupTimeSeriesPublisher publisher = client.listAnomalyGroupTimeSeriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupTimeSeriesPublisher publisher = client.listAnomalyGroupTimeSeriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyGroupTimeSeries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyGroupTimeSeriesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnomalyGroupTimeSeriesRequest#builder()}
     * </p>
     *
     * @param listAnomalyGroupTimeSeriesRequest
     *        A {@link Consumer} that will call methods on {@link ListAnomalyGroupTimeSeriesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListAnomalyGroupTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupTimeSeries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupTimeSeriesPublisher listAnomalyGroupTimeSeriesPaginator(
            Consumer<ListAnomalyGroupTimeSeriesRequest.Builder> listAnomalyGroupTimeSeriesRequest) {
        return listAnomalyGroupTimeSeriesPaginator(ListAnomalyGroupTimeSeriesRequest.builder()
                .applyMutation(listAnomalyGroupTimeSeriesRequest).build());
    }

    /**
     * <p>
     * Lists the datasets in the current AWS Region.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param listMetricSetsRequest
     * @return A Java Future containing the result of the ListMetricSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListMetricSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListMetricSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListMetricSetsResponse> listMetricSets(ListMetricSetsRequest listMetricSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the datasets in the current AWS Region.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMetricSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMetricSetsRequest#builder()}
     * </p>
     *
     * @param listMetricSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListMetricSetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMetricSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListMetricSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListMetricSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListMetricSetsResponse> listMetricSets(Consumer<ListMetricSetsRequest.Builder> listMetricSetsRequest) {
        return listMetricSets(ListMetricSetsRequest.builder().applyMutation(listMetricSetsRequest).build());
    }

    /**
     * <p>
     * Lists the datasets in the current AWS Region.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMetricSets(software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListMetricSetsPublisher publisher = client.listMetricSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListMetricSetsPublisher publisher = client.listMetricSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMetricSets(software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMetricSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListMetricSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListMetricSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMetricSetsPublisher listMetricSetsPaginator(ListMetricSetsRequest listMetricSetsRequest) {
        return new ListMetricSetsPublisher(this, listMetricSetsRequest);
    }

    /**
     * <p>
     * Lists the datasets in the current AWS Region.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMetricSets(software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListMetricSetsPublisher publisher = client.listMetricSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListMetricSetsPublisher publisher = client.listMetricSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMetricSets(software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMetricSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMetricSetsRequest#builder()}
     * </p>
     *
     * @param listMetricSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListMetricSetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListMetricSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListMetricSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMetricSetsPublisher listMetricSetsPaginator(Consumer<ListMetricSetsRequest.Builder> listMetricSetsRequest) {
        return listMetricSetsPaginator(ListMetricSetsRequest.builder().applyMutation(listMetricSetsRequest).build());
    }

    /**
     * <p>
     * Gets a list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> for a
     * detector, dataset, or alert.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> for a
     * detector, dataset, or alert.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Add feedback for an anomalous metric.
     * </p>
     *
     * @param putFeedbackRequest
     * @return A Java Future containing the result of the PutFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/PutFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutFeedbackResponse> putFeedback(PutFeedbackRequest putFeedbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add feedback for an anomalous metric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link PutFeedbackRequest#builder()}
     * </p>
     *
     * @param putFeedbackRequest
     *        A {@link Consumer} that will call methods on {@link PutFeedbackRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/PutFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutFeedbackResponse> putFeedback(Consumer<PutFeedbackRequest.Builder> putFeedbackRequest) {
        return putFeedback(PutFeedbackRequest.builder().applyMutation(putFeedbackRequest).build());
    }

    /**
     * <p>
     * Adds <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to a detector,
     * dataset, or alert.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to a detector,
     * dataset, or alert.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> from a
     * detector, dataset, or alert.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> from a
     * detector, dataset, or alert.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Make changes to an existing alert.
     * </p>
     *
     * @param updateAlertRequest
     * @return A Java Future containing the result of the UpdateAlert operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.UpdateAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAlertResponse> updateAlert(UpdateAlertRequest updateAlertRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Make changes to an existing alert.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAlertRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAlertRequest#builder()}
     * </p>
     *
     * @param updateAlertRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAlertRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateAlert operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.UpdateAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAlertResponse> updateAlert(Consumer<UpdateAlertRequest.Builder> updateAlertRequest) {
        return updateAlert(UpdateAlertRequest.builder().applyMutation(updateAlertRequest).build());
    }

    /**
     * <p>
     * Updates a detector. After activation, you can only change a detector's ingestion delay and description.
     * </p>
     *
     * @param updateAnomalyDetectorRequest
     * @return A Java Future containing the result of the UpdateAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.UpdateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAnomalyDetectorResponse> updateAnomalyDetector(
            UpdateAnomalyDetectorRequest updateAnomalyDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a detector. After activation, you can only change a detector's ingestion delay and description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAnomalyDetectorRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param updateAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAnomalyDetectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.UpdateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAnomalyDetectorResponse> updateAnomalyDetector(
            Consumer<UpdateAnomalyDetectorRequest.Builder> updateAnomalyDetectorRequest) {
        return updateAnomalyDetector(UpdateAnomalyDetectorRequest.builder().applyMutation(updateAnomalyDetectorRequest).build());
    }

    /**
     * <p>
     * Updates a dataset.
     * </p>
     *
     * @param updateMetricSetRequest
     * @return A Java Future containing the result of the UpdateMetricSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>ServiceQuotaExceededException The request exceeded the service's quotas. Check the service quotas and
     *         try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.UpdateMetricSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateMetricSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMetricSetResponse> updateMetricSet(UpdateMetricSetRequest updateMetricSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMetricSetRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateMetricSetRequest#builder()}
     * </p>
     *
     * @param updateMetricSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMetricSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateMetricSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the ARN of the resource and
     *         try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the AWS service. Check
     *         your input values and try again.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>TooManyRequestsException The request was denied due to too many requests being submitted at the same
     *         time.</li>
     *         <li>ServiceQuotaExceededException The request exceeded the service's quotas. Check the service quotas and
     *         try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LookoutMetricsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LookoutMetricsAsyncClient.UpdateMetricSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateMetricSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMetricSetResponse> updateMetricSet(
            Consumer<UpdateMetricSetRequest.Builder> updateMetricSetRequest) {
        return updateMetricSet(UpdateMetricSetRequest.builder().applyMutation(updateMetricSetRequest).build());
    }

    @Override
    default LookoutMetricsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link LookoutMetricsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LookoutMetricsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LookoutMetricsAsyncClient}.
     */
    static LookoutMetricsAsyncClientBuilder builder() {
        return new DefaultLookoutMetricsAsyncClientBuilder();
    }
}
