/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutequipment.model.FaultCodesCopier;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLabelGroupResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, DescribeLabelGroupResponse> {
    private static final SdkField<String> LABEL_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelGroupName").getter(DescribeLabelGroupResponse.getter(DescribeLabelGroupResponse::labelGroupName)).setter(DescribeLabelGroupResponse.setter(Builder::labelGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupName").build()}).build();
    private static final SdkField<String> LABEL_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelGroupArn").getter(DescribeLabelGroupResponse.getter(DescribeLabelGroupResponse::labelGroupArn)).setter(DescribeLabelGroupResponse.setter(Builder::labelGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupArn").build()}).build();
    private static final SdkField<List<String>> FAULT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FaultCodes").getter(DescribeLabelGroupResponse.getter(DescribeLabelGroupResponse::faultCodes)).setter(DescribeLabelGroupResponse.setter(Builder::faultCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DescribeLabelGroupResponse.getter(DescribeLabelGroupResponse::createdAt)).setter(DescribeLabelGroupResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(DescribeLabelGroupResponse.getter(DescribeLabelGroupResponse::updatedAt)).setter(DescribeLabelGroupResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_GROUP_NAME_FIELD, LABEL_GROUP_ARN_FIELD, FAULT_CODES_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private final String labelGroupName;
    private final String labelGroupArn;
    private final List<String> faultCodes;
    private final Instant createdAt;
    private final Instant updatedAt;

    private DescribeLabelGroupResponse(BuilderImpl builder) {
        super(builder);
        this.labelGroupName = builder.labelGroupName;
        this.labelGroupArn = builder.labelGroupArn;
        this.faultCodes = builder.faultCodes;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String labelGroupName() {
        return this.labelGroupName;
    }

    public final String labelGroupArn() {
        return this.labelGroupArn;
    }

    public final boolean hasFaultCodes() {
        return this.faultCodes != null && !(this.faultCodes instanceof SdkAutoConstructList);
    }

    public final List<String> faultCodes() {
        return this.faultCodes;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.labelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFaultCodes() ? this.faultCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLabelGroupResponse)) {
            return false;
        }
        DescribeLabelGroupResponse other = (DescribeLabelGroupResponse)((Object)obj);
        return Objects.equals(this.labelGroupName(), other.labelGroupName()) && Objects.equals(this.labelGroupArn(), other.labelGroupArn()) && this.hasFaultCodes() == other.hasFaultCodes() && Objects.equals(this.faultCodes(), other.faultCodes()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLabelGroupResponse").add("LabelGroupName", (Object)this.labelGroupName()).add("LabelGroupArn", (Object)this.labelGroupArn()).add("FaultCodes", this.hasFaultCodes() ? this.faultCodes() : null).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelGroupName": {
                return Optional.ofNullable(clazz.cast(this.labelGroupName()));
            }
            case "LabelGroupArn": {
                return Optional.ofNullable(clazz.cast(this.labelGroupArn()));
            }
            case "FaultCodes": {
                return Optional.ofNullable(clazz.cast(this.faultCodes()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLabelGroupResponse, T> g) {
        return obj -> g.apply((DescribeLabelGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String labelGroupName;
        private String labelGroupArn;
        private List<String> faultCodes = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLabelGroupResponse model) {
            super(model);
            this.labelGroupName(model.labelGroupName);
            this.labelGroupArn(model.labelGroupArn);
            this.faultCodes(model.faultCodes);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getLabelGroupName() {
            return this.labelGroupName;
        }

        public final void setLabelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
        }

        @Override
        public final Builder labelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
            return this;
        }

        public final String getLabelGroupArn() {
            return this.labelGroupArn;
        }

        public final void setLabelGroupArn(String labelGroupArn) {
            this.labelGroupArn = labelGroupArn;
        }

        @Override
        public final Builder labelGroupArn(String labelGroupArn) {
            this.labelGroupArn = labelGroupArn;
            return this;
        }

        public final Collection<String> getFaultCodes() {
            if (this.faultCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.faultCodes;
        }

        public final void setFaultCodes(Collection<String> faultCodes) {
            this.faultCodes = FaultCodesCopier.copy(faultCodes);
        }

        @Override
        public final Builder faultCodes(Collection<String> faultCodes) {
            this.faultCodes = FaultCodesCopier.copy(faultCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faultCodes(String ... faultCodes) {
            this.faultCodes(Arrays.asList(faultCodes));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public DescribeLabelGroupResponse build() {
            return new DescribeLabelGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLabelGroupResponse> {
        public Builder labelGroupName(String var1);

        public Builder labelGroupArn(String var1);

        public Builder faultCodes(Collection<String> var1);

        public Builder faultCodes(String ... var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

