/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateModelRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<UpdateModelRequest.Builder, UpdateModelRequest> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(UpdateModelRequest::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<LabelsInputConfiguration> LABELS_INPUT_CONFIGURATION_FIELD = SdkField
            .<LabelsInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("LabelsInputConfiguration")
            .getter(getter(UpdateModelRequest::labelsInputConfiguration)).setter(setter(Builder::labelsInputConfiguration))
            .constructor(LabelsInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelsInputConfiguration").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateModelRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            LABELS_INPUT_CONFIGURATION_FIELD, ROLE_ARN_FIELD));

    private final String modelName;

    private final LabelsInputConfiguration labelsInputConfiguration;

    private final String roleArn;

    private UpdateModelRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.labelsInputConfiguration = builder.labelsInputConfiguration;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the model to update.
     * </p>
     * 
     * @return The name of the model to update.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * Returns the value of the LabelsInputConfiguration property for this object.
     * 
     * @return The value of the LabelsInputConfiguration property for this object.
     */
    public final LabelsInputConfiguration labelsInputConfiguration() {
        return labelsInputConfiguration;
    }

    /**
     * <p>
     * The ARN of the model to update.
     * </p>
     * 
     * @return The ARN of the model to update.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(labelsInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateModelRequest)) {
            return false;
        }
        UpdateModelRequest other = (UpdateModelRequest) obj;
        return Objects.equals(modelName(), other.modelName())
                && Objects.equals(labelsInputConfiguration(), other.labelsInputConfiguration())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateModelRequest").add("ModelName", modelName())
                .add("LabelsInputConfiguration", labelsInputConfiguration()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "LabelsInputConfiguration":
            return Optional.ofNullable(clazz.cast(labelsInputConfiguration()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateModelRequest, T> g) {
        return obj -> g.apply((UpdateModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateModelRequest> {
        /**
         * <p>
         * The name of the model to update.
         * </p>
         * 
         * @param modelName
         *        The name of the model to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * Sets the value of the LabelsInputConfiguration property for this object.
         *
         * @param labelsInputConfiguration
         *        The new value for the LabelsInputConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelsInputConfiguration(LabelsInputConfiguration labelsInputConfiguration);

        /**
         * Sets the value of the LabelsInputConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LabelsInputConfiguration.Builder}
         * avoiding the need to create one manually via {@link LabelsInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelsInputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #labelsInputConfiguration(LabelsInputConfiguration)}.
         * 
         * @param labelsInputConfiguration
         *        a consumer that will call methods on {@link LabelsInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelsInputConfiguration(LabelsInputConfiguration)
         */
        default Builder labelsInputConfiguration(Consumer<LabelsInputConfiguration.Builder> labelsInputConfiguration) {
            return labelsInputConfiguration(LabelsInputConfiguration.builder().applyMutation(labelsInputConfiguration).build());
        }

        /**
         * <p>
         * The ARN of the model to update.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the model to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String modelName;

        private LabelsInputConfiguration labelsInputConfiguration;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateModelRequest model) {
            super(model);
            modelName(model.modelName);
            labelsInputConfiguration(model.labelsInputConfiguration);
            roleArn(model.roleArn);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final LabelsInputConfiguration.Builder getLabelsInputConfiguration() {
            return labelsInputConfiguration != null ? labelsInputConfiguration.toBuilder() : null;
        }

        public final void setLabelsInputConfiguration(LabelsInputConfiguration.BuilderImpl labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration != null ? labelsInputConfiguration.build() : null;
        }

        @Override
        public final Builder labelsInputConfiguration(LabelsInputConfiguration labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateModelRequest build() {
            return new UpdateModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
