/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.lookoutequipment.model.AccessDeniedException;
import software.amazon.awssdk.services.lookoutequipment.model.ConflictException;
import software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetResponse;
import software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupResponse;
import software.amazon.awssdk.services.lookoutequipment.model.CreateLabelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateLabelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.CreateModelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateModelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelGroupRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelGroupResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteModelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteModelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeModelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeModelVersionRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeModelVersionResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionResponse;
import software.amazon.awssdk.services.lookoutequipment.model.InternalServerException;
import software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentException;
import software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lookoutequipment.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobRequest;
import software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobResponse;
import software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.TagResourceRequest;
import software.amazon.awssdk.services.lookoutequipment.model.TagResourceResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ThrottlingException;
import software.amazon.awssdk.services.lookoutequipment.model.UntagResourceRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UntagResourceResponse;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionResponse;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateLabelGroupRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateLabelGroupResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ValidationException;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListDataIngestionJobsIterable;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListDatasetsIterable;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceEventsIterable;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceExecutionsIterable;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceSchedulersIterable;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelGroupsIterable;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelsIterable;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListModelVersionsIterable;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListModelsIterable;
import software.amazon.awssdk.services.lookoutequipment.paginators.ListSensorStatisticsIterable;

/**
 * Service client for accessing LookoutEquipment. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Lookout for Equipment is a machine learning service that uses advanced analytics to identify anomalies in
 * machines from sensor data for use in predictive maintenance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LookoutEquipmentClient extends AwsClient {
    String SERVICE_NAME = "lookoutequipment";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "lookoutequipment";

    /**
     * <p>
     * Creates a container for a collection of data being ingested for analysis. The dataset contains the metadata
     * describing where the data is and what the data actually looks like. For example, it contains the location of the
     * data source, the data schema, and other information. A dataset also contains any tags associated with the
     * ingested data.
     * </p>
     *
     * @param createDatasetRequest
     * @return Result of the CreateDataset operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatasetResponse createDataset(CreateDatasetRequest createDatasetRequest) throws ValidationException,
            ConflictException, ThrottlingException, ServiceQuotaExceededException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a container for a collection of data being ingested for analysis. The dataset contains the metadata
     * describing where the data is and what the data actually looks like. For example, it contains the location of the
     * data source, the data schema, and other information. A dataset also contains any tags associated with the
     * ingested data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDatasetRequest#builder()}
     * </p>
     *
     * @param createDatasetRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatasetRequest.Builder} to create a request.
     * @return Result of the CreateDataset operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatasetResponse createDataset(Consumer<CreateDatasetRequest.Builder> createDatasetRequest)
            throws ValidationException, ConflictException, ThrottlingException, ServiceQuotaExceededException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return createDataset(CreateDatasetRequest.builder().applyMutation(createDatasetRequest).build());
    }

    /**
     * <p>
     * Creates a scheduled inference. Scheduling an inference is setting up a continuous real-time inference plan to
     * analyze new measurement data. When setting up the schedule, you provide an S3 bucket location for the input data,
     * assign it a delimiter between separate entries in the data, set an offset delay if desired, and set the frequency
     * of inferencing. You must also provide an S3 bucket location for the output data.
     * </p>
     *
     * @param createInferenceSchedulerRequest
     * @return Result of the CreateInferenceScheduler operation returned by the service.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.CreateInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInferenceSchedulerResponse createInferenceScheduler(
            CreateInferenceSchedulerRequest createInferenceSchedulerRequest) throws ConflictException, ResourceNotFoundException,
            ValidationException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a scheduled inference. Scheduling an inference is setting up a continuous real-time inference plan to
     * analyze new measurement data. When setting up the schedule, you provide an S3 bucket location for the input data,
     * assign it a delimiter between separate entries in the data, set an offset delay if desired, and set the frequency
     * of inferencing. You must also provide an S3 bucket location for the output data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInferenceSchedulerRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInferenceSchedulerRequest#builder()}
     * </p>
     *
     * @param createInferenceSchedulerRequest
     *        A {@link Consumer} that will call methods on {@link CreateInferenceSchedulerRequest.Builder} to create a
     *        request.
     * @return Result of the CreateInferenceScheduler operation returned by the service.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.CreateInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInferenceSchedulerResponse createInferenceScheduler(
            Consumer<CreateInferenceSchedulerRequest.Builder> createInferenceSchedulerRequest) throws ConflictException,
            ResourceNotFoundException, ValidationException, ServiceQuotaExceededException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return createInferenceScheduler(CreateInferenceSchedulerRequest.builder().applyMutation(createInferenceSchedulerRequest)
                .build());
    }

    /**
     * <p>
     * Creates a label for an event.
     * </p>
     *
     * @param createLabelRequest
     * @return Result of the CreateLabel operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.CreateLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateLabel" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLabelResponse createLabel(CreateLabelRequest createLabelRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ServiceQuotaExceededException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a label for an event.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLabelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLabelRequest#builder()}
     * </p>
     *
     * @param createLabelRequest
     *        A {@link Consumer} that will call methods on {@link CreateLabelRequest.Builder} to create a request.
     * @return Result of the CreateLabel operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.CreateLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateLabel" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLabelResponse createLabel(Consumer<CreateLabelRequest.Builder> createLabelRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ServiceQuotaExceededException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return createLabel(CreateLabelRequest.builder().applyMutation(createLabelRequest).build());
    }

    /**
     * <p>
     * Creates a group of labels.
     * </p>
     *
     * @param createLabelGroupRequest
     * @return Result of the CreateLabelGroup operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.CreateLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLabelGroupResponse createLabelGroup(CreateLabelGroupRequest createLabelGroupRequest)
            throws ValidationException, ConflictException, ThrottlingException, ServiceQuotaExceededException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a group of labels.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLabelGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLabelGroupRequest#builder()}
     * </p>
     *
     * @param createLabelGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateLabelGroupRequest.Builder} to create a request.
     * @return Result of the CreateLabelGroup operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.CreateLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLabelGroupResponse createLabelGroup(Consumer<CreateLabelGroupRequest.Builder> createLabelGroupRequest)
            throws ValidationException, ConflictException, ThrottlingException, ServiceQuotaExceededException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return createLabelGroup(CreateLabelGroupRequest.builder().applyMutation(createLabelGroupRequest).build());
    }

    /**
     * <p>
     * Creates an ML model for data inference.
     * </p>
     * <p>
     * A machine-learning (ML) model is a mathematical model that finds patterns in your data. In Amazon Lookout for
     * Equipment, the model learns the patterns of normal behavior and detects abnormal behavior that could be potential
     * equipment failure (or maintenance events). The models are made by analyzing normal data and abnormalities in
     * machine behavior that have already occurred.
     * </p>
     * <p>
     * Your model is trained using a portion of the data from your dataset and uses that data to learn patterns of
     * normal behavior and abnormal patterns that lead to equipment failure. Another portion of the data is used to
     * evaluate the model's accuracy.
     * </p>
     *
     * @param createModelRequest
     * @return Result of the CreateModel operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateModelResponse createModel(CreateModelRequest createModelRequest) throws ValidationException, ConflictException,
            ThrottlingException, ServiceQuotaExceededException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an ML model for data inference.
     * </p>
     * <p>
     * A machine-learning (ML) model is a mathematical model that finds patterns in your data. In Amazon Lookout for
     * Equipment, the model learns the patterns of normal behavior and detects abnormal behavior that could be potential
     * equipment failure (or maintenance events). The models are made by analyzing normal data and abnormalities in
     * machine behavior that have already occurred.
     * </p>
     * <p>
     * Your model is trained using a portion of the data from your dataset and uses that data to learn patterns of
     * normal behavior and abnormal patterns that lead to equipment failure. Another portion of the data is used to
     * evaluate the model's accuracy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateModelRequest#builder()}
     * </p>
     *
     * @param createModelRequest
     *        A {@link Consumer} that will call methods on {@link CreateModelRequest.Builder} to create a request.
     * @return Result of the CreateModel operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateModelResponse createModel(Consumer<CreateModelRequest.Builder> createModelRequest) throws ValidationException,
            ConflictException, ThrottlingException, ServiceQuotaExceededException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return createModel(CreateModelRequest.builder().applyMutation(createModelRequest).build());
    }

    /**
     * <p>
     * Deletes a dataset and associated artifacts. The operation will check to see if any inference scheduler or data
     * ingestion job is currently using the dataset, and if there isn't, the dataset, its metadata, and any associated
     * data stored in S3 will be deleted. This does not affect any models that used this dataset for training and
     * evaluation, but does prevent it from being used in the future.
     * </p>
     *
     * @param deleteDatasetRequest
     * @return Result of the DeleteDataset operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDatasetResponse deleteDataset(DeleteDatasetRequest deleteDatasetRequest) throws ResourceNotFoundException,
            ThrottlingException, InternalServerException, AccessDeniedException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dataset and associated artifacts. The operation will check to see if any inference scheduler or data
     * ingestion job is currently using the dataset, and if there isn't, the dataset, its metadata, and any associated
     * data stored in S3 will be deleted. This does not affect any models that used this dataset for training and
     * evaluation, but does prevent it from being used in the future.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDatasetRequest#builder()}
     * </p>
     *
     * @param deleteDatasetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatasetRequest.Builder} to create a request.
     * @return Result of the DeleteDataset operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDatasetResponse deleteDataset(Consumer<DeleteDatasetRequest.Builder> deleteDatasetRequest)
            throws ResourceNotFoundException, ThrottlingException, InternalServerException, AccessDeniedException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return deleteDataset(DeleteDatasetRequest.builder().applyMutation(deleteDatasetRequest).build());
    }

    /**
     * <p>
     * Deletes an inference scheduler that has been set up. Already processed output results are not affected.
     * </p>
     *
     * @param deleteInferenceSchedulerRequest
     * @return Result of the DeleteInferenceScheduler operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DeleteInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInferenceSchedulerResponse deleteInferenceScheduler(
            DeleteInferenceSchedulerRequest deleteInferenceSchedulerRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an inference scheduler that has been set up. Already processed output results are not affected.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInferenceSchedulerRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInferenceSchedulerRequest#builder()}
     * </p>
     *
     * @param deleteInferenceSchedulerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInferenceSchedulerRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteInferenceScheduler operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DeleteInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInferenceSchedulerResponse deleteInferenceScheduler(
            Consumer<DeleteInferenceSchedulerRequest.Builder> deleteInferenceSchedulerRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, LookoutEquipmentException {
        return deleteInferenceScheduler(DeleteInferenceSchedulerRequest.builder().applyMutation(deleteInferenceSchedulerRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a label.
     * </p>
     *
     * @param deleteLabelRequest
     * @return Result of the DeleteLabel operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DeleteLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteLabel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteLabelResponse deleteLabel(DeleteLabelRequest deleteLabelRequest) throws ResourceNotFoundException,
            ThrottlingException, InternalServerException, AccessDeniedException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a label.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLabelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLabelRequest#builder()}
     * </p>
     *
     * @param deleteLabelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLabelRequest.Builder} to create a request.
     * @return Result of the DeleteLabel operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DeleteLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteLabel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteLabelResponse deleteLabel(Consumer<DeleteLabelRequest.Builder> deleteLabelRequest)
            throws ResourceNotFoundException, ThrottlingException, InternalServerException, AccessDeniedException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return deleteLabel(DeleteLabelRequest.builder().applyMutation(deleteLabelRequest).build());
    }

    /**
     * <p>
     * Deletes a group of labels.
     * </p>
     *
     * @param deleteLabelGroupRequest
     * @return Result of the DeleteLabelGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DeleteLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLabelGroupResponse deleteLabelGroup(DeleteLabelGroupRequest deleteLabelGroupRequest)
            throws ResourceNotFoundException, ThrottlingException, InternalServerException, AccessDeniedException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a group of labels.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLabelGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteLabelGroupRequest#builder()}
     * </p>
     *
     * @param deleteLabelGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLabelGroupRequest.Builder} to create a request.
     * @return Result of the DeleteLabelGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DeleteLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLabelGroupResponse deleteLabelGroup(Consumer<DeleteLabelGroupRequest.Builder> deleteLabelGroupRequest)
            throws ResourceNotFoundException, ThrottlingException, InternalServerException, AccessDeniedException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return deleteLabelGroup(DeleteLabelGroupRequest.builder().applyMutation(deleteLabelGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an ML model currently available for Amazon Lookout for Equipment. This will prevent it from being used
     * with an inference scheduler, even one that is already set up.
     * </p>
     *
     * @param deleteModelRequest
     * @return Result of the DeleteModel operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteModel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteModelResponse deleteModel(DeleteModelRequest deleteModelRequest) throws ResourceNotFoundException,
            ThrottlingException, InternalServerException, ConflictException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an ML model currently available for Amazon Lookout for Equipment. This will prevent it from being used
     * with an inference scheduler, even one that is already set up.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteModelRequest#builder()}
     * </p>
     *
     * @param deleteModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteModelRequest.Builder} to create a request.
     * @return Result of the DeleteModel operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteModel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteModelResponse deleteModel(Consumer<DeleteModelRequest.Builder> deleteModelRequest)
            throws ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException,
            AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return deleteModel(DeleteModelRequest.builder().applyMutation(deleteModelRequest).build());
    }

    /**
     * <p>
     * Deletes the resource policy attached to the resource.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws ResourceNotFoundException, ThrottlingException, InternalServerException, AccessDeniedException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the resource policy attached to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws ResourceNotFoundException,
            ThrottlingException, InternalServerException, AccessDeniedException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, LookoutEquipmentException {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Provides information on a specific data ingestion job such as creation time, dataset ARN, and status.
     * </p>
     *
     * @param describeDataIngestionJobRequest
     * @return Result of the DescribeDataIngestionJob operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeDataIngestionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeDataIngestionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDataIngestionJobResponse describeDataIngestionJob(
            DescribeDataIngestionJobRequest describeDataIngestionJobRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information on a specific data ingestion job such as creation time, dataset ARN, and status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataIngestionJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDataIngestionJobRequest#builder()}
     * </p>
     *
     * @param describeDataIngestionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataIngestionJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDataIngestionJob operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeDataIngestionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeDataIngestionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDataIngestionJobResponse describeDataIngestionJob(
            Consumer<DescribeDataIngestionJobRequest.Builder> describeDataIngestionJobRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return describeDataIngestionJob(DescribeDataIngestionJobRequest.builder().applyMutation(describeDataIngestionJobRequest)
                .build());
    }

    /**
     * <p>
     * Provides a JSON description of the data in each time series dataset, including names, column names, and data
     * types.
     * </p>
     *
     * @param describeDatasetRequest
     * @return Result of the DescribeDataset operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a JSON description of the data in each time series dataset, including names, column names, and data
     * types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatasetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDatasetRequest#builder()}
     * </p>
     *
     * @param describeDatasetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDatasetRequest.Builder} to create a request.
     * @return Result of the DescribeDataset operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDatasetResponse describeDataset(Consumer<DescribeDatasetRequest.Builder> describeDatasetRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return describeDataset(DescribeDatasetRequest.builder().applyMutation(describeDatasetRequest).build());
    }

    /**
     * <p>
     * Specifies information about the inference scheduler being used, including name, model, status, and associated
     * metadata
     * </p>
     *
     * @param describeInferenceSchedulerRequest
     * @return Result of the DescribeInferenceScheduler operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInferenceSchedulerResponse describeInferenceScheduler(
            DescribeInferenceSchedulerRequest describeInferenceSchedulerRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies information about the inference scheduler being used, including name, model, status, and associated
     * metadata
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInferenceSchedulerRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInferenceSchedulerRequest#builder()}
     * </p>
     *
     * @param describeInferenceSchedulerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInferenceSchedulerRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeInferenceScheduler operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInferenceSchedulerResponse describeInferenceScheduler(
            Consumer<DescribeInferenceSchedulerRequest.Builder> describeInferenceSchedulerRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return describeInferenceScheduler(DescribeInferenceSchedulerRequest.builder()
                .applyMutation(describeInferenceSchedulerRequest).build());
    }

    /**
     * <p>
     * Returns the name of the label.
     * </p>
     *
     * @param describeLabelRequest
     * @return Result of the DescribeLabel operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLabelResponse describeLabel(DescribeLabelRequest describeLabelRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the name of the label.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLabelRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeLabelRequest#builder()}
     * </p>
     *
     * @param describeLabelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLabelRequest.Builder} to create a request.
     * @return Result of the DescribeLabel operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLabelResponse describeLabel(Consumer<DescribeLabelRequest.Builder> describeLabelRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return describeLabel(DescribeLabelRequest.builder().applyMutation(describeLabelRequest).build());
    }

    /**
     * <p>
     * Returns information about the label group.
     * </p>
     *
     * @param describeLabelGroupRequest
     * @return Result of the DescribeLabelGroup operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLabelGroupResponse describeLabelGroup(DescribeLabelGroupRequest describeLabelGroupRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the label group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLabelGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLabelGroupRequest#builder()}
     * </p>
     *
     * @param describeLabelGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLabelGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeLabelGroup operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLabelGroupResponse describeLabelGroup(Consumer<DescribeLabelGroupRequest.Builder> describeLabelGroupRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return describeLabelGroup(DescribeLabelGroupRequest.builder().applyMutation(describeLabelGroupRequest).build());
    }

    /**
     * <p>
     * Provides a JSON containing the overall information about a specific ML model, including model name and ARN,
     * dataset, training and evaluation information, status, and so on.
     * </p>
     *
     * @param describeModelRequest
     * @return Result of the DescribeModel operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelResponse describeModel(DescribeModelRequest describeModelRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a JSON containing the overall information about a specific ML model, including model name and ARN,
     * dataset, training and evaluation information, status, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeModelRequest#builder()}
     * </p>
     *
     * @param describeModelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeModelRequest.Builder} to create a request.
     * @return Result of the DescribeModel operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelResponse describeModel(Consumer<DescribeModelRequest.Builder> describeModelRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return describeModel(DescribeModelRequest.builder().applyMutation(describeModelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific machine learning model version.
     * </p>
     *
     * @param describeModelVersionRequest
     * @return Result of the DescribeModelVersion operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelVersionResponse describeModelVersion(DescribeModelVersionRequest describeModelVersionRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific machine learning model version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeModelVersionRequest#builder()}
     * </p>
     *
     * @param describeModelVersionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeModelVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeModelVersion operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelVersionResponse describeModelVersion(
            Consumer<DescribeModelVersionRequest.Builder> describeModelVersionRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return describeModelVersion(DescribeModelVersionRequest.builder().applyMutation(describeModelVersionRequest).build());
    }

    /**
     * <p>
     * Provides the details of a resource policy attached to a resource.
     * </p>
     *
     * @param describeResourcePolicyRequest
     * @return Result of the DescribeResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePolicyResponse describeResourcePolicy(DescribeResourcePolicyRequest describeResourcePolicyRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the details of a resource policy attached to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeResourcePolicyRequest#builder()}
     * </p>
     *
     * @param describeResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DescribeResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePolicyResponse describeResourcePolicy(
            Consumer<DescribeResourcePolicyRequest.Builder> describeResourcePolicyRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return describeResourcePolicy(DescribeResourcePolicyRequest.builder().applyMutation(describeResourcePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Imports a dataset.
     * </p>
     *
     * @param importDatasetRequest
     * @return Result of the ImportDataset operation returned by the service.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ImportDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ImportDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportDatasetResponse importDataset(ImportDatasetRequest importDatasetRequest) throws ConflictException,
            ResourceNotFoundException, ValidationException, ServiceQuotaExceededException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link ImportDatasetRequest#builder()}
     * </p>
     *
     * @param importDatasetRequest
     *        A {@link Consumer} that will call methods on {@link ImportDatasetRequest.Builder} to create a request.
     * @return Result of the ImportDataset operation returned by the service.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ImportDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ImportDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportDatasetResponse importDataset(Consumer<ImportDatasetRequest.Builder> importDatasetRequest)
            throws ConflictException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutEquipmentException {
        return importDataset(ImportDatasetRequest.builder().applyMutation(importDatasetRequest).build());
    }

    /**
     * <p>
     * Imports a model that has been trained successfully.
     * </p>
     *
     * @param importModelVersionRequest
     * @return Result of the ImportModelVersion operation returned by the service.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ImportModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ImportModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportModelVersionResponse importModelVersion(ImportModelVersionRequest importModelVersionRequest)
            throws ConflictException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a model that has been trained successfully.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportModelVersionRequest.Builder} avoiding the
     * need to create one manually via {@link ImportModelVersionRequest#builder()}
     * </p>
     *
     * @param importModelVersionRequest
     *        A {@link Consumer} that will call methods on {@link ImportModelVersionRequest.Builder} to create a
     *        request.
     * @return Result of the ImportModelVersion operation returned by the service.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ImportModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ImportModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportModelVersionResponse importModelVersion(Consumer<ImportModelVersionRequest.Builder> importModelVersionRequest)
            throws ConflictException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutEquipmentException {
        return importModelVersion(ImportModelVersionRequest.builder().applyMutation(importModelVersionRequest).build());
    }

    /**
     * <p>
     * Provides a list of all data ingestion jobs, including dataset name and ARN, S3 location of the input data,
     * status, and so on.
     * </p>
     *
     * @param listDataIngestionJobsRequest
     * @return Result of the ListDataIngestionJobs operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListDataIngestionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDataIngestionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIngestionJobsResponse listDataIngestionJobs(ListDataIngestionJobsRequest listDataIngestionJobsRequest)
            throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of all data ingestion jobs, including dataset name and ARN, S3 location of the input data,
     * status, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIngestionJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataIngestionJobsRequest#builder()}
     * </p>
     *
     * @param listDataIngestionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataIngestionJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDataIngestionJobs operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListDataIngestionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDataIngestionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIngestionJobsResponse listDataIngestionJobs(
            Consumer<ListDataIngestionJobsRequest.Builder> listDataIngestionJobsRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutEquipmentException {
        return listDataIngestionJobs(ListDataIngestionJobsRequest.builder().applyMutation(listDataIngestionJobsRequest).build());
    }

    /**
     * <p>
     * Provides a list of all data ingestion jobs, including dataset name and ARN, S3 location of the input data,
     * status, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataIngestionJobs(software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDataIngestionJobsIterable responses = client.listDataIngestionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListDataIngestionJobsIterable responses = client
     *             .listDataIngestionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDataIngestionJobsIterable responses = client.listDataIngestionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIngestionJobs(software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataIngestionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListDataIngestionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDataIngestionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIngestionJobsIterable listDataIngestionJobsPaginator(ListDataIngestionJobsRequest listDataIngestionJobsRequest)
            throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return new ListDataIngestionJobsIterable(this, listDataIngestionJobsRequest);
    }

    /**
     * <p>
     * Provides a list of all data ingestion jobs, including dataset name and ARN, S3 location of the input data,
     * status, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataIngestionJobs(software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDataIngestionJobsIterable responses = client.listDataIngestionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListDataIngestionJobsIterable responses = client
     *             .listDataIngestionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDataIngestionJobsIterable responses = client.listDataIngestionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIngestionJobs(software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIngestionJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataIngestionJobsRequest#builder()}
     * </p>
     *
     * @param listDataIngestionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataIngestionJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListDataIngestionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDataIngestionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIngestionJobsIterable listDataIngestionJobsPaginator(
            Consumer<ListDataIngestionJobsRequest.Builder> listDataIngestionJobsRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutEquipmentException {
        return listDataIngestionJobsPaginator(ListDataIngestionJobsRequest.builder().applyMutation(listDataIngestionJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all datasets currently available in your account, filtering on the dataset name.
     * </p>
     *
     * @param listDatasetsRequest
     * @return Result of the ListDatasets operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDatasets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatasetsResponse listDatasets(ListDatasetsRequest listDatasetsRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all datasets currently available in your account, filtering on the dataset name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatasetsRequest#builder()}
     * </p>
     *
     * @param listDatasetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetsRequest.Builder} to create a request.
     * @return Result of the ListDatasets operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDatasets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatasetsResponse listDatasets(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest)
            throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return listDatasets(ListDatasetsRequest.builder().applyMutation(listDatasetsRequest).build());
    }

    /**
     * <p>
     * Lists all datasets currently available in your account, filtering on the dataset name.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasets(software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListDatasetsIterable responses = client
     *             .listDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasets(software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest)} operation.</b>
     * </p>
     *
     * @param listDatasetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDatasets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatasetsIterable listDatasetsPaginator(ListDatasetsRequest listDatasetsRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutEquipmentException {
        return new ListDatasetsIterable(this, listDatasetsRequest);
    }

    /**
     * <p>
     * Lists all datasets currently available in your account, filtering on the dataset name.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasets(software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListDatasetsIterable responses = client
     *             .listDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasets(software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatasetsRequest#builder()}
     * </p>
     *
     * @param listDatasetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDatasets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatasetsIterable listDatasetsPaginator(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest)
            throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return listDatasetsPaginator(ListDatasetsRequest.builder().applyMutation(listDatasetsRequest).build());
    }

    /**
     * <p>
     * Lists all inference events that have been found for the specified inference scheduler.
     * </p>
     *
     * @param listInferenceEventsRequest
     * @return Result of the ListInferenceEvents operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListInferenceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceEventsResponse listInferenceEvents(ListInferenceEventsRequest listInferenceEventsRequest)
            throws ValidationException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all inference events that have been found for the specified inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInferenceEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInferenceEventsRequest#builder()}
     * </p>
     *
     * @param listInferenceEventsRequest
     *        A {@link Consumer} that will call methods on {@link ListInferenceEventsRequest.Builder} to create a
     *        request.
     * @return Result of the ListInferenceEvents operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListInferenceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceEventsResponse listInferenceEvents(
            Consumer<ListInferenceEventsRequest.Builder> listInferenceEventsRequest) throws ValidationException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return listInferenceEvents(ListInferenceEventsRequest.builder().applyMutation(listInferenceEventsRequest).build());
    }

    /**
     * <p>
     * Lists all inference events that have been found for the specified inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInferenceEvents(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceEventsIterable responses = client.listInferenceEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceEventsIterable responses = client
     *             .listInferenceEventsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceEventsIterable responses = client.listInferenceEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceEvents(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInferenceEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListInferenceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceEventsIterable listInferenceEventsPaginator(ListInferenceEventsRequest listInferenceEventsRequest)
            throws ValidationException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return new ListInferenceEventsIterable(this, listInferenceEventsRequest);
    }

    /**
     * <p>
     * Lists all inference events that have been found for the specified inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInferenceEvents(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceEventsIterable responses = client.listInferenceEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceEventsIterable responses = client
     *             .listInferenceEventsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceEventsIterable responses = client.listInferenceEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceEvents(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInferenceEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInferenceEventsRequest#builder()}
     * </p>
     *
     * @param listInferenceEventsRequest
     *        A {@link Consumer} that will call methods on {@link ListInferenceEventsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListInferenceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceEventsIterable listInferenceEventsPaginator(
            Consumer<ListInferenceEventsRequest.Builder> listInferenceEventsRequest) throws ValidationException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return listInferenceEventsPaginator(ListInferenceEventsRequest.builder().applyMutation(listInferenceEventsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all inference executions that have been performed by the specified inference scheduler.
     * </p>
     *
     * @param listInferenceExecutionsRequest
     * @return Result of the ListInferenceExecutions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListInferenceExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceExecutionsResponse listInferenceExecutions(ListInferenceExecutionsRequest listInferenceExecutionsRequest)
            throws ValidationException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all inference executions that have been performed by the specified inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInferenceExecutionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInferenceExecutionsRequest#builder()}
     * </p>
     *
     * @param listInferenceExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListInferenceExecutionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListInferenceExecutions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListInferenceExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceExecutionsResponse listInferenceExecutions(
            Consumer<ListInferenceExecutionsRequest.Builder> listInferenceExecutionsRequest) throws ValidationException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return listInferenceExecutions(ListInferenceExecutionsRequest.builder().applyMutation(listInferenceExecutionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all inference executions that have been performed by the specified inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInferenceExecutions(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceExecutionsIterable responses = client.listInferenceExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceExecutionsIterable responses = client
     *             .listInferenceExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceExecutionsIterable responses = client.listInferenceExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceExecutions(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInferenceExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListInferenceExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceExecutionsIterable listInferenceExecutionsPaginator(
            ListInferenceExecutionsRequest listInferenceExecutionsRequest) throws ValidationException, ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutEquipmentException {
        return new ListInferenceExecutionsIterable(this, listInferenceExecutionsRequest);
    }

    /**
     * <p>
     * Lists all inference executions that have been performed by the specified inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInferenceExecutions(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceExecutionsIterable responses = client.listInferenceExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceExecutionsIterable responses = client
     *             .listInferenceExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceExecutionsIterable responses = client.listInferenceExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceExecutions(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInferenceExecutionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInferenceExecutionsRequest#builder()}
     * </p>
     *
     * @param listInferenceExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListInferenceExecutionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListInferenceExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceExecutionsIterable listInferenceExecutionsPaginator(
            Consumer<ListInferenceExecutionsRequest.Builder> listInferenceExecutionsRequest) throws ValidationException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return listInferenceExecutionsPaginator(ListInferenceExecutionsRequest.builder()
                .applyMutation(listInferenceExecutionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all inference schedulers currently available for your account.
     * </p>
     *
     * @param listInferenceSchedulersRequest
     * @return Result of the ListInferenceSchedulers operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListInferenceSchedulers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceSchedulers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceSchedulersResponse listInferenceSchedulers(ListInferenceSchedulersRequest listInferenceSchedulersRequest)
            throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all inference schedulers currently available for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInferenceSchedulersRequest.Builder} avoiding
     * the need to create one manually via {@link ListInferenceSchedulersRequest#builder()}
     * </p>
     *
     * @param listInferenceSchedulersRequest
     *        A {@link Consumer} that will call methods on {@link ListInferenceSchedulersRequest.Builder} to create a
     *        request.
     * @return Result of the ListInferenceSchedulers operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListInferenceSchedulers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceSchedulers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceSchedulersResponse listInferenceSchedulers(
            Consumer<ListInferenceSchedulersRequest.Builder> listInferenceSchedulersRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutEquipmentException {
        return listInferenceSchedulers(ListInferenceSchedulersRequest.builder().applyMutation(listInferenceSchedulersRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of all inference schedulers currently available for your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInferenceSchedulers(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceSchedulersIterable responses = client.listInferenceSchedulersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceSchedulersIterable responses = client
     *             .listInferenceSchedulersPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceSchedulersIterable responses = client.listInferenceSchedulersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceSchedulers(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInferenceSchedulersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListInferenceSchedulers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceSchedulers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceSchedulersIterable listInferenceSchedulersPaginator(
            ListInferenceSchedulersRequest listInferenceSchedulersRequest) throws ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return new ListInferenceSchedulersIterable(this, listInferenceSchedulersRequest);
    }

    /**
     * <p>
     * Retrieves a list of all inference schedulers currently available for your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInferenceSchedulers(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceSchedulersIterable responses = client.listInferenceSchedulersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceSchedulersIterable responses = client
     *             .listInferenceSchedulersPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListInferenceSchedulersIterable responses = client.listInferenceSchedulersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInferenceSchedulers(software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInferenceSchedulersRequest.Builder} avoiding
     * the need to create one manually via {@link ListInferenceSchedulersRequest#builder()}
     * </p>
     *
     * @param listInferenceSchedulersRequest
     *        A {@link Consumer} that will call methods on {@link ListInferenceSchedulersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListInferenceSchedulers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceSchedulers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInferenceSchedulersIterable listInferenceSchedulersPaginator(
            Consumer<ListInferenceSchedulersRequest.Builder> listInferenceSchedulersRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutEquipmentException {
        return listInferenceSchedulersPaginator(ListInferenceSchedulersRequest.builder()
                .applyMutation(listInferenceSchedulersRequest).build());
    }

    /**
     * <p>
     * Returns a list of the label groups.
     * </p>
     *
     * @param listLabelGroupsRequest
     * @return Result of the ListLabelGroups operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListLabelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLabelGroupsResponse listLabelGroups(ListLabelGroupsRequest listLabelGroupsRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the label groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLabelGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLabelGroupsRequest#builder()}
     * </p>
     *
     * @param listLabelGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListLabelGroupsRequest.Builder} to create a request.
     * @return Result of the ListLabelGroups operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListLabelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLabelGroupsResponse listLabelGroups(Consumer<ListLabelGroupsRequest.Builder> listLabelGroupsRequest)
            throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return listLabelGroups(ListLabelGroupsRequest.builder().applyMutation(listLabelGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the label groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabelGroups(software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelGroupsIterable responses = client.listLabelGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelGroupsIterable responses = client
     *             .listLabelGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelGroupsIterable responses = client.listLabelGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabelGroups(software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLabelGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListLabelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLabelGroupsIterable listLabelGroupsPaginator(ListLabelGroupsRequest listLabelGroupsRequest)
            throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return new ListLabelGroupsIterable(this, listLabelGroupsRequest);
    }

    /**
     * <p>
     * Returns a list of the label groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabelGroups(software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelGroupsIterable responses = client.listLabelGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelGroupsIterable responses = client
     *             .listLabelGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelGroupsIterable responses = client.listLabelGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabelGroups(software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLabelGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLabelGroupsRequest#builder()}
     * </p>
     *
     * @param listLabelGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListLabelGroupsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListLabelGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabelGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLabelGroupsIterable listLabelGroupsPaginator(Consumer<ListLabelGroupsRequest.Builder> listLabelGroupsRequest)
            throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return listLabelGroupsPaginator(ListLabelGroupsRequest.builder().applyMutation(listLabelGroupsRequest).build());
    }

    /**
     * <p>
     * Provides a list of labels.
     * </p>
     *
     * @param listLabelsRequest
     * @return Result of the ListLabels operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLabelsResponse listLabels(ListLabelsRequest listLabelsRequest) throws ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of labels.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLabelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLabelsRequest#builder()}
     * </p>
     *
     * @param listLabelsRequest
     *        A {@link Consumer} that will call methods on {@link ListLabelsRequest.Builder} to create a request.
     * @return Result of the ListLabels operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLabelsResponse listLabels(Consumer<ListLabelsRequest.Builder> listLabelsRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutEquipmentException {
        return listLabels(ListLabelsRequest.builder().applyMutation(listLabelsRequest).build());
    }

    /**
     * <p>
     * Provides a list of labels.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabels(software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelsIterable responses = client.listLabelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelsIterable responses = client
     *             .listLabelsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelsIterable responses = client.listLabelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabels(software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest)} operation.</b>
     * </p>
     *
     * @param listLabelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLabelsIterable listLabelsPaginator(ListLabelsRequest listLabelsRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutEquipmentException {
        return new ListLabelsIterable(this, listLabelsRequest);
    }

    /**
     * <p>
     * Provides a list of labels.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabels(software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelsIterable responses = client.listLabelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelsIterable responses = client
     *             .listLabelsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListLabelsIterable responses = client.listLabelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabels(software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLabelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLabelsRequest#builder()}
     * </p>
     *
     * @param listLabelsRequest
     *        A {@link Consumer} that will call methods on {@link ListLabelsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLabelsIterable listLabelsPaginator(Consumer<ListLabelsRequest.Builder> listLabelsRequest)
            throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return listLabelsPaginator(ListLabelsRequest.builder().applyMutation(listLabelsRequest).build());
    }

    /**
     * <p>
     * Generates a list of all model versions for a given model, including the model version, model version ARN, and
     * status. To list a subset of versions, use the <code>MaxModelVersion</code> and <code>MinModelVersion</code>
     * fields.
     * </p>
     *
     * @param listModelVersionsRequest
     * @return Result of the ListModelVersions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelVersionsResponse listModelVersions(ListModelVersionsRequest listModelVersionsRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a list of all model versions for a given model, including the model version, model version ARN, and
     * status. To list a subset of versions, use the <code>MaxModelVersion</code> and <code>MinModelVersion</code>
     * fields.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListModelVersionsRequest#builder()}
     * </p>
     *
     * @param listModelVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListModelVersionsRequest.Builder} to create a request.
     * @return Result of the ListModelVersions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelVersionsResponse listModelVersions(Consumer<ListModelVersionsRequest.Builder> listModelVersionsRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return listModelVersions(ListModelVersionsRequest.builder().applyMutation(listModelVersionsRequest).build());
    }

    /**
     * <p>
     * Generates a list of all model versions for a given model, including the model version, model version ARN, and
     * status. To list a subset of versions, use the <code>MaxModelVersion</code> and <code>MinModelVersion</code>
     * fields.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelVersions(software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelVersionsIterable responses = client.listModelVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListModelVersionsIterable responses = client
     *             .listModelVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelVersionsIterable responses = client.listModelVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelVersions(software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelVersionsIterable listModelVersionsPaginator(ListModelVersionsRequest listModelVersionsRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return new ListModelVersionsIterable(this, listModelVersionsRequest);
    }

    /**
     * <p>
     * Generates a list of all model versions for a given model, including the model version, model version ARN, and
     * status. To list a subset of versions, use the <code>MaxModelVersion</code> and <code>MinModelVersion</code>
     * fields.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelVersions(software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelVersionsIterable responses = client.listModelVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListModelVersionsIterable responses = client
     *             .listModelVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelVersionsIterable responses = client.listModelVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelVersions(software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListModelVersionsRequest#builder()}
     * </p>
     *
     * @param listModelVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListModelVersionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelVersionsIterable listModelVersionsPaginator(
            Consumer<ListModelVersionsRequest.Builder> listModelVersionsRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return listModelVersionsPaginator(ListModelVersionsRequest.builder().applyMutation(listModelVersionsRequest).build());
    }

    /**
     * <p>
     * Generates a list of all models in the account, including model name and ARN, dataset, and status.
     * </p>
     *
     * @param listModelsRequest
     * @return Result of the ListModels operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListModelsResponse listModels(ListModelsRequest listModelsRequest) throws ValidationException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a list of all models in the account, including model name and ARN, dataset, and status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListModelsRequest#builder()}
     * </p>
     *
     * @param listModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListModelsRequest.Builder} to create a request.
     * @return Result of the ListModels operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListModelsResponse listModels(Consumer<ListModelsRequest.Builder> listModelsRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutEquipmentException {
        return listModels(ListModelsRequest.builder().applyMutation(listModelsRequest).build());
    }

    /**
     * <p>
     * Generates a list of all models in the account, including model name and ARN, dataset, and status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModels(software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListModelsIterable responses = client
     *             .listModelsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModels(software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest)} operation.</b>
     * </p>
     *
     * @param listModelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListModelsIterable listModelsPaginator(ListModelsRequest listModelsRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutEquipmentException {
        return new ListModelsIterable(this, listModelsRequest);
    }

    /**
     * <p>
     * Generates a list of all models in the account, including model name and ARN, dataset, and status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModels(software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListModelsIterable responses = client
     *             .listModelsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModels(software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListModelsRequest#builder()}
     * </p>
     *
     * @param listModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListModelsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListModelsIterable listModelsPaginator(Consumer<ListModelsRequest.Builder> listModelsRequest)
            throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return listModelsPaginator(ListModelsRequest.builder().applyMutation(listModelsRequest).build());
    }

    /**
     * <p>
     * Lists statistics about the data collected for each of the sensors that have been successfully ingested in the
     * particular dataset. Can also be used to retreive Sensor Statistics for a previous ingestion job.
     * </p>
     *
     * @param listSensorStatisticsRequest
     * @return Result of the ListSensorStatistics operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListSensorStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListSensorStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSensorStatisticsResponse listSensorStatistics(ListSensorStatisticsRequest listSensorStatisticsRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists statistics about the data collected for each of the sensors that have been successfully ingested in the
     * particular dataset. Can also be used to retreive Sensor Statistics for a previous ingestion job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSensorStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSensorStatisticsRequest#builder()}
     * </p>
     *
     * @param listSensorStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link ListSensorStatisticsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSensorStatistics operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListSensorStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListSensorStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSensorStatisticsResponse listSensorStatistics(
            Consumer<ListSensorStatisticsRequest.Builder> listSensorStatisticsRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return listSensorStatistics(ListSensorStatisticsRequest.builder().applyMutation(listSensorStatisticsRequest).build());
    }

    /**
     * <p>
     * Lists statistics about the data collected for each of the sensors that have been successfully ingested in the
     * particular dataset. Can also be used to retreive Sensor Statistics for a previous ingestion job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSensorStatistics(software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListSensorStatisticsIterable responses = client.listSensorStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListSensorStatisticsIterable responses = client
     *             .listSensorStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListSensorStatisticsIterable responses = client.listSensorStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSensorStatistics(software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSensorStatisticsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListSensorStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListSensorStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSensorStatisticsIterable listSensorStatisticsPaginator(ListSensorStatisticsRequest listSensorStatisticsRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return new ListSensorStatisticsIterable(this, listSensorStatisticsRequest);
    }

    /**
     * <p>
     * Lists statistics about the data collected for each of the sensors that have been successfully ingested in the
     * particular dataset. Can also be used to retreive Sensor Statistics for a previous ingestion job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSensorStatistics(software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListSensorStatisticsIterable responses = client.listSensorStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutequipment.paginators.ListSensorStatisticsIterable responses = client
     *             .listSensorStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutequipment.paginators.ListSensorStatisticsIterable responses = client.listSensorStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSensorStatistics(software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSensorStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSensorStatisticsRequest#builder()}
     * </p>
     *
     * @param listSensorStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link ListSensorStatisticsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListSensorStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListSensorStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSensorStatisticsIterable listSensorStatisticsPaginator(
            Consumer<ListSensorStatisticsRequest.Builder> listSensorStatisticsRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return listSensorStatisticsPaginator(ListSensorStatisticsRequest.builder().applyMutation(listSensorStatisticsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the tags for a specified resource, including key and value.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the tags for a specified resource, including key and value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates a resource control policy for a given resource.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ServiceQuotaExceededException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resource control policy for a given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutResourcePolicyRequest.Builder} to create a request.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ServiceQuotaExceededException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Starts a data ingestion job. Amazon Lookout for Equipment returns the job status.
     * </p>
     *
     * @param startDataIngestionJobRequest
     * @return Result of the StartDataIngestionJob operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.StartDataIngestionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StartDataIngestionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDataIngestionJobResponse startDataIngestionJob(StartDataIngestionJobRequest startDataIngestionJobRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ServiceQuotaExceededException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a data ingestion job. Amazon Lookout for Equipment returns the job status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDataIngestionJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartDataIngestionJobRequest#builder()}
     * </p>
     *
     * @param startDataIngestionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartDataIngestionJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartDataIngestionJob operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.StartDataIngestionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StartDataIngestionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDataIngestionJobResponse startDataIngestionJob(
            Consumer<StartDataIngestionJobRequest.Builder> startDataIngestionJobRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ServiceQuotaExceededException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return startDataIngestionJob(StartDataIngestionJobRequest.builder().applyMutation(startDataIngestionJobRequest).build());
    }

    /**
     * <p>
     * Starts an inference scheduler.
     * </p>
     *
     * @param startInferenceSchedulerRequest
     * @return Result of the StartInferenceScheduler operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.StartInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StartInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default StartInferenceSchedulerResponse startInferenceScheduler(StartInferenceSchedulerRequest startInferenceSchedulerRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartInferenceSchedulerRequest.Builder} avoiding
     * the need to create one manually via {@link StartInferenceSchedulerRequest#builder()}
     * </p>
     *
     * @param startInferenceSchedulerRequest
     *        A {@link Consumer} that will call methods on {@link StartInferenceSchedulerRequest.Builder} to create a
     *        request.
     * @return Result of the StartInferenceScheduler operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.StartInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StartInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default StartInferenceSchedulerResponse startInferenceScheduler(
            Consumer<StartInferenceSchedulerRequest.Builder> startInferenceSchedulerRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, LookoutEquipmentException {
        return startInferenceScheduler(StartInferenceSchedulerRequest.builder().applyMutation(startInferenceSchedulerRequest)
                .build());
    }

    /**
     * <p>
     * Stops an inference scheduler.
     * </p>
     *
     * @param stopInferenceSchedulerRequest
     * @return Result of the StopInferenceScheduler operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.StopInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StopInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default StopInferenceSchedulerResponse stopInferenceScheduler(StopInferenceSchedulerRequest stopInferenceSchedulerRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopInferenceSchedulerRequest.Builder} avoiding the
     * need to create one manually via {@link StopInferenceSchedulerRequest#builder()}
     * </p>
     *
     * @param stopInferenceSchedulerRequest
     *        A {@link Consumer} that will call methods on {@link StopInferenceSchedulerRequest.Builder} to create a
     *        request.
     * @return Result of the StopInferenceScheduler operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.StopInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StopInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default StopInferenceSchedulerResponse stopInferenceScheduler(
            Consumer<StopInferenceSchedulerRequest.Builder> stopInferenceSchedulerRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, LookoutEquipmentException {
        return stopInferenceScheduler(StopInferenceSchedulerRequest.builder().applyMutation(stopInferenceSchedulerRequest)
                .build());
    }

    /**
     * <p>
     * Associates a given tag to a resource in your account. A tag is a key-value pair which can be added to an Amazon
     * Lookout for Equipment resource as metadata. Tags can be used for organizing your resources as well as helping you
     * to search and filter by tag. Multiple tags can be added to a resource, either when you create it, or later. Up to
     * 50 tags can be associated with each resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a given tag to a resource in your account. A tag is a key-value pair which can be added to an Amazon
     * Lookout for Equipment resource as metadata. Tags can be used for organizing your resources as well as helping you
     * to search and filter by tag. Multiple tags can be added to a resource, either when you create it, or later. Up to
     * 50 tags can be associated with each resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ServiceQuotaExceededException
     *         Resource limitations have been exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a specific tag from a given resource. The tag is specified by its key.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a specific tag from a given resource. The tag is specified by its key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Sets the active model version for a given machine learning model.
     * </p>
     *
     * @param updateActiveModelVersionRequest
     * @return Result of the UpdateActiveModelVersion operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.UpdateActiveModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateActiveModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateActiveModelVersionResponse updateActiveModelVersion(
            UpdateActiveModelVersionRequest updateActiveModelVersionRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the active model version for a given machine learning model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateActiveModelVersionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateActiveModelVersionRequest#builder()}
     * </p>
     *
     * @param updateActiveModelVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateActiveModelVersionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateActiveModelVersion operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.UpdateActiveModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateActiveModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateActiveModelVersionResponse updateActiveModelVersion(
            Consumer<UpdateActiveModelVersionRequest.Builder> updateActiveModelVersionRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, LookoutEquipmentException {
        return updateActiveModelVersion(UpdateActiveModelVersionRequest.builder().applyMutation(updateActiveModelVersionRequest)
                .build());
    }

    /**
     * <p>
     * Updates an inference scheduler.
     * </p>
     *
     * @param updateInferenceSchedulerRequest
     * @return Result of the UpdateInferenceScheduler operation returned by the service.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.UpdateInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInferenceSchedulerResponse updateInferenceScheduler(
            UpdateInferenceSchedulerRequest updateInferenceSchedulerRequest) throws ConflictException, ResourceNotFoundException,
            ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an inference scheduler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInferenceSchedulerRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateInferenceSchedulerRequest#builder()}
     * </p>
     *
     * @param updateInferenceSchedulerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInferenceSchedulerRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateInferenceScheduler operation returned by the service.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.UpdateInferenceScheduler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateInferenceScheduler"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInferenceSchedulerResponse updateInferenceScheduler(
            Consumer<UpdateInferenceSchedulerRequest.Builder> updateInferenceSchedulerRequest) throws ConflictException,
            ResourceNotFoundException, ValidationException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, LookoutEquipmentException {
        return updateInferenceScheduler(UpdateInferenceSchedulerRequest.builder().applyMutation(updateInferenceSchedulerRequest)
                .build());
    }

    /**
     * <p>
     * Updates the label group.
     * </p>
     *
     * @param updateLabelGroupRequest
     * @return Result of the UpdateLabelGroup operation returned by the service.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.UpdateLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLabelGroupResponse updateLabelGroup(UpdateLabelGroupRequest updateLabelGroupRequest) throws ConflictException,
            ResourceNotFoundException, ValidationException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, LookoutEquipmentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the label group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLabelGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateLabelGroupRequest#builder()}
     * </p>
     *
     * @param updateLabelGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLabelGroupRequest.Builder} to create a request.
     * @return Result of the UpdateLabelGroup operation returned by the service.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ResourceNotFoundException
     *         The resource requested could not be found. Verify the resource ID and retry your request.
     * @throws ValidationException
     *         The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web
     *         Services service that's being utilized.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have access to the resource.
     * @throws InternalServerException
     *         Processing of the request has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutEquipmentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutEquipmentClient.UpdateLabelGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateLabelGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLabelGroupResponse updateLabelGroup(Consumer<UpdateLabelGroupRequest.Builder> updateLabelGroupRequest)
            throws ConflictException, ResourceNotFoundException, ValidationException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutEquipmentException {
        return updateLabelGroup(UpdateLabelGroupRequest.builder().applyMutation(updateLabelGroupRequest).build());
    }

    /**
     * Create a {@link LookoutEquipmentClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LookoutEquipmentClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LookoutEquipmentClient}.
     */
    static LookoutEquipmentClientBuilder builder() {
        return new DefaultLookoutEquipmentClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default LookoutEquipmentServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
