/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKeyResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, CreateKeyResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(CreateKeyResponse.getter(CreateKeyResponse::createTime)).setter(CreateKeyResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(CreateKeyResponse.getter(CreateKeyResponse::key)).setter(CreateKeyResponse.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyArn").getter(CreateKeyResponse.getter(CreateKeyResponse::keyArn)).setter(CreateKeyResponse.setter(Builder::keyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyArn").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(CreateKeyResponse.getter(CreateKeyResponse::keyName)).setter(CreateKeyResponse.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, KEY_FIELD, KEY_ARN_FIELD, KEY_NAME_FIELD));
    private final Instant createTime;
    private final String key;
    private final String keyArn;
    private final String keyName;

    private CreateKeyResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.key = builder.key;
        this.keyArn = builder.keyArn;
        this.keyName = builder.keyName;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final String key() {
        return this.key;
    }

    public final String keyArn() {
        return this.keyArn;
    }

    public final String keyName() {
        return this.keyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyResponse)) {
            return false;
        }
        CreateKeyResponse other = (CreateKeyResponse)((Object)obj);
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.keyArn(), other.keyArn()) && Objects.equals(this.keyName(), other.keyName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKeyResponse").add("CreateTime", (Object)this.createTime()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).add("KeyArn", (Object)this.keyArn()).add("KeyName", (Object)this.keyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "KeyArn": {
                return Optional.ofNullable(clazz.cast(this.keyArn()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKeyResponse, T> g) {
        return obj -> g.apply((CreateKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private Instant createTime;
        private String key;
        private String keyArn;
        private String keyName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyResponse model) {
            super(model);
            this.createTime(model.createTime);
            this.key(model.key);
            this.keyArn(model.keyArn);
            this.keyName(model.keyName);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getKeyArn() {
            return this.keyArn;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        @Override
        public CreateKeyResponse build() {
            return new CreateKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKeyResponse> {
        public Builder createTime(Instant var1);

        public Builder key(String var1);

        public Builder keyArn(String var1);

        public Builder keyName(String var1);
    }
}

