/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.GeofenceGeometry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGeofenceResponseEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListGeofenceResponseEntry> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(ListGeofenceResponseEntry.getter(ListGeofenceResponseEntry::createTime)).setter(ListGeofenceResponseEntry.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> GEOFENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeofenceId").getter(ListGeofenceResponseEntry.getter(ListGeofenceResponseEntry::geofenceId)).setter(ListGeofenceResponseEntry.setter(Builder::geofenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceId").build()}).build();
    private static final SdkField<GeofenceGeometry> GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Geometry").getter(ListGeofenceResponseEntry.getter(ListGeofenceResponseEntry::geometry)).setter(ListGeofenceResponseEntry.setter(Builder::geometry)).constructor(GeofenceGeometry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListGeofenceResponseEntry.getter(ListGeofenceResponseEntry::status)).setter(ListGeofenceResponseEntry.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(ListGeofenceResponseEntry.getter(ListGeofenceResponseEntry::updateTime)).setter(ListGeofenceResponseEntry.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, GEOFENCE_ID_FIELD, GEOMETRY_FIELD, STATUS_FIELD, UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createTime;
    private final String geofenceId;
    private final GeofenceGeometry geometry;
    private final String status;
    private final Instant updateTime;

    private ListGeofenceResponseEntry(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.geofenceId = builder.geofenceId;
        this.geometry = builder.geometry;
        this.status = builder.status;
        this.updateTime = builder.updateTime;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final String geofenceId() {
        return this.geofenceId;
    }

    public final GeofenceGeometry geometry() {
        return this.geometry;
    }

    public final String status() {
        return this.status;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.geofenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometry());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeofenceResponseEntry)) {
            return false;
        }
        ListGeofenceResponseEntry other = (ListGeofenceResponseEntry)obj;
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.geofenceId(), other.geofenceId()) && Objects.equals(this.geometry(), other.geometry()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"ListGeofenceResponseEntry").add("CreateTime", (Object)this.createTime()).add("GeofenceId", (Object)this.geofenceId()).add("Geometry", (Object)this.geometry()).add("Status", (Object)this.status()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "GeofenceId": {
                return Optional.ofNullable(clazz.cast(this.geofenceId()));
            }
            case "Geometry": {
                return Optional.ofNullable(clazz.cast(this.geometry()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGeofenceResponseEntry, T> g) {
        return obj -> g.apply((ListGeofenceResponseEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createTime;
        private String geofenceId;
        private GeofenceGeometry geometry;
        private String status;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeofenceResponseEntry model) {
            this.createTime(model.createTime);
            this.geofenceId(model.geofenceId);
            this.geometry(model.geometry);
            this.status(model.status);
            this.updateTime(model.updateTime);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getGeofenceId() {
            return this.geofenceId;
        }

        public final void setGeofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
        }

        @Override
        public final Builder geofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
            return this;
        }

        public final GeofenceGeometry.Builder getGeometry() {
            return this.geometry != null ? this.geometry.toBuilder() : null;
        }

        public final void setGeometry(GeofenceGeometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(GeofenceGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public ListGeofenceResponseEntry build() {
            return new ListGeofenceResponseEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListGeofenceResponseEntry> {
        public Builder createTime(Instant var1);

        public Builder geofenceId(String var1);

        public Builder geometry(GeofenceGeometry var1);

        default public Builder geometry(Consumer<GeofenceGeometry.Builder> geometry) {
            return this.geometry((GeofenceGeometry)((GeofenceGeometry.Builder)GeofenceGeometry.builder().applyMutation(geometry)).build());
        }

        public Builder status(String var1);

        public Builder updateTime(Instant var1);
    }
}

