/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.CalculateRouteSummary;
import software.amazon.awssdk.services.location.model.Leg;
import software.amazon.awssdk.services.location.model.LegListCopier;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculateRouteResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, CalculateRouteResponse> {
    private static final SdkField<List<Leg>> LEGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Legs").getter(CalculateRouteResponse.getter(CalculateRouteResponse::legs)).setter(CalculateRouteResponse.setter(Builder::legs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Leg::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CalculateRouteSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Summary").getter(CalculateRouteResponse.getter(CalculateRouteResponse::summary)).setter(CalculateRouteResponse.setter(Builder::summary)).constructor(CalculateRouteSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEGS_FIELD, SUMMARY_FIELD));
    private final List<Leg> legs;
    private final CalculateRouteSummary summary;

    private CalculateRouteResponse(BuilderImpl builder) {
        super(builder);
        this.legs = builder.legs;
        this.summary = builder.summary;
    }

    public final boolean hasLegs() {
        return this.legs != null && !(this.legs instanceof SdkAutoConstructList);
    }

    public final List<Leg> legs() {
        return this.legs;
    }

    public final CalculateRouteSummary summary() {
        return this.summary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLegs() ? this.legs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteResponse)) {
            return false;
        }
        CalculateRouteResponse other = (CalculateRouteResponse)((Object)obj);
        return this.hasLegs() == other.hasLegs() && Objects.equals(this.legs(), other.legs()) && Objects.equals(this.summary(), other.summary());
    }

    public final String toString() {
        return ToString.builder((String)"CalculateRouteResponse").add("Legs", this.hasLegs() ? this.legs() : null).add("Summary", (Object)this.summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Legs": {
                return Optional.ofNullable(clazz.cast(this.legs()));
            }
            case "Summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteResponse, T> g) {
        return obj -> g.apply((CalculateRouteResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private List<Leg> legs = DefaultSdkAutoConstructList.getInstance();
        private CalculateRouteSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteResponse model) {
            super(model);
            this.legs(model.legs);
            this.summary(model.summary);
        }

        public final List<Leg.Builder> getLegs() {
            List<Leg.Builder> result = LegListCopier.copyToBuilder(this.legs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLegs(Collection<Leg.BuilderImpl> legs) {
            this.legs = LegListCopier.copyFromBuilder(legs);
        }

        @Override
        public final Builder legs(Collection<Leg> legs) {
            this.legs = LegListCopier.copy(legs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder legs(Leg ... legs) {
            this.legs(Arrays.asList(legs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder legs(Consumer<Leg.Builder> ... legs) {
            this.legs(Stream.of(legs).map(c -> (Leg)((Leg.Builder)Leg.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CalculateRouteSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        public final void setSummary(CalculateRouteSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(CalculateRouteSummary summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public CalculateRouteResponse build() {
            return new CalculateRouteResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CalculateRouteResponse> {
        public Builder legs(Collection<Leg> var1);

        public Builder legs(Leg ... var1);

        public Builder legs(Consumer<Leg.Builder> ... var1);

        public Builder summary(CalculateRouteSummary var1);

        default public Builder summary(Consumer<CalculateRouteSummary.Builder> summary) {
            return this.summary((CalculateRouteSummary)((CalculateRouteSummary.Builder)CalculateRouteSummary.builder().applyMutation(summary)).build());
        }
    }
}

