/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BatchItemErrorCode {
    ACCESS_DENIED_ERROR("AccessDeniedError"),
    CONFLICT_ERROR("ConflictError"),
    INTERNAL_SERVER_ERROR("InternalServerError"),
    RESOURCE_NOT_FOUND_ERROR("ResourceNotFoundError"),
    THROTTLING_ERROR("ThrottlingError"),
    VALIDATION_ERROR("ValidationError"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BatchItemErrorCode> VALUE_MAP;
    private final String value;

    private BatchItemErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BatchItemErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BatchItemErrorCode> knownValues() {
        EnumSet<BatchItemErrorCode> knownValues = EnumSet.allOf(BatchItemErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BatchItemErrorCode.class, BatchItemErrorCode::toString);
    }
}

