/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGuiSessionAccessDetailsResponse extends LightsailResponse implements
        ToCopyableBuilder<CreateGuiSessionAccessDetailsResponse.Builder, CreateGuiSessionAccessDetailsResponse> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceName").getter(getter(CreateGuiSessionAccessDetailsResponse::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateGuiSessionAccessDetailsResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Integer> PERCENTAGE_COMPLETE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("percentageComplete").getter(getter(CreateGuiSessionAccessDetailsResponse::percentageComplete))
            .setter(setter(Builder::percentageComplete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentageComplete").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(CreateGuiSessionAccessDetailsResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<List<Session>> SESSIONS_FIELD = SdkField
            .<List<Session>> builder(MarshallingType.LIST)
            .memberName("sessions")
            .getter(getter(CreateGuiSessionAccessDetailsResponse::sessions))
            .setter(setter(Builder::sessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Session> builder(MarshallingType.SDK_POJO)
                                            .constructor(Session::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD,
            STATUS_FIELD, PERCENTAGE_COMPLETE_FIELD, FAILURE_REASON_FIELD, SESSIONS_FIELD));

    private final String resourceName;

    private final String status;

    private final Integer percentageComplete;

    private final String failureReason;

    private final List<Session> sessions;

    private CreateGuiSessionAccessDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceName = builder.resourceName;
        this.status = builder.status;
        this.percentageComplete = builder.percentageComplete;
        this.failureReason = builder.failureReason;
        this.sessions = builder.sessions;
    }

    /**
     * <p>
     * The resource name.
     * </p>
     * 
     * @return The resource name.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The status of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the operation.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the operation.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The percentage of completion for the operation.
     * </p>
     * 
     * @return The percentage of completion for the operation.
     */
    public final Integer percentageComplete() {
        return percentageComplete;
    }

    /**
     * <p>
     * The reason the operation failed.
     * </p>
     * 
     * @return The reason the operation failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sessions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSessions() {
        return sessions != null && !(sessions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns information about the specified NICE DCV GUI session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessions} method.
     * </p>
     * 
     * @return Returns information about the specified NICE DCV GUI session.
     */
    public final List<Session> sessions() {
        return sessions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(percentageComplete());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasSessions() ? sessions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGuiSessionAccessDetailsResponse)) {
            return false;
        }
        CreateGuiSessionAccessDetailsResponse other = (CreateGuiSessionAccessDetailsResponse) obj;
        return Objects.equals(resourceName(), other.resourceName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(percentageComplete(), other.percentageComplete())
                && Objects.equals(failureReason(), other.failureReason()) && hasSessions() == other.hasSessions()
                && Objects.equals(sessions(), other.sessions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGuiSessionAccessDetailsResponse").add("ResourceName", resourceName())
                .add("Status", statusAsString()).add("PercentageComplete", percentageComplete())
                .add("FailureReason", failureReason()).add("Sessions", hasSessions() ? sessions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "percentageComplete":
            return Optional.ofNullable(clazz.cast(percentageComplete()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "sessions":
            return Optional.ofNullable(clazz.cast(sessions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGuiSessionAccessDetailsResponse, T> g) {
        return obj -> g.apply((CreateGuiSessionAccessDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateGuiSessionAccessDetailsResponse> {
        /**
         * <p>
         * The resource name.
         * </p>
         * 
         * @param resourceName
         *        The resource name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The status of the operation.
         * </p>
         * 
         * @param status
         *        The status of the operation.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the operation.
         * </p>
         * 
         * @param status
         *        The status of the operation.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The percentage of completion for the operation.
         * </p>
         * 
         * @param percentageComplete
         *        The percentage of completion for the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentageComplete(Integer percentageComplete);

        /**
         * <p>
         * The reason the operation failed.
         * </p>
         * 
         * @param failureReason
         *        The reason the operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Returns information about the specified NICE DCV GUI session.
         * </p>
         * 
         * @param sessions
         *        Returns information about the specified NICE DCV GUI session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessions(Collection<Session> sessions);

        /**
         * <p>
         * Returns information about the specified NICE DCV GUI session.
         * </p>
         * 
         * @param sessions
         *        Returns information about the specified NICE DCV GUI session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessions(Session... sessions);

        /**
         * <p>
         * Returns information about the specified NICE DCV GUI session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.Session.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lightsail.model.Session#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.Session.Builder#build()} is called immediately and its
         * result is passed to {@link #sessions(List<Session>)}.
         * 
         * @param sessions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.Session.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessions(java.util.Collection<Session>)
         */
        Builder sessions(Consumer<Session.Builder>... sessions);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private String resourceName;

        private String status;

        private Integer percentageComplete;

        private String failureReason;

        private List<Session> sessions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGuiSessionAccessDetailsResponse model) {
            super(model);
            resourceName(model.resourceName);
            status(model.status);
            percentageComplete(model.percentageComplete);
            failureReason(model.failureReason);
            sessions(model.sessions);
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getPercentageComplete() {
            return percentageComplete;
        }

        public final void setPercentageComplete(Integer percentageComplete) {
            this.percentageComplete = percentageComplete;
        }

        @Override
        public final Builder percentageComplete(Integer percentageComplete) {
            this.percentageComplete = percentageComplete;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final List<Session.Builder> getSessions() {
            List<Session.Builder> result = SessionsCopier.copyToBuilder(this.sessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessions(Collection<Session.BuilderImpl> sessions) {
            this.sessions = SessionsCopier.copyFromBuilder(sessions);
        }

        @Override
        public final Builder sessions(Collection<Session> sessions) {
            this.sessions = SessionsCopier.copy(sessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Session... sessions) {
            sessions(Arrays.asList(sessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Consumer<Session.Builder>... sessions) {
            sessions(Stream.of(sessions).map(c -> Session.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateGuiSessionAccessDetailsResponse build() {
            return new CreateGuiSessionAccessDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
