/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBucketRequest extends LightsailRequest implements
        ToCopyableBuilder<DeleteBucketRequest.Builder, DeleteBucketRequest> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(DeleteBucketRequest::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<Boolean> FORCE_DELETE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("forceDelete").getter(getter(DeleteBucketRequest::forceDelete)).setter(setter(Builder::forceDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceDelete").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            FORCE_DELETE_FIELD));

    private final String bucketName;

    private final Boolean forceDelete;

    private DeleteBucketRequest(BuilderImpl builder) {
        super(builder);
        this.bucketName = builder.bucketName;
        this.forceDelete = builder.forceDelete;
    }

    /**
     * <p>
     * The name of the bucket to delete.
     * </p>
     * <p>
     * Use the <a
     * href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBuckets.html">GetBuckets</a> action
     * to get a list of bucket names that you can specify.
     * </p>
     * 
     * @return The name of the bucket to delete.</p>
     *         <p>
     *         Use the <a
     *         href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBuckets.html">GetBuckets</a>
     *         action to get a list of bucket names that you can specify.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * A Boolean value that indicates whether to force delete the bucket.
     * </p>
     * <p>
     * You must force delete the bucket if it has one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The bucket is the origin of a distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * The bucket has instances that were granted access to it using the <a
     * href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_SetResourceAccessForBucket.html"
     * >SetResourceAccessForBucket</a> action.
     * </p>
     * </li>
     * <li>
     * <p>
     * The bucket has objects.
     * </p>
     * </li>
     * <li>
     * <p>
     * The bucket has access keys.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * Force deleting a bucket might impact other resources that rely on the bucket, such as instances, distributions,
     * or software that use the issued access keys.
     * </p>
     * </important>
     * 
     * @return A Boolean value that indicates whether to force delete the bucket.</p>
     *         <p>
     *         You must force delete the bucket if it has one of the following conditions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The bucket is the origin of a distribution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The bucket has instances that were granted access to it using the <a href=
     *         "https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_SetResourceAccessForBucket.html"
     *         >SetResourceAccessForBucket</a> action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The bucket has objects.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The bucket has access keys.
     *         </p>
     *         </li>
     *         </ul>
     *         <important>
     *         <p>
     *         Force deleting a bucket might impact other resources that rely on the bucket, such as instances,
     *         distributions, or software that use the issued access keys.
     *         </p>
     */
    public final Boolean forceDelete() {
        return forceDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(forceDelete());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBucketRequest)) {
            return false;
        }
        DeleteBucketRequest other = (DeleteBucketRequest) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(forceDelete(), other.forceDelete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBucketRequest").add("BucketName", bucketName()).add("ForceDelete", forceDelete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "forceDelete":
            return Optional.ofNullable(clazz.cast(forceDelete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteBucketRequest, T> g) {
        return obj -> g.apply((DeleteBucketRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBucketRequest> {
        /**
         * <p>
         * The name of the bucket to delete.
         * </p>
         * <p>
         * Use the <a
         * href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBuckets.html">GetBuckets</a>
         * action to get a list of bucket names that you can specify.
         * </p>
         * 
         * @param bucketName
         *        The name of the bucket to delete.</p>
         *        <p>
         *        Use the <a
         *        href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBuckets.html">GetBuckets
         *        </a> action to get a list of bucket names that you can specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * A Boolean value that indicates whether to force delete the bucket.
         * </p>
         * <p>
         * You must force delete the bucket if it has one of the following conditions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The bucket is the origin of a distribution.
         * </p>
         * </li>
         * <li>
         * <p>
         * The bucket has instances that were granted access to it using the <a
         * href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_SetResourceAccessForBucket.html"
         * >SetResourceAccessForBucket</a> action.
         * </p>
         * </li>
         * <li>
         * <p>
         * The bucket has objects.
         * </p>
         * </li>
         * <li>
         * <p>
         * The bucket has access keys.
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * Force deleting a bucket might impact other resources that rely on the bucket, such as instances,
         * distributions, or software that use the issued access keys.
         * </p>
         * </important>
         * 
         * @param forceDelete
         *        A Boolean value that indicates whether to force delete the bucket.</p>
         *        <p>
         *        You must force delete the bucket if it has one of the following conditions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The bucket is the origin of a distribution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The bucket has instances that were granted access to it using the <a href=
         *        "https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_SetResourceAccessForBucket.html"
         *        >SetResourceAccessForBucket</a> action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The bucket has objects.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The bucket has access keys.
         *        </p>
         *        </li>
         *        </ul>
         *        <important>
         *        <p>
         *        Force deleting a bucket might impact other resources that rely on the bucket, such as instances,
         *        distributions, or software that use the issued access keys.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceDelete(Boolean forceDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String bucketName;

        private Boolean forceDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBucketRequest model) {
            super(model);
            bucketName(model.bucketName);
            forceDelete(model.forceDelete);
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final Boolean getForceDelete() {
            return forceDelete;
        }

        public final void setForceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
        }

        @Override
        public final Builder forceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBucketRequest build() {
            return new DeleteBucketRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
