/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInstancesFromSnapshotRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateInstancesFromSnapshotRequest.Builder, CreateInstancesFromSnapshotRequest> {
    private static final SdkField<List<String>> INSTANCE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("instanceNames")
            .getter(getter(CreateInstancesFromSnapshotRequest::instanceNames))
            .setter(setter(Builder::instanceNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<DiskMap>>> ATTACHED_DISK_MAPPING_FIELD = SdkField
            .<Map<String, List<DiskMap>>> builder(MarshallingType.MAP)
            .memberName("attachedDiskMapping")
            .getter(getter(CreateInstancesFromSnapshotRequest::attachedDiskMapping))
            .setter(setter(Builder::attachedDiskMapping))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedDiskMapping").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<DiskMap>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<DiskMap> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(DiskMap::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(CreateInstancesFromSnapshotRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> INSTANCE_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceSnapshotName").getter(getter(CreateInstancesFromSnapshotRequest::instanceSnapshotName))
            .setter(setter(Builder::instanceSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceSnapshotName").build())
            .build();

    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bundleId").getter(getter(CreateInstancesFromSnapshotRequest::bundleId))
            .setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()).build();

    private static final SdkField<String> USER_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userData").getter(getter(CreateInstancesFromSnapshotRequest::userData))
            .setter(setter(Builder::userData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userData").build()).build();

    private static final SdkField<String> KEY_PAIR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyPairName").getter(getter(CreateInstancesFromSnapshotRequest::keyPairName))
            .setter(setter(Builder::keyPairName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPairName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateInstancesFromSnapshotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AddOnRequest>> ADD_ONS_FIELD = SdkField
            .<List<AddOnRequest>> builder(MarshallingType.LIST)
            .memberName("addOns")
            .getter(getter(CreateInstancesFromSnapshotRequest::addOns))
            .setter(setter(Builder::addOns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddOnRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddOnRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddressType").getter(getter(CreateInstancesFromSnapshotRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()).build();

    private static final SdkField<String> SOURCE_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceInstanceName").getter(getter(CreateInstancesFromSnapshotRequest::sourceInstanceName))
            .setter(setter(Builder::sourceInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceInstanceName").build())
            .build();

    private static final SdkField<String> RESTORE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restoreDate").getter(getter(CreateInstancesFromSnapshotRequest::restoreDate))
            .setter(setter(Builder::restoreDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restoreDate").build()).build();

    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_AUTO_SNAPSHOT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useLatestRestorableAutoSnapshot")
            .getter(getter(CreateInstancesFromSnapshotRequest::useLatestRestorableAutoSnapshot))
            .setter(setter(Builder::useLatestRestorableAutoSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useLatestRestorableAutoSnapshot")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAMES_FIELD,
            ATTACHED_DISK_MAPPING_FIELD, AVAILABILITY_ZONE_FIELD, INSTANCE_SNAPSHOT_NAME_FIELD, BUNDLE_ID_FIELD, USER_DATA_FIELD,
            KEY_PAIR_NAME_FIELD, TAGS_FIELD, ADD_ONS_FIELD, IP_ADDRESS_TYPE_FIELD, SOURCE_INSTANCE_NAME_FIELD,
            RESTORE_DATE_FIELD, USE_LATEST_RESTORABLE_AUTO_SNAPSHOT_FIELD));

    private final List<String> instanceNames;

    private final Map<String, List<DiskMap>> attachedDiskMapping;

    private final String availabilityZone;

    private final String instanceSnapshotName;

    private final String bundleId;

    private final String userData;

    private final String keyPairName;

    private final List<Tag> tags;

    private final List<AddOnRequest> addOns;

    private final String ipAddressType;

    private final String sourceInstanceName;

    private final String restoreDate;

    private final Boolean useLatestRestorableAutoSnapshot;

    private CreateInstancesFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.instanceNames = builder.instanceNames;
        this.attachedDiskMapping = builder.attachedDiskMapping;
        this.availabilityZone = builder.availabilityZone;
        this.instanceSnapshotName = builder.instanceSnapshotName;
        this.bundleId = builder.bundleId;
        this.userData = builder.userData;
        this.keyPairName = builder.keyPairName;
        this.tags = builder.tags;
        this.addOns = builder.addOns;
        this.ipAddressType = builder.ipAddressType;
        this.sourceInstanceName = builder.sourceInstanceName;
        this.restoreDate = builder.restoreDate;
        this.useLatestRestorableAutoSnapshot = builder.useLatestRestorableAutoSnapshot;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceNames() {
        return instanceNames != null && !(instanceNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names for your new instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceNames} method.
     * </p>
     * 
     * @return The names for your new instances.
     */
    public final List<String> instanceNames() {
        return instanceNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttachedDiskMapping property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachedDiskMapping() {
        return attachedDiskMapping != null && !(attachedDiskMapping instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object containing information about one or more disk mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachedDiskMapping} method.
     * </p>
     * 
     * @return An object containing information about one or more disk mappings.
     */
    public final Map<String, List<DiskMap>> attachedDiskMapping() {
        return attachedDiskMapping;
    }

    /**
     * <p>
     * The Availability Zone where you want to create your instances. Use the following formatting:
     * <code>us-east-2a</code> (case sensitive). You can get a list of Availability Zones by using the <a
     * href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a>
     * operation. Be sure to add the <code>include Availability Zones</code> parameter to your request.
     * </p>
     * 
     * @return The Availability Zone where you want to create your instances. Use the following formatting:
     *         <code>us-east-2a</code> (case sensitive). You can get a list of Availability Zones by using the <a
     *         href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a>
     *         operation. Be sure to add the <code>include Availability Zones</code> parameter to your request.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The name of the instance snapshot on which you are basing your new instances. Use the get instance snapshots
     * operation to return information about your existing snapshots.
     * </p>
     * <p>
     * Constraint:
     * </p>
     * <ul>
     * <li>
     * <p>
     * This parameter cannot be defined together with the <code>source instance name</code> parameter. The
     * <code>instance snapshot name</code> and <code>source instance name</code> parameters are mutually exclusive.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the instance snapshot on which you are basing your new instances. Use the get instance
     *         snapshots operation to return information about your existing snapshots.</p>
     *         <p>
     *         Constraint:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This parameter cannot be defined together with the <code>source instance name</code> parameter. The
     *         <code>instance snapshot name</code> and <code>source instance name</code> parameters are mutually
     *         exclusive.
     *         </p>
     *         </li>
     */
    public final String instanceSnapshotName() {
        return instanceSnapshotName;
    }

    /**
     * <p>
     * The bundle of specification information for your virtual private server (or <i>instance</i>), including the
     * pricing plan (e.g., <code>micro_1_0</code>).
     * </p>
     * 
     * @return The bundle of specification information for your virtual private server (or <i>instance</i>), including
     *         the pricing plan (e.g., <code>micro_1_0</code>).
     */
    public final String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * You can create a launch script that configures a server with additional user data. For example,
     * <code>apt-get -y update</code>.
     * </p>
     * <note>
     * <p>
     * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and
     * CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses <code>pkg</code>. For a
     * complete list, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image"
     * >Amazon Lightsail Developer Guide</a>.
     * </p>
     * </note>
     * 
     * @return You can create a launch script that configures a server with additional user data. For example,
     *         <code>apt-get -y update</code>.</p> <note>
     *         <p>
     *         Depending on the machine image you choose, the command to get software on your instance varies. Amazon
     *         Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
     *         <code>pkg</code>. For a complete list, see the <a
     *         href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image"
     *         >Amazon Lightsail Developer Guide</a>.
     *         </p>
     */
    public final String userData() {
        return userData;
    }

    /**
     * <p>
     * The name for your key pair.
     * </p>
     * 
     * @return The name for your key pair.
     */
    public final String keyPairName() {
        return keyPairName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys and optional values to add to the resource during create.
     * </p>
     * <p>
     * Use the <code>TagResource</code> action to tag a resource after it's created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tag keys and optional values to add to the resource during create.</p>
     *         <p>
     *         Use the <code>TagResource</code> action to tag a resource after it's created.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddOns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddOns() {
        return addOns != null && !(addOns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects representing the add-ons to enable for the new instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddOns} method.
     * </p>
     * 
     * @return An array of objects representing the add-ons to enable for the new instance.
     */
    public final List<AddOnRequest> addOns() {
        return addOns;
    }

    /**
     * <p>
     * The IP address type for the instance.
     * </p>
     * <p>
     * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * </p>
     * <p>
     * The default value is <code>dualstack</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the instance.</p>
     *         <p>
     *         The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     *         </p>
     *         <p>
     *         The default value is <code>dualstack</code>.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type for the instance.
     * </p>
     * <p>
     * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * </p>
     * <p>
     * The default value is <code>dualstack</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the instance.</p>
     *         <p>
     *         The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     *         </p>
     *         <p>
     *         The default value is <code>dualstack</code>.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * The name of the source instance from which the source automatic snapshot was created.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * This parameter cannot be defined together with the <code>instance snapshot name</code> parameter. The
     * <code>source instance name</code> and <code>instance snapshot name</code> parameters are mutually exclusive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the
     * <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Amazon Lightsail Developer Guide</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the source instance from which the source automatic snapshot was created.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This parameter cannot be defined together with the <code>instance snapshot name</code> parameter. The
     *         <code>source instance name</code> and <code>instance snapshot name</code> parameters are mutually
     *         exclusive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Define this parameter only when creating a new instance from an automatic snapshot. For more information,
     *         see the <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     *         >Amazon Lightsail Developer Guide</a>.
     *         </p>
     *         </li>
     */
    public final String sourceInstanceName() {
        return sourceInstanceName;
    }

    /**
     * <p>
     * The date of the automatic snapshot to use for the new instance. Use the <code>get auto snapshots</code> operation
     * to identify the dates of the available automatic snapshots.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be specified in <code>YYYY-MM-DD</code> format.
     * </p>
     * </li>
     * <li>
     * <p>
     * This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code> parameter.
     * The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters are mutually
     * exclusive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the
     * <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Amazon Lightsail Developer Guide</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The date of the automatic snapshot to use for the new instance. Use the <code>get auto snapshots</code>
     *         operation to identify the dates of the available automatic snapshots.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be specified in <code>YYYY-MM-DD</code> format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code>
     *         parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters
     *         are mutually exclusive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Define this parameter only when creating a new instance from an automatic snapshot. For more information,
     *         see the <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     *         >Amazon Lightsail Developer Guide</a>.
     *         </p>
     *         </li>
     */
    public final String restoreDate() {
        return restoreDate;
    }

    /**
     * <p>
     * A Boolean value to indicate whether to use the latest available automatic snapshot.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * This parameter cannot be defined together with the <code>restore date</code> parameter. The
     * <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually exclusive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the
     * <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Amazon Lightsail Developer Guide</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A Boolean value to indicate whether to use the latest available automatic snapshot.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This parameter cannot be defined together with the <code>restore date</code> parameter. The
     *         <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually
     *         exclusive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Define this parameter only when creating a new instance from an automatic snapshot. For more information,
     *         see the <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     *         >Amazon Lightsail Developer Guide</a>.
     *         </p>
     *         </li>
     */
    public final Boolean useLatestRestorableAutoSnapshot() {
        return useLatestRestorableAutoSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceNames() ? instanceNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachedDiskMapping() ? attachedDiskMapping() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(instanceSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(keyPairName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddOns() ? addOns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(restoreDate());
        hashCode = 31 * hashCode + Objects.hashCode(useLatestRestorableAutoSnapshot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesFromSnapshotRequest)) {
            return false;
        }
        CreateInstancesFromSnapshotRequest other = (CreateInstancesFromSnapshotRequest) obj;
        return hasInstanceNames() == other.hasInstanceNames() && Objects.equals(instanceNames(), other.instanceNames())
                && hasAttachedDiskMapping() == other.hasAttachedDiskMapping()
                && Objects.equals(attachedDiskMapping(), other.attachedDiskMapping())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(instanceSnapshotName(), other.instanceSnapshotName())
                && Objects.equals(bundleId(), other.bundleId()) && Objects.equals(userData(), other.userData())
                && Objects.equals(keyPairName(), other.keyPairName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasAddOns() == other.hasAddOns()
                && Objects.equals(addOns(), other.addOns())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString())
                && Objects.equals(sourceInstanceName(), other.sourceInstanceName())
                && Objects.equals(restoreDate(), other.restoreDate())
                && Objects.equals(useLatestRestorableAutoSnapshot(), other.useLatestRestorableAutoSnapshot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInstancesFromSnapshotRequest")
                .add("InstanceNames", hasInstanceNames() ? instanceNames() : null)
                .add("AttachedDiskMapping", hasAttachedDiskMapping() ? attachedDiskMapping() : null)
                .add("AvailabilityZone", availabilityZone()).add("InstanceSnapshotName", instanceSnapshotName())
                .add("BundleId", bundleId()).add("UserData", userData()).add("KeyPairName", keyPairName())
                .add("Tags", hasTags() ? tags() : null).add("AddOns", hasAddOns() ? addOns() : null)
                .add("IpAddressType", ipAddressTypeAsString()).add("SourceInstanceName", sourceInstanceName())
                .add("RestoreDate", restoreDate()).add("UseLatestRestorableAutoSnapshot", useLatestRestorableAutoSnapshot())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceNames":
            return Optional.ofNullable(clazz.cast(instanceNames()));
        case "attachedDiskMapping":
            return Optional.ofNullable(clazz.cast(attachedDiskMapping()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "instanceSnapshotName":
            return Optional.ofNullable(clazz.cast(instanceSnapshotName()));
        case "bundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "userData":
            return Optional.ofNullable(clazz.cast(userData()));
        case "keyPairName":
            return Optional.ofNullable(clazz.cast(keyPairName()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "addOns":
            return Optional.ofNullable(clazz.cast(addOns()));
        case "ipAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "sourceInstanceName":
            return Optional.ofNullable(clazz.cast(sourceInstanceName()));
        case "restoreDate":
            return Optional.ofNullable(clazz.cast(restoreDate()));
        case "useLatestRestorableAutoSnapshot":
            return Optional.ofNullable(clazz.cast(useLatestRestorableAutoSnapshot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInstancesFromSnapshotRequest, T> g) {
        return obj -> g.apply((CreateInstancesFromSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateInstancesFromSnapshotRequest> {
        /**
         * <p>
         * The names for your new instances.
         * </p>
         * 
         * @param instanceNames
         *        The names for your new instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(Collection<String> instanceNames);

        /**
         * <p>
         * The names for your new instances.
         * </p>
         * 
         * @param instanceNames
         *        The names for your new instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(String... instanceNames);

        /**
         * <p>
         * An object containing information about one or more disk mappings.
         * </p>
         * 
         * @param attachedDiskMapping
         *        An object containing information about one or more disk mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedDiskMapping(Map<String, ? extends Collection<DiskMap>> attachedDiskMapping);

        /**
         * <p>
         * The Availability Zone where you want to create your instances. Use the following formatting:
         * <code>us-east-2a</code> (case sensitive). You can get a list of Availability Zones by using the <a
         * href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a>
         * operation. Be sure to add the <code>include Availability Zones</code> parameter to your request.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where you want to create your instances. Use the following formatting:
         *        <code>us-east-2a</code> (case sensitive). You can get a list of Availability Zones by using the <a
         *        href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get
         *        regions</a> operation. Be sure to add the <code>include Availability Zones</code> parameter to your
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The name of the instance snapshot on which you are basing your new instances. Use the get instance snapshots
         * operation to return information about your existing snapshots.
         * </p>
         * <p>
         * Constraint:
         * </p>
         * <ul>
         * <li>
         * <p>
         * This parameter cannot be defined together with the <code>source instance name</code> parameter. The
         * <code>instance snapshot name</code> and <code>source instance name</code> parameters are mutually exclusive.
         * </p>
         * </li>
         * </ul>
         * 
         * @param instanceSnapshotName
         *        The name of the instance snapshot on which you are basing your new instances. Use the get instance
         *        snapshots operation to return information about your existing snapshots.</p>
         *        <p>
         *        Constraint:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This parameter cannot be defined together with the <code>source instance name</code> parameter. The
         *        <code>instance snapshot name</code> and <code>source instance name</code> parameters are mutually
         *        exclusive.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceSnapshotName(String instanceSnapshotName);

        /**
         * <p>
         * The bundle of specification information for your virtual private server (or <i>instance</i>), including the
         * pricing plan (e.g., <code>micro_1_0</code>).
         * </p>
         * 
         * @param bundleId
         *        The bundle of specification information for your virtual private server (or <i>instance</i>),
         *        including the pricing plan (e.g., <code>micro_1_0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * You can create a launch script that configures a server with additional user data. For example,
         * <code>apt-get -y update</code>.
         * </p>
         * <note>
         * <p>
         * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux
         * and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
         * <code>pkg</code>. For a complete list, see the <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image"
         * >Amazon Lightsail Developer Guide</a>.
         * </p>
         * </note>
         * 
         * @param userData
         *        You can create a launch script that configures a server with additional user data. For example,
         *        <code>apt-get -y update</code>.</p> <note>
         *        <p>
         *        Depending on the machine image you choose, the command to get software on your instance varies. Amazon
         *        Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
         *        <code>pkg</code>. For a complete list, see the <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image"
         *        >Amazon Lightsail Developer Guide</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The name for your key pair.
         * </p>
         * 
         * @param keyPairName
         *        The name for your key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairName(String keyPairName);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.lightsail.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * An array of objects representing the add-ons to enable for the new instance.
         * </p>
         * 
         * @param addOns
         *        An array of objects representing the add-ons to enable for the new instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOns(Collection<AddOnRequest> addOns);

        /**
         * <p>
         * An array of objects representing the add-ons to enable for the new instance.
         * </p>
         * 
         * @param addOns
         *        An array of objects representing the add-ons to enable for the new instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOns(AddOnRequest... addOns);

        /**
         * <p>
         * An array of objects representing the add-ons to enable for the new instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.AddOnRequest.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lightsail.model.AddOnRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.AddOnRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #addOns(List<AddOnRequest>)}.
         * 
         * @param addOns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.AddOnRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addOns(java.util.Collection<AddOnRequest>)
         */
        Builder addOns(Consumer<AddOnRequest.Builder>... addOns);

        /**
         * <p>
         * The IP address type for the instance.
         * </p>
         * <p>
         * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * </p>
         * <p>
         * The default value is <code>dualstack</code>.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the instance.</p>
         *        <p>
         *        The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         *        </p>
         *        <p>
         *        The default value is <code>dualstack</code>.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type for the instance.
         * </p>
         * <p>
         * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * </p>
         * <p>
         * The default value is <code>dualstack</code>.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the instance.</p>
         *        <p>
         *        The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         *        </p>
         *        <p>
         *        The default value is <code>dualstack</code>.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * The name of the source instance from which the source automatic snapshot was created.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * This parameter cannot be defined together with the <code>instance snapshot name</code> parameter. The
         * <code>source instance name</code> and <code>instance snapshot name</code> parameters are mutually exclusive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Define this parameter only when creating a new instance from an automatic snapshot. For more information, see
         * the <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         * >Amazon Lightsail Developer Guide</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceInstanceName
         *        The name of the source instance from which the source automatic snapshot was created.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This parameter cannot be defined together with the <code>instance snapshot name</code> parameter. The
         *        <code>source instance name</code> and <code>instance snapshot name</code> parameters are mutually
         *        exclusive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Define this parameter only when creating a new instance from an automatic snapshot. For more
         *        information, see the <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         *        >Amazon Lightsail Developer Guide</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceInstanceName(String sourceInstanceName);

        /**
         * <p>
         * The date of the automatic snapshot to use for the new instance. Use the <code>get auto snapshots</code>
         * operation to identify the dates of the available automatic snapshots.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be specified in <code>YYYY-MM-DD</code> format.
         * </p>
         * </li>
         * <li>
         * <p>
         * This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code>
         * parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters are
         * mutually exclusive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Define this parameter only when creating a new instance from an automatic snapshot. For more information, see
         * the <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         * >Amazon Lightsail Developer Guide</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param restoreDate
         *        The date of the automatic snapshot to use for the new instance. Use the
         *        <code>get auto snapshots</code> operation to identify the dates of the available automatic
         *        snapshots.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be specified in <code>YYYY-MM-DD</code> format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code>
         *        parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code>
         *        parameters are mutually exclusive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Define this parameter only when creating a new instance from an automatic snapshot. For more
         *        information, see the <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         *        >Amazon Lightsail Developer Guide</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreDate(String restoreDate);

        /**
         * <p>
         * A Boolean value to indicate whether to use the latest available automatic snapshot.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * This parameter cannot be defined together with the <code>restore date</code> parameter. The
         * <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually
         * exclusive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Define this parameter only when creating a new instance from an automatic snapshot. For more information, see
         * the <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         * >Amazon Lightsail Developer Guide</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param useLatestRestorableAutoSnapshot
         *        A Boolean value to indicate whether to use the latest available automatic snapshot.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This parameter cannot be defined together with the <code>restore date</code> parameter. The
         *        <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually
         *        exclusive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Define this parameter only when creating a new instance from an automatic snapshot. For more
         *        information, see the <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         *        >Amazon Lightsail Developer Guide</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private List<String> instanceNames = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<DiskMap>> attachedDiskMapping = DefaultSdkAutoConstructMap.getInstance();

        private String availabilityZone;

        private String instanceSnapshotName;

        private String bundleId;

        private String userData;

        private String keyPairName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<AddOnRequest> addOns = DefaultSdkAutoConstructList.getInstance();

        private String ipAddressType;

        private String sourceInstanceName;

        private String restoreDate;

        private Boolean useLatestRestorableAutoSnapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstancesFromSnapshotRequest model) {
            super(model);
            instanceNames(model.instanceNames);
            attachedDiskMapping(model.attachedDiskMapping);
            availabilityZone(model.availabilityZone);
            instanceSnapshotName(model.instanceSnapshotName);
            bundleId(model.bundleId);
            userData(model.userData);
            keyPairName(model.keyPairName);
            tags(model.tags);
            addOns(model.addOns);
            ipAddressType(model.ipAddressType);
            sourceInstanceName(model.sourceInstanceName);
            restoreDate(model.restoreDate);
            useLatestRestorableAutoSnapshot(model.useLatestRestorableAutoSnapshot);
        }

        public final Collection<String> getInstanceNames() {
            if (instanceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceNames;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String... instanceNames) {
            instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        public final Map<String, List<DiskMap.Builder>> getAttachedDiskMapping() {
            Map<String, List<DiskMap.Builder>> result = AttachedDiskMapCopier.copyToBuilder(this.attachedDiskMapping);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAttachedDiskMapping(Map<String, ? extends Collection<DiskMap.BuilderImpl>> attachedDiskMapping) {
            this.attachedDiskMapping = AttachedDiskMapCopier.copyFromBuilder(attachedDiskMapping);
        }

        @Override
        public final Builder attachedDiskMapping(Map<String, ? extends Collection<DiskMap>> attachedDiskMapping) {
            this.attachedDiskMapping = AttachedDiskMapCopier.copy(attachedDiskMapping);
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getInstanceSnapshotName() {
            return instanceSnapshotName;
        }

        public final void setInstanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
        }

        @Override
        public final Builder instanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
            return this;
        }

        public final String getBundleId() {
            return bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getUserData() {
            return userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final String getKeyPairName() {
            return keyPairName;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AddOnRequest.Builder> getAddOns() {
            List<AddOnRequest.Builder> result = AddOnRequestListCopier.copyToBuilder(this.addOns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOns(Collection<AddOnRequest.BuilderImpl> addOns) {
            this.addOns = AddOnRequestListCopier.copyFromBuilder(addOns);
        }

        @Override
        public final Builder addOns(Collection<AddOnRequest> addOns) {
            this.addOns = AddOnRequestListCopier.copy(addOns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(AddOnRequest... addOns) {
            addOns(Arrays.asList(addOns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(Consumer<AddOnRequest.Builder>... addOns) {
            addOns(Stream.of(addOns).map(c -> AddOnRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getSourceInstanceName() {
            return sourceInstanceName;
        }

        public final void setSourceInstanceName(String sourceInstanceName) {
            this.sourceInstanceName = sourceInstanceName;
        }

        @Override
        public final Builder sourceInstanceName(String sourceInstanceName) {
            this.sourceInstanceName = sourceInstanceName;
            return this;
        }

        public final String getRestoreDate() {
            return restoreDate;
        }

        public final void setRestoreDate(String restoreDate) {
            this.restoreDate = restoreDate;
        }

        @Override
        public final Builder restoreDate(String restoreDate) {
            this.restoreDate = restoreDate;
            return this;
        }

        public final Boolean getUseLatestRestorableAutoSnapshot() {
            return useLatestRestorableAutoSnapshot;
        }

        public final void setUseLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot) {
            this.useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot;
        }

        @Override
        public final Builder useLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot) {
            this.useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstancesFromSnapshotRequest build() {
            return new CreateInstancesFromSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
