/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details discovered information about a running instance using Linux subscriptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Instance implements SdkPojo, Serializable, ToCopyableBuilder<Instance.Builder, Instance> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountID").getter(getter(Instance::accountID)).setter(setter(Builder::accountID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountID").build()).build();

    private static final SdkField<String> AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AmiId")
            .getter(getter(Instance::amiId)).setter(setter(Builder::amiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceID").getter(getter(Instance::instanceID)).setter(setter(Builder::instanceID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceID").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(Instance::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedTime").getter(getter(Instance::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<List<String>> PRODUCT_CODE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProductCode")
            .getter(getter(Instance::productCode))
            .setter(setter(Builder::productCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(Instance::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Instance::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SUBSCRIPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionName").getter(getter(Instance::subscriptionName)).setter(setter(Builder::subscriptionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionName").build()).build();

    private static final SdkField<String> USAGE_OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsageOperation").getter(getter(Instance::usageOperation)).setter(setter(Builder::usageOperation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOperation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            AMI_ID_FIELD, INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, LAST_UPDATED_TIME_FIELD, PRODUCT_CODE_FIELD, REGION_FIELD,
            STATUS_FIELD, SUBSCRIPTION_NAME_FIELD, USAGE_OPERATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountID;

    private final String amiId;

    private final String instanceID;

    private final String instanceType;

    private final String lastUpdatedTime;

    private final List<String> productCode;

    private final String region;

    private final String status;

    private final String subscriptionName;

    private final String usageOperation;

    private Instance(BuilderImpl builder) {
        this.accountID = builder.accountID;
        this.amiId = builder.amiId;
        this.instanceID = builder.instanceID;
        this.instanceType = builder.instanceType;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.productCode = builder.productCode;
        this.region = builder.region;
        this.status = builder.status;
        this.subscriptionName = builder.subscriptionName;
        this.usageOperation = builder.usageOperation;
    }

    /**
     * <p>
     * The account ID which owns the instance.
     * </p>
     * 
     * @return The account ID which owns the instance.
     */
    public final String accountID() {
        return accountID;
    }

    /**
     * <p>
     * The AMI ID used to launch the instance.
     * </p>
     * 
     * @return The AMI ID used to launch the instance.
     */
    public final String amiId() {
        return amiId;
    }

    /**
     * <p>
     * The instance ID of the resource.
     * </p>
     * 
     * @return The instance ID of the resource.
     */
    public final String instanceID() {
        return instanceID;
    }

    /**
     * <p>
     * The instance type of the resource.
     * </p>
     * 
     * @return The instance type of the resource.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The time in which the last discovery updated the instance details.
     * </p>
     * 
     * @return The time in which the last discovery updated the instance details.
     */
    public final String lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductCode property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductCode() {
        return productCode != null && !(productCode instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The product code for the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html"
     * >Usage operation values</a> in the <i>License Manager User Guide</i> .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductCode} method.
     * </p>
     * 
     * @return The product code for the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html"
     *         >Usage operation values</a> in the <i>License Manager User Guide</i> .
     */
    public final List<String> productCode() {
        return productCode;
    }

    /**
     * <p>
     * The Region the instance is running in.
     * </p>
     * 
     * @return The Region the instance is running in.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The status of the instance.
     * </p>
     * 
     * @return The status of the instance.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The name of the subscription being used by the instance.
     * </p>
     * 
     * @return The name of the subscription being used by the instance.
     */
    public final String subscriptionName() {
        return subscriptionName;
    }

    /**
     * <p>
     * The usage operation of the instance. For more information, see For more information, see <a
     * href="https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html"
     * >Usage operation values</a> in the <i>License Manager User Guide</i>.
     * </p>
     * 
     * @return The usage operation of the instance. For more information, see For more information, see <a
     *         href="https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html"
     *         >Usage operation values</a> in the <i>License Manager User Guide</i>.
     */
    public final String usageOperation() {
        return usageOperation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountID());
        hashCode = 31 * hashCode + Objects.hashCode(amiId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceID());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductCode() ? productCode() : null);
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionName());
        hashCode = 31 * hashCode + Objects.hashCode(usageOperation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        return Objects.equals(accountID(), other.accountID()) && Objects.equals(amiId(), other.amiId())
                && Objects.equals(instanceID(), other.instanceID()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && hasProductCode() == other.hasProductCode()
                && Objects.equals(productCode(), other.productCode()) && Objects.equals(region(), other.region())
                && Objects.equals(status(), other.status()) && Objects.equals(subscriptionName(), other.subscriptionName())
                && Objects.equals(usageOperation(), other.usageOperation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Instance").add("AccountID", accountID()).add("AmiId", amiId()).add("InstanceID", instanceID())
                .add("InstanceType", instanceType()).add("LastUpdatedTime", lastUpdatedTime())
                .add("ProductCode", hasProductCode() ? productCode() : null).add("Region", region()).add("Status", status())
                .add("SubscriptionName", subscriptionName()).add("UsageOperation", usageOperation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountID":
            return Optional.ofNullable(clazz.cast(accountID()));
        case "AmiId":
            return Optional.ofNullable(clazz.cast(amiId()));
        case "InstanceID":
            return Optional.ofNullable(clazz.cast(instanceID()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "ProductCode":
            return Optional.ofNullable(clazz.cast(productCode()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "SubscriptionName":
            return Optional.ofNullable(clazz.cast(subscriptionName()));
        case "UsageOperation":
            return Optional.ofNullable(clazz.cast(usageOperation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The account ID which owns the instance.
         * </p>
         * 
         * @param accountID
         *        The account ID which owns the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountID(String accountID);

        /**
         * <p>
         * The AMI ID used to launch the instance.
         * </p>
         * 
         * @param amiId
         *        The AMI ID used to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The instance ID of the resource.
         * </p>
         * 
         * @param instanceID
         *        The instance ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceID(String instanceID);

        /**
         * <p>
         * The instance type of the resource.
         * </p>
         * 
         * @param instanceType
         *        The instance type of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The time in which the last discovery updated the instance details.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time in which the last discovery updated the instance details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(String lastUpdatedTime);

        /**
         * <p>
         * The product code for the instance. For more information, see <a href=
         * "https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html">Usage
         * operation values</a> in the <i>License Manager User Guide</i> .
         * </p>
         * 
         * @param productCode
         *        The product code for the instance. For more information, see <a href=
         *        "https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html"
         *        >Usage operation values</a> in the <i>License Manager User Guide</i> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCode(Collection<String> productCode);

        /**
         * <p>
         * The product code for the instance. For more information, see <a href=
         * "https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html">Usage
         * operation values</a> in the <i>License Manager User Guide</i> .
         * </p>
         * 
         * @param productCode
         *        The product code for the instance. For more information, see <a href=
         *        "https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html"
         *        >Usage operation values</a> in the <i>License Manager User Guide</i> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCode(String... productCode);

        /**
         * <p>
         * The Region the instance is running in.
         * </p>
         * 
         * @param region
         *        The Region the instance is running in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The status of the instance.
         * </p>
         * 
         * @param status
         *        The status of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The name of the subscription being used by the instance.
         * </p>
         * 
         * @param subscriptionName
         *        The name of the subscription being used by the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionName(String subscriptionName);

        /**
         * <p>
         * The usage operation of the instance. For more information, see For more information, see <a href=
         * "https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html">Usage
         * operation values</a> in the <i>License Manager User Guide</i>.
         * </p>
         * 
         * @param usageOperation
         *        The usage operation of the instance. For more information, see For more information, see <a href=
         *        "https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html"
         *        >Usage operation values</a> in the <i>License Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageOperation(String usageOperation);
    }

    static final class BuilderImpl implements Builder {
        private String accountID;

        private String amiId;

        private String instanceID;

        private String instanceType;

        private String lastUpdatedTime;

        private List<String> productCode = DefaultSdkAutoConstructList.getInstance();

        private String region;

        private String status;

        private String subscriptionName;

        private String usageOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            accountID(model.accountID);
            amiId(model.amiId);
            instanceID(model.instanceID);
            instanceType(model.instanceType);
            lastUpdatedTime(model.lastUpdatedTime);
            productCode(model.productCode);
            region(model.region);
            status(model.status);
            subscriptionName(model.subscriptionName);
            usageOperation(model.usageOperation);
        }

        public final String getAccountID() {
            return accountID;
        }

        public final void setAccountID(String accountID) {
            this.accountID = accountID;
        }

        @Override
        public final Builder accountID(String accountID) {
            this.accountID = accountID;
            return this;
        }

        public final String getAmiId() {
            return amiId;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final String getInstanceID() {
            return instanceID;
        }

        public final void setInstanceID(String instanceID) {
            this.instanceID = instanceID;
        }

        @Override
        public final Builder instanceID(String instanceID) {
            this.instanceID = instanceID;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Collection<String> getProductCode() {
            if (productCode instanceof SdkAutoConstructList) {
                return null;
            }
            return productCode;
        }

        public final void setProductCode(Collection<String> productCode) {
            this.productCode = ProductCodeListCopier.copy(productCode);
        }

        @Override
        public final Builder productCode(Collection<String> productCode) {
            this.productCode = ProductCodeListCopier.copy(productCode);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCode(String... productCode) {
            productCode(Arrays.asList(productCode));
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getSubscriptionName() {
            return subscriptionName;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final String getUsageOperation() {
            return usageOperation;
        }

        public final void setUsageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
        }

        @Override
        public final Builder usageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
            return this;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
