/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the messages in the turn.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TurnSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<TurnSpecification.Builder, TurnSpecification> {
    private static final SdkField<AgentTurnSpecification> AGENT_TURN_FIELD = SdkField
            .<AgentTurnSpecification> builder(MarshallingType.SDK_POJO).memberName("agentTurn")
            .getter(getter(TurnSpecification::agentTurn)).setter(setter(Builder::agentTurn))
            .constructor(AgentTurnSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentTurn").build()).build();

    private static final SdkField<UserTurnSpecification> USER_TURN_FIELD = SdkField
            .<UserTurnSpecification> builder(MarshallingType.SDK_POJO).memberName("userTurn")
            .getter(getter(TurnSpecification::userTurn)).setter(setter(Builder::userTurn))
            .constructor(UserTurnSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userTurn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_TURN_FIELD,
            USER_TURN_FIELD));

    private static final long serialVersionUID = 1L;

    private final AgentTurnSpecification agentTurn;

    private final UserTurnSpecification userTurn;

    private TurnSpecification(BuilderImpl builder) {
        this.agentTurn = builder.agentTurn;
        this.userTurn = builder.userTurn;
    }

    /**
     * <p>
     * Contains information about the agent messages in the turn.
     * </p>
     * 
     * @return Contains information about the agent messages in the turn.
     */
    public final AgentTurnSpecification agentTurn() {
        return agentTurn;
    }

    /**
     * <p>
     * Contains information about the user messages in the turn.
     * </p>
     * 
     * @return Contains information about the user messages in the turn.
     */
    public final UserTurnSpecification userTurn() {
        return userTurn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentTurn());
        hashCode = 31 * hashCode + Objects.hashCode(userTurn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TurnSpecification)) {
            return false;
        }
        TurnSpecification other = (TurnSpecification) obj;
        return Objects.equals(agentTurn(), other.agentTurn()) && Objects.equals(userTurn(), other.userTurn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TurnSpecification").add("AgentTurn", agentTurn()).add("UserTurn", userTurn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentTurn":
            return Optional.ofNullable(clazz.cast(agentTurn()));
        case "userTurn":
            return Optional.ofNullable(clazz.cast(userTurn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TurnSpecification, T> g) {
        return obj -> g.apply((TurnSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TurnSpecification> {
        /**
         * <p>
         * Contains information about the agent messages in the turn.
         * </p>
         * 
         * @param agentTurn
         *        Contains information about the agent messages in the turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentTurn(AgentTurnSpecification agentTurn);

        /**
         * <p>
         * Contains information about the agent messages in the turn.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentTurnSpecification.Builder} avoiding
         * the need to create one manually via {@link AgentTurnSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentTurnSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #agentTurn(AgentTurnSpecification)}.
         * 
         * @param agentTurn
         *        a consumer that will call methods on {@link AgentTurnSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentTurn(AgentTurnSpecification)
         */
        default Builder agentTurn(Consumer<AgentTurnSpecification.Builder> agentTurn) {
            return agentTurn(AgentTurnSpecification.builder().applyMutation(agentTurn).build());
        }

        /**
         * <p>
         * Contains information about the user messages in the turn.
         * </p>
         * 
         * @param userTurn
         *        Contains information about the user messages in the turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userTurn(UserTurnSpecification userTurn);

        /**
         * <p>
         * Contains information about the user messages in the turn.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserTurnSpecification.Builder} avoiding
         * the need to create one manually via {@link UserTurnSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserTurnSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #userTurn(UserTurnSpecification)}.
         * 
         * @param userTurn
         *        a consumer that will call methods on {@link UserTurnSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userTurn(UserTurnSpecification)
         */
        default Builder userTurn(Consumer<UserTurnSpecification.Builder> userTurn) {
            return userTurn(UserTurnSpecification.builder().applyMutation(userTurn).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AgentTurnSpecification agentTurn;

        private UserTurnSpecification userTurn;

        private BuilderImpl() {
        }

        private BuilderImpl(TurnSpecification model) {
            agentTurn(model.agentTurn);
            userTurn(model.userTurn);
        }

        public final AgentTurnSpecification.Builder getAgentTurn() {
            return agentTurn != null ? agentTurn.toBuilder() : null;
        }

        public final void setAgentTurn(AgentTurnSpecification.BuilderImpl agentTurn) {
            this.agentTurn = agentTurn != null ? agentTurn.build() : null;
        }

        @Override
        public final Builder agentTurn(AgentTurnSpecification agentTurn) {
            this.agentTurn = agentTurn;
            return this;
        }

        public final UserTurnSpecification.Builder getUserTurn() {
            return userTurn != null ? userTurn.toBuilder() : null;
        }

        public final void setUserTurn(UserTurnSpecification.BuilderImpl userTurn) {
            this.userTurn = userTurn != null ? userTurn.build() : null;
        }

        @Override
        public final Builder userTurn(UserTurnSpecification userTurn) {
            this.userTurn = userTurn;
            return this;
        }

        @Override
        public TurnSpecification build() {
            return new TurnSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
