/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBuiltInIntentsRequest extends LexModelsV2Request implements
        ToCopyableBuilder<ListBuiltInIntentsRequest.Builder, ListBuiltInIntentsRequest> {
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(ListBuiltInIntentsRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<BuiltInIntentSortBy> SORT_BY_FIELD = SdkField
            .<BuiltInIntentSortBy> builder(MarshallingType.SDK_POJO).memberName("sortBy")
            .getter(getter(ListBuiltInIntentsRequest::sortBy)).setter(setter(Builder::sortBy))
            .constructor(BuiltInIntentSortBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListBuiltInIntentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBuiltInIntentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCALE_ID_FIELD,
            SORT_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String localeId;

    private final BuiltInIntentSortBy sortBy;

    private final Integer maxResults;

    private final String nextToken;

    private ListBuiltInIntentsRequest(BuilderImpl builder) {
        super(builder);
        this.localeId = builder.localeId;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier of the language and locale of the intents to list. The string must match one of the supported
     * locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     * </p>
     * 
     * @return The identifier of the language and locale of the intents to list. The string must match one of the
     *         supported locales. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by the
     * built-in intent signature in either ascending or descending order.
     * </p>
     * 
     * @return Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by
     *         the built-in intent signature in either ascending or descending order.
     */
    public final BuiltInIntentSortBy sortBy() {
        return sortBy;
    }

    /**
     * <p>
     * The maximum number of built-in intents to return in each page of results. If there are fewer results than the max
     * page size, only the actual number of results are returned.
     * </p>
     * 
     * @return The maximum number of built-in intents to return in each page of results. If there are fewer results than
     *         the max page size, only the actual number of results are returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the response from the <code>ListBuiltInIntents</code> operation contains more results than specified in the
     * <code>maxResults</code> parameter, a token is returned in the response. Use that token in the
     * <code>nextToken</code> parameter to return the next page of results.
     * </p>
     * 
     * @return If the response from the <code>ListBuiltInIntents</code> operation contains more results than specified
     *         in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the
     *         <code>nextToken</code> parameter to return the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuiltInIntentsRequest)) {
            return false;
        }
        ListBuiltInIntentsRequest other = (ListBuiltInIntentsRequest) obj;
        return Objects.equals(localeId(), other.localeId()) && Objects.equals(sortBy(), other.sortBy())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBuiltInIntentsRequest").add("LocaleId", localeId()).add("SortBy", sortBy())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBuiltInIntentsRequest, T> g) {
        return obj -> g.apply((ListBuiltInIntentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListBuiltInIntentsRequest> {
        /**
         * <p>
         * The identifier of the language and locale of the intents to list. The string must match one of the supported
         * locales. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale of the intents to list. The string must match one of the
         *        supported locales. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by the
         * built-in intent signature in either ascending or descending order.
         * </p>
         * 
         * @param sortBy
         *        Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted
         *        by the built-in intent signature in either ascending or descending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(BuiltInIntentSortBy sortBy);

        /**
         * <p>
         * Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by the
         * built-in intent signature in either ascending or descending order.
         * </p>
         * This is a convenience method that creates an instance of the {@link BuiltInIntentSortBy.Builder} avoiding the
         * need to create one manually via {@link BuiltInIntentSortBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BuiltInIntentSortBy.Builder#build()} is called immediately and
         * its result is passed to {@link #sortBy(BuiltInIntentSortBy)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link BuiltInIntentSortBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(BuiltInIntentSortBy)
         */
        default Builder sortBy(Consumer<BuiltInIntentSortBy.Builder> sortBy) {
            return sortBy(BuiltInIntentSortBy.builder().applyMutation(sortBy).build());
        }

        /**
         * <p>
         * The maximum number of built-in intents to return in each page of results. If there are fewer results than the
         * max page size, only the actual number of results are returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of built-in intents to return in each page of results. If there are fewer results
         *        than the max page size, only the actual number of results are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the response from the <code>ListBuiltInIntents</code> operation contains more results than specified in
         * the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the
         * <code>nextToken</code> parameter to return the next page of results.
         * </p>
         * 
         * @param nextToken
         *        If the response from the <code>ListBuiltInIntents</code> operation contains more results than
         *        specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that
         *        token in the <code>nextToken</code> parameter to return the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String localeId;

        private BuiltInIntentSortBy sortBy;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuiltInIntentsRequest model) {
            super(model);
            localeId(model.localeId);
            sortBy(model.sortBy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final BuiltInIntentSortBy.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        public final void setSortBy(BuiltInIntentSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(BuiltInIntentSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBuiltInIntentsRequest build() {
            return new ListBuiltInIntentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
