/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object used for specifying the data range that the customer wants Amazon Lex to read through in the input
 * transcripts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateRangeFilter implements SdkPojo, Serializable, ToCopyableBuilder<DateRangeFilter.Builder, DateRangeFilter> {
    private static final SdkField<Instant> START_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDateTime").getter(getter(DateRangeFilter::startDateTime)).setter(setter(Builder::startDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDateTime").build()).build();

    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endDateTime").getter(getter(DateRangeFilter::endDateTime)).setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_DATE_TIME_FIELD,
            END_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant startDateTime;

    private final Instant endDateTime;

    private DateRangeFilter(BuilderImpl builder) {
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
    }

    /**
     * <p>
     * A timestamp indicating the start date for the date range filter.
     * </p>
     * 
     * @return A timestamp indicating the start date for the date range filter.
     */
    public final Instant startDateTime() {
        return startDateTime;
    }

    /**
     * <p>
     * A timestamp indicating the end date for the date range filter.
     * </p>
     * 
     * @return A timestamp indicating the end date for the date range filter.
     */
    public final Instant endDateTime() {
        return endDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateRangeFilter)) {
            return false;
        }
        DateRangeFilter other = (DateRangeFilter) obj;
        return Objects.equals(startDateTime(), other.startDateTime()) && Objects.equals(endDateTime(), other.endDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateRangeFilter").add("StartDateTime", startDateTime()).add("EndDateTime", endDateTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startDateTime":
            return Optional.ofNullable(clazz.cast(startDateTime()));
        case "endDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateRangeFilter, T> g) {
        return obj -> g.apply((DateRangeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateRangeFilter> {
        /**
         * <p>
         * A timestamp indicating the start date for the date range filter.
         * </p>
         * 
         * @param startDateTime
         *        A timestamp indicating the start date for the date range filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDateTime(Instant startDateTime);

        /**
         * <p>
         * A timestamp indicating the end date for the date range filter.
         * </p>
         * 
         * @param endDateTime
         *        A timestamp indicating the end date for the date range filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateTime(Instant endDateTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant startDateTime;

        private Instant endDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DateRangeFilter model) {
            startDateTime(model.startDateTime);
            endDateTime(model.endDateTime);
        }

        public final Instant getStartDateTime() {
            return startDateTime;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final Instant getEndDateTime() {
            return endDateTime;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        @Override
        public DateRangeFilter build() {
            return new DateRangeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
