/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBotAliasResponse extends LexModelsV2Response implements
        ToCopyableBuilder<CreateBotAliasResponse.Builder, CreateBotAliasResponse> {
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasId").getter(getter(CreateBotAliasResponse::botAliasId)).setter(setter(Builder::botAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()).build();

    private static final SdkField<String> BOT_ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasName").getter(getter(CreateBotAliasResponse::botAliasName))
            .setter(setter(Builder::botAliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateBotAliasResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(CreateBotAliasResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<Map<String, BotAliasLocaleSettings>> BOT_ALIAS_LOCALE_SETTINGS_FIELD = SdkField
            .<Map<String, BotAliasLocaleSettings>> builder(MarshallingType.MAP)
            .memberName("botAliasLocaleSettings")
            .getter(getter(CreateBotAliasResponse::botAliasLocaleSettings))
            .setter(setter(Builder::botAliasLocaleSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasLocaleSettings").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<BotAliasLocaleSettings> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotAliasLocaleSettings::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ConversationLogSettings> CONVERSATION_LOG_SETTINGS_FIELD = SdkField
            .<ConversationLogSettings> builder(MarshallingType.SDK_POJO).memberName("conversationLogSettings")
            .getter(getter(CreateBotAliasResponse::conversationLogSettings)).setter(setter(Builder::conversationLogSettings))
            .constructor(ConversationLogSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationLogSettings").build())
            .build();

    private static final SdkField<SentimentAnalysisSettings> SENTIMENT_ANALYSIS_SETTINGS_FIELD = SdkField
            .<SentimentAnalysisSettings> builder(MarshallingType.SDK_POJO).memberName("sentimentAnalysisSettings")
            .getter(getter(CreateBotAliasResponse::sentimentAnalysisSettings)).setter(setter(Builder::sentimentAnalysisSettings))
            .constructor(SentimentAnalysisSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentimentAnalysisSettings").build())
            .build();

    private static final SdkField<String> BOT_ALIAS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasStatus").getter(getter(CreateBotAliasResponse::botAliasStatusAsString))
            .setter(setter(Builder::botAliasStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasStatus").build()).build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(CreateBotAliasResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(CreateBotAliasResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateBotAliasResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_ID_FIELD,
            BOT_ALIAS_NAME_FIELD, DESCRIPTION_FIELD, BOT_VERSION_FIELD, BOT_ALIAS_LOCALE_SETTINGS_FIELD,
            CONVERSATION_LOG_SETTINGS_FIELD, SENTIMENT_ANALYSIS_SETTINGS_FIELD, BOT_ALIAS_STATUS_FIELD, BOT_ID_FIELD,
            CREATION_DATE_TIME_FIELD, TAGS_FIELD));

    private final String botAliasId;

    private final String botAliasName;

    private final String description;

    private final String botVersion;

    private final Map<String, BotAliasLocaleSettings> botAliasLocaleSettings;

    private final ConversationLogSettings conversationLogSettings;

    private final SentimentAnalysisSettings sentimentAnalysisSettings;

    private final String botAliasStatus;

    private final String botId;

    private final Instant creationDateTime;

    private final Map<String, String> tags;

    private CreateBotAliasResponse(BuilderImpl builder) {
        super(builder);
        this.botAliasId = builder.botAliasId;
        this.botAliasName = builder.botAliasName;
        this.description = builder.description;
        this.botVersion = builder.botVersion;
        this.botAliasLocaleSettings = builder.botAliasLocaleSettings;
        this.conversationLogSettings = builder.conversationLogSettings;
        this.sentimentAnalysisSettings = builder.sentimentAnalysisSettings;
        this.botAliasStatus = builder.botAliasStatus;
        this.botId = builder.botId;
        this.creationDateTime = builder.creationDateTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier of the bot alias.
     * </p>
     * 
     * @return The unique identifier of the bot alias.
     */
    public final String botAliasId() {
        return botAliasId;
    }

    /**
     * <p>
     * The name specified for the bot alias.
     * </p>
     * 
     * @return The name specified for the bot alias.
     */
    public final String botAliasName() {
        return botAliasName;
    }

    /**
     * <p>
     * The description specified for the bot alias.
     * </p>
     * 
     * @return The description specified for the bot alias.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The version of the bot associated with this alias.
     * </p>
     * 
     * @return The version of the bot associated with this alias.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotAliasLocaleSettings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBotAliasLocaleSettings() {
        return botAliasLocaleSettings != null && !(botAliasLocaleSettings instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Configuration information for a specific locale.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotAliasLocaleSettings} method.
     * </p>
     * 
     * @return Configuration information for a specific locale.
     */
    public final Map<String, BotAliasLocaleSettings> botAliasLocaleSettings() {
        return botAliasLocaleSettings;
    }

    /**
     * <p>
     * The conversation log settings specified for the alias.
     * </p>
     * 
     * @return The conversation log settings specified for the alias.
     */
    public final ConversationLogSettings conversationLogSettings() {
        return conversationLogSettings;
    }

    /**
     * Returns the value of the SentimentAnalysisSettings property for this object.
     * 
     * @return The value of the SentimentAnalysisSettings property for this object.
     */
    public final SentimentAnalysisSettings sentimentAnalysisSettings() {
        return sentimentAnalysisSettings;
    }

    /**
     * <p>
     * The current status of the alias. The alias is first put into the <code>Creating</code> state. When the alias is
     * ready to be used, it is put into the <code>Available</code> state. You can use the <code>DescribeBotAlias</code>
     * operation to get the current state of an alias.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botAliasStatus}
     * will return {@link BotAliasStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botAliasStatusAsString}.
     * </p>
     * 
     * @return The current status of the alias. The alias is first put into the <code>Creating</code> state. When the
     *         alias is ready to be used, it is put into the <code>Available</code> state. You can use the
     *         <code>DescribeBotAlias</code> operation to get the current state of an alias.
     * @see BotAliasStatus
     */
    public final BotAliasStatus botAliasStatus() {
        return BotAliasStatus.fromValue(botAliasStatus);
    }

    /**
     * <p>
     * The current status of the alias. The alias is first put into the <code>Creating</code> state. When the alias is
     * ready to be used, it is put into the <code>Available</code> state. You can use the <code>DescribeBotAlias</code>
     * operation to get the current state of an alias.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botAliasStatus}
     * will return {@link BotAliasStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botAliasStatusAsString}.
     * </p>
     * 
     * @return The current status of the alias. The alias is first put into the <code>Creating</code> state. When the
     *         alias is ready to be used, it is put into the <code>Available</code> state. You can use the
     *         <code>DescribeBotAlias</code> operation to get the current state of an alias.
     * @see BotAliasStatus
     */
    public final String botAliasStatusAsString() {
        return botAliasStatus;
    }

    /**
     * <p>
     * The unique identifier of the bot that this alias applies to.
     * </p>
     * 
     * @return The unique identifier of the bot that this alias applies to.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * A Unix timestamp indicating the date and time that the bot alias was created.
     * </p>
     * 
     * @return A Unix timestamp indicating the date and time that the bot alias was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags associated with the bot alias.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags associated with the bot alias.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(botAliasName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotAliasLocaleSettings() ? botAliasLocaleSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(conversationLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentAnalysisSettings());
        hashCode = 31 * hashCode + Objects.hashCode(botAliasStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBotAliasResponse)) {
            return false;
        }
        CreateBotAliasResponse other = (CreateBotAliasResponse) obj;
        return Objects.equals(botAliasId(), other.botAliasId()) && Objects.equals(botAliasName(), other.botAliasName())
                && Objects.equals(description(), other.description()) && Objects.equals(botVersion(), other.botVersion())
                && hasBotAliasLocaleSettings() == other.hasBotAliasLocaleSettings()
                && Objects.equals(botAliasLocaleSettings(), other.botAliasLocaleSettings())
                && Objects.equals(conversationLogSettings(), other.conversationLogSettings())
                && Objects.equals(sentimentAnalysisSettings(), other.sentimentAnalysisSettings())
                && Objects.equals(botAliasStatusAsString(), other.botAliasStatusAsString())
                && Objects.equals(botId(), other.botId()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBotAliasResponse").add("BotAliasId", botAliasId()).add("BotAliasName", botAliasName())
                .add("Description", description()).add("BotVersion", botVersion())
                .add("BotAliasLocaleSettings", hasBotAliasLocaleSettings() ? botAliasLocaleSettings() : null)
                .add("ConversationLogSettings", conversationLogSettings())
                .add("SentimentAnalysisSettings", sentimentAnalysisSettings()).add("BotAliasStatus", botAliasStatusAsString())
                .add("BotId", botId()).add("CreationDateTime", creationDateTime()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botAliasId":
            return Optional.ofNullable(clazz.cast(botAliasId()));
        case "botAliasName":
            return Optional.ofNullable(clazz.cast(botAliasName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "botAliasLocaleSettings":
            return Optional.ofNullable(clazz.cast(botAliasLocaleSettings()));
        case "conversationLogSettings":
            return Optional.ofNullable(clazz.cast(conversationLogSettings()));
        case "sentimentAnalysisSettings":
            return Optional.ofNullable(clazz.cast(sentimentAnalysisSettings()));
        case "botAliasStatus":
            return Optional.ofNullable(clazz.cast(botAliasStatusAsString()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBotAliasResponse, T> g) {
        return obj -> g.apply((CreateBotAliasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateBotAliasResponse> {
        /**
         * <p>
         * The unique identifier of the bot alias.
         * </p>
         * 
         * @param botAliasId
         *        The unique identifier of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasId(String botAliasId);

        /**
         * <p>
         * The name specified for the bot alias.
         * </p>
         * 
         * @param botAliasName
         *        The name specified for the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasName(String botAliasName);

        /**
         * <p>
         * The description specified for the bot alias.
         * </p>
         * 
         * @param description
         *        The description specified for the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version of the bot associated with this alias.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot associated with this alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * Configuration information for a specific locale.
         * </p>
         * 
         * @param botAliasLocaleSettings
         *        Configuration information for a specific locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasLocaleSettings(Map<String, BotAliasLocaleSettings> botAliasLocaleSettings);

        /**
         * <p>
         * The conversation log settings specified for the alias.
         * </p>
         * 
         * @param conversationLogSettings
         *        The conversation log settings specified for the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationLogSettings(ConversationLogSettings conversationLogSettings);

        /**
         * <p>
         * The conversation log settings specified for the alias.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConversationLogSettings.Builder} avoiding
         * the need to create one manually via {@link ConversationLogSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConversationLogSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #conversationLogSettings(ConversationLogSettings)}.
         * 
         * @param conversationLogSettings
         *        a consumer that will call methods on {@link ConversationLogSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationLogSettings(ConversationLogSettings)
         */
        default Builder conversationLogSettings(Consumer<ConversationLogSettings.Builder> conversationLogSettings) {
            return conversationLogSettings(ConversationLogSettings.builder().applyMutation(conversationLogSettings).build());
        }

        /**
         * Sets the value of the SentimentAnalysisSettings property for this object.
         *
         * @param sentimentAnalysisSettings
         *        The new value for the SentimentAnalysisSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentimentAnalysisSettings(SentimentAnalysisSettings sentimentAnalysisSettings);

        /**
         * Sets the value of the SentimentAnalysisSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SentimentAnalysisSettings.Builder}
         * avoiding the need to create one manually via {@link SentimentAnalysisSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SentimentAnalysisSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #sentimentAnalysisSettings(SentimentAnalysisSettings)}.
         * 
         * @param sentimentAnalysisSettings
         *        a consumer that will call methods on {@link SentimentAnalysisSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sentimentAnalysisSettings(SentimentAnalysisSettings)
         */
        default Builder sentimentAnalysisSettings(Consumer<SentimentAnalysisSettings.Builder> sentimentAnalysisSettings) {
            return sentimentAnalysisSettings(SentimentAnalysisSettings.builder().applyMutation(sentimentAnalysisSettings).build());
        }

        /**
         * <p>
         * The current status of the alias. The alias is first put into the <code>Creating</code> state. When the alias
         * is ready to be used, it is put into the <code>Available</code> state. You can use the
         * <code>DescribeBotAlias</code> operation to get the current state of an alias.
         * </p>
         * 
         * @param botAliasStatus
         *        The current status of the alias. The alias is first put into the <code>Creating</code> state. When the
         *        alias is ready to be used, it is put into the <code>Available</code> state. You can use the
         *        <code>DescribeBotAlias</code> operation to get the current state of an alias.
         * @see BotAliasStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotAliasStatus
         */
        Builder botAliasStatus(String botAliasStatus);

        /**
         * <p>
         * The current status of the alias. The alias is first put into the <code>Creating</code> state. When the alias
         * is ready to be used, it is put into the <code>Available</code> state. You can use the
         * <code>DescribeBotAlias</code> operation to get the current state of an alias.
         * </p>
         * 
         * @param botAliasStatus
         *        The current status of the alias. The alias is first put into the <code>Creating</code> state. When the
         *        alias is ready to be used, it is put into the <code>Available</code> state. You can use the
         *        <code>DescribeBotAlias</code> operation to get the current state of an alias.
         * @see BotAliasStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotAliasStatus
         */
        Builder botAliasStatus(BotAliasStatus botAliasStatus);

        /**
         * <p>
         * The unique identifier of the bot that this alias applies to.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot that this alias applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * A Unix timestamp indicating the date and time that the bot alias was created.
         * </p>
         * 
         * @param creationDateTime
         *        A Unix timestamp indicating the date and time that the bot alias was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * A list of tags associated with the bot alias.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botAliasId;

        private String botAliasName;

        private String description;

        private String botVersion;

        private Map<String, BotAliasLocaleSettings> botAliasLocaleSettings = DefaultSdkAutoConstructMap.getInstance();

        private ConversationLogSettings conversationLogSettings;

        private SentimentAnalysisSettings sentimentAnalysisSettings;

        private String botAliasStatus;

        private String botId;

        private Instant creationDateTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBotAliasResponse model) {
            super(model);
            botAliasId(model.botAliasId);
            botAliasName(model.botAliasName);
            description(model.description);
            botVersion(model.botVersion);
            botAliasLocaleSettings(model.botAliasLocaleSettings);
            conversationLogSettings(model.conversationLogSettings);
            sentimentAnalysisSettings(model.sentimentAnalysisSettings);
            botAliasStatus(model.botAliasStatus);
            botId(model.botId);
            creationDateTime(model.creationDateTime);
            tags(model.tags);
        }

        public final String getBotAliasId() {
            return botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getBotAliasName() {
            return botAliasName;
        }

        public final void setBotAliasName(String botAliasName) {
            this.botAliasName = botAliasName;
        }

        @Override
        public final Builder botAliasName(String botAliasName) {
            this.botAliasName = botAliasName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final Map<String, BotAliasLocaleSettings.Builder> getBotAliasLocaleSettings() {
            Map<String, BotAliasLocaleSettings.Builder> result = BotAliasLocaleSettingsMapCopier
                    .copyToBuilder(this.botAliasLocaleSettings);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBotAliasLocaleSettings(Map<String, BotAliasLocaleSettings.BuilderImpl> botAliasLocaleSettings) {
            this.botAliasLocaleSettings = BotAliasLocaleSettingsMapCopier.copyFromBuilder(botAliasLocaleSettings);
        }

        @Override
        public final Builder botAliasLocaleSettings(Map<String, BotAliasLocaleSettings> botAliasLocaleSettings) {
            this.botAliasLocaleSettings = BotAliasLocaleSettingsMapCopier.copy(botAliasLocaleSettings);
            return this;
        }

        public final ConversationLogSettings.Builder getConversationLogSettings() {
            return conversationLogSettings != null ? conversationLogSettings.toBuilder() : null;
        }

        public final void setConversationLogSettings(ConversationLogSettings.BuilderImpl conversationLogSettings) {
            this.conversationLogSettings = conversationLogSettings != null ? conversationLogSettings.build() : null;
        }

        @Override
        public final Builder conversationLogSettings(ConversationLogSettings conversationLogSettings) {
            this.conversationLogSettings = conversationLogSettings;
            return this;
        }

        public final SentimentAnalysisSettings.Builder getSentimentAnalysisSettings() {
            return sentimentAnalysisSettings != null ? sentimentAnalysisSettings.toBuilder() : null;
        }

        public final void setSentimentAnalysisSettings(SentimentAnalysisSettings.BuilderImpl sentimentAnalysisSettings) {
            this.sentimentAnalysisSettings = sentimentAnalysisSettings != null ? sentimentAnalysisSettings.build() : null;
        }

        @Override
        public final Builder sentimentAnalysisSettings(SentimentAnalysisSettings sentimentAnalysisSettings) {
            this.sentimentAnalysisSettings = sentimentAnalysisSettings;
            return this;
        }

        public final String getBotAliasStatus() {
            return botAliasStatus;
        }

        public final void setBotAliasStatus(String botAliasStatus) {
            this.botAliasStatus = botAliasStatus;
        }

        @Override
        public final Builder botAliasStatus(String botAliasStatus) {
            this.botAliasStatus = botAliasStatus;
            return this;
        }

        @Override
        public final Builder botAliasStatus(BotAliasStatus botAliasStatus) {
            this.botAliasStatus(botAliasStatus == null ? null : botAliasStatus.toString());
            return this;
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateBotAliasResponse build() {
            return new CreateBotAliasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
