/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse;

public class ListExportsPublisher
implements SdkPublisher<ListExportsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListExportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExportsPublisher(LexModelsV2AsyncClient client, ListExportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExportsPublisher(LexModelsV2AsyncClient client, ListExportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListExportsResponseFetcher
    implements AsyncPageFetcher<ListExportsResponse> {
        private ListExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExportsResponse> nextPage(ListExportsResponse previousPage) {
            if (previousPage == null) {
                return ListExportsPublisher.this.client.listExports(ListExportsPublisher.this.firstRequest);
            }
            return ListExportsPublisher.this.client.listExports((ListExportsRequest)((Object)ListExportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

