/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse;

public class ListSlotsIterable
implements SdkIterable<ListSlotsResponse> {
    private final LexModelsV2Client client;
    private final ListSlotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSlotsIterable(LexModelsV2Client client, ListSlotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSlotsResponseFetcher();
    }

    public Iterator<ListSlotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSlotsResponseFetcher
    implements SyncPageFetcher<ListSlotsResponse> {
        private ListSlotsResponseFetcher() {
        }

        public boolean hasNextPage(ListSlotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSlotsResponse nextPage(ListSlotsResponse previousPage) {
            if (previousPage == null) {
                return ListSlotsIterable.this.client.listSlots(ListSlotsIterable.this.firstRequest);
            }
            return ListSlotsIterable.this.client.listSlots((ListSlotsRequest)((Object)ListSlotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

