/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse;

public class ListBuiltInIntentsPublisher
implements SdkPublisher<ListBuiltInIntentsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListBuiltInIntentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBuiltInIntentsPublisher(LexModelsV2AsyncClient client, ListBuiltInIntentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBuiltInIntentsPublisher(LexModelsV2AsyncClient client, ListBuiltInIntentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBuiltInIntentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBuiltInIntentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBuiltInIntentsResponseFetcher
    implements AsyncPageFetcher<ListBuiltInIntentsResponse> {
        private ListBuiltInIntentsResponseFetcher() {
        }

        public boolean hasNextPage(ListBuiltInIntentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBuiltInIntentsResponse> nextPage(ListBuiltInIntentsResponse previousPage) {
            if (previousPage == null) {
                return ListBuiltInIntentsPublisher.this.client.listBuiltInIntents(ListBuiltInIntentsPublisher.this.firstRequest);
            }
            return ListBuiltInIntentsPublisher.this.client.listBuiltInIntents((ListBuiltInIntentsRequest)((Object)ListBuiltInIntentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

