/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCodeSigningConfigResponse extends LambdaResponse implements
        ToCopyableBuilder<CreateCodeSigningConfigResponse.Builder, CreateCodeSigningConfigResponse> {
    private static final SdkField<CodeSigningConfig> CODE_SIGNING_CONFIG_FIELD = SdkField
            .<CodeSigningConfig> builder(MarshallingType.SDK_POJO).memberName("CodeSigningConfig")
            .getter(getter(CreateCodeSigningConfigResponse::codeSigningConfig)).setter(setter(Builder::codeSigningConfig))
            .constructor(CodeSigningConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_SIGNING_CONFIG_FIELD));

    private final CodeSigningConfig codeSigningConfig;

    private CreateCodeSigningConfigResponse(BuilderImpl builder) {
        super(builder);
        this.codeSigningConfig = builder.codeSigningConfig;
    }

    /**
     * <p>
     * The code signing configuration.
     * </p>
     * 
     * @return The code signing configuration.
     */
    public final CodeSigningConfig codeSigningConfig() {
        return codeSigningConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeSigningConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCodeSigningConfigResponse)) {
            return false;
        }
        CreateCodeSigningConfigResponse other = (CreateCodeSigningConfigResponse) obj;
        return Objects.equals(codeSigningConfig(), other.codeSigningConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCodeSigningConfigResponse").add("CodeSigningConfig", codeSigningConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeSigningConfig":
            return Optional.ofNullable(clazz.cast(codeSigningConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCodeSigningConfigResponse, T> g) {
        return obj -> g.apply((CreateCodeSigningConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateCodeSigningConfigResponse> {
        /**
         * <p>
         * The code signing configuration.
         * </p>
         * 
         * @param codeSigningConfig
         *        The code signing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSigningConfig(CodeSigningConfig codeSigningConfig);

        /**
         * <p>
         * The code signing configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeSigningConfig.Builder} avoiding the need to
         * create one manually via {@link CodeSigningConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeSigningConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #codeSigningConfig(CodeSigningConfig)}.
         * 
         * @param codeSigningConfig
         *        a consumer that will call methods on {@link CodeSigningConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeSigningConfig(CodeSigningConfig)
         */
        default Builder codeSigningConfig(Consumer<CodeSigningConfig.Builder> codeSigningConfig) {
            return codeSigningConfig(CodeSigningConfig.builder().applyMutation(codeSigningConfig).build());
        }
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private CodeSigningConfig codeSigningConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCodeSigningConfigResponse model) {
            super(model);
            codeSigningConfig(model.codeSigningConfig);
        }

        public final CodeSigningConfig.Builder getCodeSigningConfig() {
            return codeSigningConfig != null ? codeSigningConfig.toBuilder() : null;
        }

        @Override
        public final Builder codeSigningConfig(CodeSigningConfig codeSigningConfig) {
            this.codeSigningConfig = codeSigningConfig;
            return this;
        }

        public final void setCodeSigningConfig(CodeSigningConfig.BuilderImpl codeSigningConfig) {
            this.codeSigningConfig = codeSigningConfig != null ? codeSigningConfig.build() : null;
        }

        @Override
        public CreateCodeSigningConfigResponse build() {
            return new CreateCodeSigningConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
