/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.XksProxyConnectivityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class XksProxyConfigurationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, XksProxyConfigurationType> {
    private static final SdkField<String> CONNECTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Connectivity").getter(XksProxyConfigurationType.getter(XksProxyConfigurationType::connectivityAsString)).setter(XksProxyConfigurationType.setter(Builder::connectivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connectivity").build()}).build();
    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessKeyId").getter(XksProxyConfigurationType.getter(XksProxyConfigurationType::accessKeyId)).setter(XksProxyConfigurationType.setter(Builder::accessKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKeyId").build()}).build();
    private static final SdkField<String> URI_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UriEndpoint").getter(XksProxyConfigurationType.getter(XksProxyConfigurationType::uriEndpoint)).setter(XksProxyConfigurationType.setter(Builder::uriEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UriEndpoint").build()}).build();
    private static final SdkField<String> URI_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UriPath").getter(XksProxyConfigurationType.getter(XksProxyConfigurationType::uriPath)).setter(XksProxyConfigurationType.setter(Builder::uriPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UriPath").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointServiceName").getter(XksProxyConfigurationType.getter(XksProxyConfigurationType::vpcEndpointServiceName)).setter(XksProxyConfigurationType.setter(Builder::vpcEndpointServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointServiceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTIVITY_FIELD, ACCESS_KEY_ID_FIELD, URI_ENDPOINT_FIELD, URI_PATH_FIELD, VPC_ENDPOINT_SERVICE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = XksProxyConfigurationType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectivity;
    private final String accessKeyId;
    private final String uriEndpoint;
    private final String uriPath;
    private final String vpcEndpointServiceName;

    private XksProxyConfigurationType(BuilderImpl builder) {
        this.connectivity = builder.connectivity;
        this.accessKeyId = builder.accessKeyId;
        this.uriEndpoint = builder.uriEndpoint;
        this.uriPath = builder.uriPath;
        this.vpcEndpointServiceName = builder.vpcEndpointServiceName;
    }

    public final XksProxyConnectivityType connectivity() {
        return XksProxyConnectivityType.fromValue(this.connectivity);
    }

    public final String connectivityAsString() {
        return this.connectivity;
    }

    public final String accessKeyId() {
        return this.accessKeyId;
    }

    public final String uriEndpoint() {
        return this.uriEndpoint;
    }

    public final String uriPath() {
        return this.uriPath;
    }

    public final String vpcEndpointServiceName() {
        return this.vpcEndpointServiceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectivityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.uriEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.uriPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointServiceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XksProxyConfigurationType)) {
            return false;
        }
        XksProxyConfigurationType other = (XksProxyConfigurationType)obj;
        return Objects.equals(this.connectivityAsString(), other.connectivityAsString()) && Objects.equals(this.accessKeyId(), other.accessKeyId()) && Objects.equals(this.uriEndpoint(), other.uriEndpoint()) && Objects.equals(this.uriPath(), other.uriPath()) && Objects.equals(this.vpcEndpointServiceName(), other.vpcEndpointServiceName());
    }

    public final String toString() {
        return ToString.builder((String)"XksProxyConfigurationType").add("Connectivity", (Object)this.connectivityAsString()).add("AccessKeyId", (Object)(this.accessKeyId() == null ? null : "*** Sensitive Data Redacted ***")).add("UriEndpoint", (Object)this.uriEndpoint()).add("UriPath", (Object)this.uriPath()).add("VpcEndpointServiceName", (Object)this.vpcEndpointServiceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Connectivity": {
                return Optional.ofNullable(clazz.cast(this.connectivityAsString()));
            }
            case "AccessKeyId": {
                return Optional.ofNullable(clazz.cast(this.accessKeyId()));
            }
            case "UriEndpoint": {
                return Optional.ofNullable(clazz.cast(this.uriEndpoint()));
            }
            case "UriPath": {
                return Optional.ofNullable(clazz.cast(this.uriPath()));
            }
            case "VpcEndpointServiceName": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointServiceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Connectivity", CONNECTIVITY_FIELD);
        map.put("AccessKeyId", ACCESS_KEY_ID_FIELD);
        map.put("UriEndpoint", URI_ENDPOINT_FIELD);
        map.put("UriPath", URI_PATH_FIELD);
        map.put("VpcEndpointServiceName", VPC_ENDPOINT_SERVICE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<XksProxyConfigurationType, T> g) {
        return obj -> g.apply((XksProxyConfigurationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectivity;
        private String accessKeyId;
        private String uriEndpoint;
        private String uriPath;
        private String vpcEndpointServiceName;

        private BuilderImpl() {
        }

        private BuilderImpl(XksProxyConfigurationType model) {
            this.connectivity(model.connectivity);
            this.accessKeyId(model.accessKeyId);
            this.uriEndpoint(model.uriEndpoint);
            this.uriPath(model.uriPath);
            this.vpcEndpointServiceName(model.vpcEndpointServiceName);
        }

        public final String getConnectivity() {
            return this.connectivity;
        }

        public final void setConnectivity(String connectivity) {
            this.connectivity = connectivity;
        }

        @Override
        public final Builder connectivity(String connectivity) {
            this.connectivity = connectivity;
            return this;
        }

        @Override
        public final Builder connectivity(XksProxyConnectivityType connectivity) {
            this.connectivity(connectivity == null ? null : connectivity.toString());
            return this;
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final String getUriEndpoint() {
            return this.uriEndpoint;
        }

        public final void setUriEndpoint(String uriEndpoint) {
            this.uriEndpoint = uriEndpoint;
        }

        @Override
        public final Builder uriEndpoint(String uriEndpoint) {
            this.uriEndpoint = uriEndpoint;
            return this;
        }

        public final String getUriPath() {
            return this.uriPath;
        }

        public final void setUriPath(String uriPath) {
            this.uriPath = uriPath;
        }

        @Override
        public final Builder uriPath(String uriPath) {
            this.uriPath = uriPath;
            return this;
        }

        public final String getVpcEndpointServiceName() {
            return this.vpcEndpointServiceName;
        }

        public final void setVpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
        }

        @Override
        public final Builder vpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
            return this;
        }

        public XksProxyConfigurationType build() {
            return new XksProxyConfigurationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, XksProxyConfigurationType> {
        public Builder connectivity(String var1);

        public Builder connectivity(XksProxyConnectivityType var1);

        public Builder accessKeyId(String var1);

        public Builder uriEndpoint(String var1);

        public Builder uriPath(String var1);

        public Builder vpcEndpointServiceName(String var1);
    }
}

